/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.dnssd;

import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.SortedSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.events.ContainerConnectedEvent;
import org.eclipse.ecf.core.events.ContainerConnectingEvent;
import org.eclipse.ecf.core.events.IContainerEvent;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.discovery.DiscoveryContainerConfig;
import org.eclipse.ecf.discovery.IServiceInfo;
import org.eclipse.ecf.discovery.IServiceProperties;
import org.eclipse.ecf.discovery.ServiceInfo;
import org.eclipse.ecf.discovery.ServiceProperties;
import org.eclipse.ecf.discovery.identity.IServiceID;
import org.eclipse.ecf.discovery.identity.IServiceTypeID;
import org.eclipse.ecf.provider.dnssd.DnsSdDiscoveryContainerAdapter;
import org.eclipse.ecf.provider.dnssd.DnsSdServiceTypeID;
import org.eclipse.ecf.provider.dnssd.Messages;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Name;
import org.xbill.DNS.PTRRecord;
import org.xbill.DNS.Record;
import org.xbill.DNS.ResolverConfig;
import org.xbill.DNS.SRVRecord;
import org.xbill.DNS.SimpleResolver;
import org.xbill.DNS.TXTRecord;

public class DnsSdDiscoveryLocator
extends DnsSdDiscoveryContainerAdapter {
    private static final String DNS_SD_PATH = "path";
    private static final String DNS_SD_PTCL = "dns-sd.ptcl";

    public DnsSdDiscoveryLocator() {
        super("ecf.namespace.dnssd", new DiscoveryContainerConfig(IDFactory.getDefault().createStringID(DnsSdDiscoveryLocator.class.getName())));
    }

    @Override
    public IServiceInfo getServiceInfo(IServiceID aServiceId) {
        Assert.isNotNull((Object)aServiceId);
        IServiceInfo[] services = this.getServices(aServiceId.getServiceTypeID());
        int i = 0;
        while (i < services.length) {
            IServiceInfo iServiceInfo = services[i];
            if (iServiceInfo.getServiceID().equals((Object)aServiceId)) {
                return iServiceInfo;
            }
            ++i;
        }
        return null;
    }

    @Override
    public IServiceTypeID[] getServiceTypes() {
        DnsSdServiceTypeID serviceTypeId = this.targetID;
        return this.getServiceTypes(serviceTypeId);
    }

    private IServiceTypeID[] getServiceTypes(DnsSdServiceTypeID serviceTypeId) {
        ArrayList<DnsSdServiceTypeID> result = new ArrayList<DnsSdServiceTypeID>();
        Record[] queryResult = this.getRecords(serviceTypeId);
        int j = 0;
        while (j < queryResult.length) {
            Record record = queryResult[j];
            if (record instanceof PTRRecord) {
                PTRRecord ptrRecord = (PTRRecord)record;
                result.add(new DnsSdServiceTypeID(this.getServicesNamespace(), ptrRecord.getTarget()));
            } else if (record instanceof SRVRecord) {
                SRVRecord srvRecord = (SRVRecord)record;
                result.add(new DnsSdServiceTypeID(this.getServicesNamespace(), srvRecord.getName()));
            }
            ++j;
        }
        return result.toArray(new IServiceTypeID[result.size()]);
    }

    @Override
    public IServiceInfo[] getServices() {
        return this.getServices(this.targetID);
    }

    @Override
    public IServiceInfo[] getServices(IServiceTypeID aServiceTypeId) {
        Assert.isNotNull((Object)aServiceTypeId);
        DnsSdServiceTypeID serviceTypeId = (DnsSdServiceTypeID)aServiceTypeId;
        SortedSet srvRecords = this.getSRVRecords(serviceTypeId.getInternalQueries());
        List serviceInfos = this.getServiceInfos(srvRecords);
        return serviceInfos.toArray(new IServiceInfo[serviceInfos.size()]);
    }

    private List getServiceInfos(Collection srvQueryResult) {
        ArrayList<ServiceInfo> infos = new ArrayList<ServiceInfo>();
        for (SRVRecord srvRecord : srvQueryResult) {
            long ttl = srvRecord.getTTL();
            int priority = srvRecord.getPriority();
            int weight = srvRecord.getWeight();
            int port = srvRecord.getPort();
            Name target = srvRecord.getTarget();
            String host = target.toString();
            host = host.substring(0, host.length() - 1);
            DnsSdServiceTypeID aServiceTypeID = new DnsSdServiceTypeID(this.getConnectNamespace(), srvRecord.getName());
            Properties props = new Properties();
            Lookup txtQuery = new Lookup(srvRecord.getName(), 16);
            txtQuery.setResolver(this.resolver);
            Record[] txtQueryResults = txtQuery.run();
            int length = txtQueryResults == null ? 0 : txtQueryResults.length;
            int l = 0;
            while (l < length) {
                TXTRecord txtResult = (TXTRecord)txtQueryResults[l];
                List strings = txtResult.getStrings();
                for (String str : strings) {
                    String[] split = str.split("=");
                    props.put(split[0], split[1]);
                }
                ++l;
            }
            String path = props.getProperty(DNS_SD_PATH);
            String proto = props.getProperty(DNS_SD_PTCL) == null ? aServiceTypeID.getProtocols()[0] : props.getProperty(DNS_SD_PTCL);
            URI uri = URI.create(proto + "://" + host + ":" + port + (path == null ? "" : path));
            ServiceInfo info = new ServiceInfo(uri, host, (IServiceTypeID)aServiceTypeID, priority, weight, (IServiceProperties)new ServiceProperties(props), ttl);
            infos.add(info);
        }
        return infos;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void connect(ID aTargetID, IConnectContext connectContext) throws ContainerConnectException {
        if (this.targetID != null || this.getConfig() == null) {
            throw new ContainerConnectException(Messages.DnsSdDiscoveryLocator_Container_Already_Connected);
        }
        if (aTargetID == null || !(aTargetID instanceof DnsSdServiceTypeID)) {
            ResolverConfig config = new ResolverConfig();
            List searchPaths = config.searchPath();
            if (searchPaths.isEmpty()) throw new ContainerConnectException(Messages.DnsSdDiscoveryLocator_No_Target_ID);
            this.targetID = new DnsSdServiceTypeID();
            this.targetID.setSearchPath(searchPaths.toArray(new Name[searchPaths.size()]));
        } else {
            Namespace ns = this.getConnectNamespace();
            try {
                this.targetID = (DnsSdServiceTypeID)ns.createInstance(new Object[]{aTargetID});
            }
            catch (IDCreateException e) {
                throw new ContainerConnectException((Throwable)e);
            }
        }
        if (this.resolver == null) {
            try {
                this.resolver = new SimpleResolver();
            }
            catch (UnknownHostException e) {
                throw new ContainerConnectException((Throwable)e);
            }
        }
        this.targetID.addSearchPath(this.getBrowsingDomains(this.targetID));
        this.fireContainerEvent((IContainerEvent)new ContainerConnectingEvent(this.getID(), (ID)this.targetID, (Object)connectContext));
        this.fireContainerEvent((IContainerEvent)new ContainerConnectedEvent(this.getID(), (ID)this.targetID));
    }

    private String[] getBrowsingDomains(IServiceTypeID aServiceTypeId) {
        String[] rrs = new String[]{"b._dns-sd", "db._dns-sd"};
        Collection res = this.getBrowsingOrRegistrationDomains(aServiceTypeId, rrs);
        return res.toArray(new String[res.size()]);
    }

    public String getContainerName() {
        return "ecf.discovery.dnssd.locator";
    }
}

