/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.export.transform;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.polarsys.reqcycle.export.transform.IRequirementProvider;
import org.polarsys.reqcycle.repository.data.RequirementSourceConf.RequirementSource;
import org.polarsys.reqcycle.repository.data.RequirementSourceData.Requirement;

public class RequirementSourceReqProvider
implements IRequirementProvider {
    private RequirementSource source;

    public RequirementSourceReqProvider(RequirementSource source) {
        this.source = source;
    }

    @Override
    public Iterable<Requirement> getRequirements() {
        return Lists.newArrayList((Iterator)Iterators.filter((Iterator)this.source.getContents().eAllContents(), Requirement.class));
    }

    @Override
    public String getLabel() {
        return this.source.getName();
    }

    @Override
    public Map<String, String> getMetadata() {
        HashMap map = Maps.newHashMap();
        map.put("DataSource URI", this.source.getDataModelURI());
        return map;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RequirementSourceReqProvider) {
            RequirementSourceReqProvider scope = (RequirementSourceReqProvider)obj;
            return scope.source.equals(this.source);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.source.hashCode();
    }
}

