/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.document.traceability;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.kitalpha.doc.doc2model.common.Common.ContentElement;
import org.polarsys.kitalpha.doc.doc2model.common.Common.DocumentModel;
import org.polarsys.kitalpha.doc.doc2model.core.Doc2Model;
import org.polarsys.kitalpha.doc.doc2model.wordprocessor.wordprocessor.Cell;
import org.polarsys.kitalpha.doc.doc2model.wordprocessor.wordprocessor.Row;
import org.polarsys.kitalpha.doc.doc2model.wordprocessor.wordprocessor.SectionContents;
import org.polarsys.reqcycle.document.traceability.DocumentElement;
import org.polarsys.reqcycle.document.traceability.DocumentTrace;
import org.polarsys.reqcycle.repository.data.IDataManager;
import org.polarsys.reqcycle.repository.data.RequirementSourceConf.RequirementSource;
import org.polarsys.reqcycle.repository.data.RequirementSourceData.AbstractElement;
import org.polarsys.reqcycle.repository.data.RequirementSourceData.Requirement;
import org.polarsys.reqcycle.repository.data.RequirementSourceData.Section;
import org.polarsys.reqcycle.uri.IReachableCreator;
import org.polarsys.reqcycle.utils.configuration.IConfigurationManager;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class DocumentAnalyzer
extends DocumentElement {
    private List<DocumentTrace> traces = new ArrayList<DocumentTrace>();
    @Inject
    IReachableCreator creator;
    IConfigurationManager configurationManager = (IConfigurationManager)ZigguratInject.make(IConfigurationManager.class);
    IDataManager reqSourcesManager = (IDataManager)ZigguratInject.make(IDataManager.class);

    public DocumentAnalyzer(String aName, IResource res) {
        super(aName, res);
        if (res instanceof IFile) {
            this.parseResourceFrom((IFile)res, this);
        }
    }

    private void parseResourceFrom(IFile file, DocumentElement element) {
        String targetReqID = null;
        String sourceReqID = null;
        String SourceReqIdRegEx = "(Practice|Need|Rex)_\\w+";
        String endSourceReq = "]";
        String nextSourceReq = "[";
        String TargetReqIdStart = "#";
        String TargetReqIdRegEx = "(Practice|Need|Rex)_\\w+";
        StringBuffer document = this.getDocumentFromModele(file);
        Pattern pattern = Pattern.compile("(" + SourceReqIdRegEx + ")" + endSourceReq, 8);
        Matcher matcher = pattern.matcher(document);
        String docToAnalyse = "";
        while (matcher.find()) {
            if (matcher.groupCount() > 0) {
                sourceReqID = matcher.group(1);
                docToAnalyse = document.substring(document.indexOf(sourceReqID) + 1);
                int nextReqPosition = docToAnalyse.indexOf(nextSourceReq);
                if (nextReqPosition >= 1) {
                    docToAnalyse = docToAnalyse.substring(0, nextReqPosition);
                }
                Pattern tracePattern = Pattern.compile(String.valueOf(TargetReqIdStart) + "(" + TargetReqIdRegEx + ")", 8);
                Matcher traceMatcher = tracePattern.matcher(docToAnalyse);
                while (traceMatcher.find()) {
                    if (traceMatcher.groupCount() <= 0) continue;
                    targetReqID = traceMatcher.group(1);
                    this.createTraceBetweenDocReq(targetReqID.trim(), sourceReqID.trim(), file);
                }
                continue;
            }
            System.out.println("could not find matching element for " + matcher + "on pattern " + pattern);
        }
    }

    protected StringBuffer getDocumentFromModele(IFile file) {
        StringBuffer doc = new StringBuffer();
        String location = file.getFullPath().toOSString();
        URI fileURI = URI.createPlatformResourceURI((String)location, (boolean)true);
        String fileString = CommonPlugin.asLocalURI((URI)fileURI).toFileString();
        Doc2Model doc2model = new Doc2Model();
        String fileType = doc2model.getFileType(fileString);
        ArrayList<Section> sections = new ArrayList<Section>();
        if (fileType != null && fileType.length() > 0) {
            DocumentModel result = (DocumentModel)doc2model.transform(fileString, DocumentModel.class).getDocModel();
            if (result == null) {
                return new StringBuffer("");
            }
            ArrayList<ContentElement> listContentElement = new ArrayList<ContentElement>();
            TreeIterator i = result.eAllContents();
            while (i.hasNext()) {
                EObject e = (EObject)i.next();
                if (e instanceof ContentElement && !(e instanceof SectionContents)) {
                    ContentElement content = (ContentElement)e;
                    listContentElement.add(content);
                    doc.append(content.getTextContent());
                }
                if (e instanceof SectionContents || e instanceof Row || e instanceof Cell) {
                    doc.append(" ");
                }
                if (!(e instanceof Section)) continue;
                Section section = (Section)e;
                sections.add(section);
            }
        }
        return doc;
    }

    private void createTraceBetweenDocReq(String targetReqID, String sourceReqID, IFile file) {
        String targetReqURI = this.getURIFromReqID(targetReqID);
        if (targetReqURI == "") {
            System.out.println("requirement with ID " + targetReqID + " has not been registered in ReqCycle. Can not create a trace to it.");
            return;
        }
        String sourceReqURI = this.getURIFromReqID(sourceReqID);
        if (sourceReqURI == "") {
            System.out.println("requirement with ID " + sourceReqID + " has not been registered in ReqCycle. Can not create a trace from it.");
            return;
        }
        DocumentTrace trace = new DocumentTrace("TRACE", sourceReqURI, targetReqURI, "TRACE" + System.nanoTime(), (IResource)file);
        this.traces.add(trace);
    }

    private String getURIFromReqID(String reqID) {
        String reqDataSource = this.findRequirementSourceForReqID(reqID);
        if (reqDataSource.equals("")) {
            System.out.println(" could not find requirement data source for req ID " + reqID);
            return "";
        }
        String reqURI = "reqcycle://" + reqDataSource + "#" + reqID;
        return reqURI;
    }

    private String findRequirementSourceForReqID(String reqID) {
        if (this.reqSourcesManager != null) {
            Set reqSources = this.reqSourcesManager.getRequirementSources();
            for (RequirementSource reqSource : reqSources) {
                String reqSourceName = reqSource.getName();
                boolean found = this.findReqIdInList((EList<AbstractElement>)reqSource.getRequirements(), reqID);
                if (!found) continue;
                return reqSourceName;
            }
        } else {
            System.out.println(" reqSourcesManager is null");
        }
        return "";
    }

    private boolean findReqIdInList(EList<AbstractElement> requirements, String reqID) {
        boolean found = false;
        for (AbstractElement ae : requirements) {
            Section section;
            AbstractElement abstractElement = ae;
            if (abstractElement instanceof Requirement) {
                Requirement req = (Requirement)abstractElement;
                if (reqID.equals(req.getId())) {
                    return true;
                }
                found = this.findReqIdInList((EList<AbstractElement>)req.getChildren(), reqID);
                if (found) {
                    return true;
                }
            }
            if (!(abstractElement instanceof Section) || !(found = this.findReqIdInList((EList<AbstractElement>)(section = (Section)abstractElement).getChildren(), reqID))) continue;
            return true;
        }
        return false;
    }

    private <T extends EObject> T resolveProxy(T obj) {
        if (obj.eIsProxy() && obj.eResource() != null) {
            EObject newObj = EcoreUtil.resolve(obj, (ResourceSet)obj.eResource().getResourceSet());
            return (T)newObj;
        }
        return obj;
    }

    public List<DocumentTrace> getTraces() {
        return this.traces;
    }

    public static void main(String[] args) {
        File file = new File(args[0]);
        IFile f = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(file.getPath()));
        new DocumentAnalyzer("test", (IResource)f);
    }
}

