/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.utils;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.polarsys.reqcycle.traceability.model.Link;
import org.polarsys.reqcycle.traceability.model.Pair;
import org.polarsys.reqcycle.uri.model.Reachable;

public class LazyMap
implements Multimap<Reachable, Link> {
    Multimap<Reachable, Link> delegate = HashMultimap.create();
    private Iterator<Pair<Link, Reachable>> resultOfEngine;
    private Pair<Link, Reachable> next;

    public LazyMap(Iterator<Pair<Link, Reachable>> resultOfEngine) {
        this.resultOfEngine = resultOfEngine;
        if (resultOfEngine.hasNext()) {
            this.next = resultOfEngine.next();
            Reachable first = this.getSource(this.next);
            Predicate equalTo = Predicates.equalTo((Object)first);
            this.addIf((Predicate<Reachable>)equalTo, (Predicate<Reachable>)Predicates.not((Predicate)equalTo));
        }
    }

    public void addUntil(Predicate<Reachable> predicateToReach, Predicate<Reachable> predicateToLeave) {
        boolean reached = false;
        while (this.resultOfEngine.hasNext()) {
            this.next = this.resultOfEngine.next();
            Reachable tmp = this.getSource(this.next);
            this.delegate.put((Object)tmp, (Object)this.next.getFirst());
            if (!reached && predicateToReach.apply((Object)tmp)) {
                reached = true;
            }
            if (reached && predicateToLeave.apply((Object)tmp)) break;
        }
    }

    public void addIf(Predicate<Reachable> firstCondition, Predicate<Reachable> predicateToLeave) {
        boolean first = true;
        while (this.resultOfEngine.hasNext()) {
            this.next = this.resultOfEngine.next();
            Reachable tmp = this.getSource(this.next);
            this.delegate.put((Object)tmp, (Object)this.next.getFirst());
            if (first && !firstCondition.apply((Object)tmp) || !(first = false) && predicateToLeave.apply((Object)tmp)) break;
        }
    }

    public Reachable getSource(Pair<Link, Reachable> pair) {
        return pair.getFirst().getSources().iterator().next();
    }

    public Map<Reachable, Collection<Link>> asMap() {
        return this.delegate.asMap();
    }

    public void clear() {
        this.delegate.clear();
    }

    public boolean containsEntry(Object arg0, Object arg1) {
        return this.delegate.containsEntry(arg0, arg1);
    }

    public boolean containsKey(Object arg0) {
        return this.delegate.containsKey(arg0);
    }

    public boolean containsValue(Object arg0) {
        return this.delegate.containsValue(arg0);
    }

    public Collection<Map.Entry<Reachable, Link>> entries() {
        return this.delegate.entries();
    }

    public Collection<Link> get(Reachable arg0) {
        Collection result = this.delegate.get((Object)arg0);
        if (result.isEmpty()) {
            Predicate equalTo = Predicates.equalTo((Object)arg0);
            this.addUntil((Predicate<Reachable>)equalTo, (Predicate<Reachable>)Predicates.not((Predicate)equalTo));
        }
        return result;
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public Set<Reachable> keySet() {
        return this.delegate.keySet();
    }

    public Multiset<Reachable> keys() {
        return this.delegate.keys();
    }

    public boolean put(Reachable arg0, Link arg1) {
        return this.delegate.put((Object)arg0, (Object)arg1);
    }

    public boolean putAll(Multimap<? extends Reachable, ? extends Link> arg0) {
        return this.delegate.putAll(arg0);
    }

    public boolean putAll(Reachable arg0, Iterable<? extends Link> arg1) {
        return this.delegate.putAll((Object)arg0, arg1);
    }

    public boolean remove(Object arg0, Object arg1) {
        return this.delegate.remove(arg0, arg1);
    }

    public Collection<Link> removeAll(Object arg0) {
        return this.delegate.removeAll(arg0);
    }

    public Collection<Link> replaceValues(Reachable arg0, Iterable<? extends Link> arg1) {
        return this.delegate.replaceValues((Object)arg0, arg1);
    }

    public int size() {
        return this.delegate.size();
    }

    public Collection<Link> values() {
        return this.delegate.values();
    }
}

