/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.repository.connector.document.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.polarsys.reqcycle.inittypes.inittypes.Attribute;
import org.polarsys.reqcycle.inittypes.inittypes.Requirement;
import org.polarsys.reqcycle.inittypes.inittypes.Type;
import org.polarsys.reqcycle.repository.connector.document.DocConnector;
import org.polarsys.reqcycle.repository.connector.document.DocUtils;
import org.polarsys.reqcycle.repository.connector.ui.wizard.pages.IUpdatablePage;
import org.polarsys.reqcycle.repository.data.types.IAttribute;
import org.polarsys.reqcycle.repository.data.types.IRequirementType;
import org.polarsys.reqcycle.repository.data.types.IType;

public class DocMappingPage
extends WizardPage
implements Listener,
IUpdatablePage {
    private Table tableRequirements;
    private ComboViewer cvTypeFile;
    private TableViewer tvRequirements;
    private Table tableAttributes;
    private TableViewer tvAttributes;
    private TableViewerColumn tvcAttributesNames;
    private TableViewerColumn tvcAttributesTypes;
    private Collection<IAttribute> confAttributes = new ArrayList<IAttribute>();
    private final Image reqFound = DocUtils.getImage("signed_yes.gif");
    private final Image reqNotFound = DocUtils.getImage("signed_no.gif");
    private final Image attNotFound = DocUtils.getImage("warning.gif");
    private DocConnector.DOCSettingBean bean;
    private Combo cTypeFile;

    public DocMappingPage(DocConnector.DOCSettingBean bean) {
        super("Document Connector Mapping");
        this.setTitle("Connector document: mapping page");
        this.bean = bean;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        this.setControl((Control)composite);
        Label lblTypeFile = new Label(composite, 0);
        lblTypeFile.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblTypeFile.setText("Select a type");
        this.cvTypeFile = new ComboViewer(composite, 8);
        this.cTypeFile = this.cvTypeFile.getCombo();
        this.cTypeFile.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.cvTypeFile.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.cvTypeFile.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Type) {
                    DocMappingPage.this.bean.setType((Type)element);
                    return ((Type)element).getName();
                }
                return super.getText(element);
            }
        });
        this.cvTypeFile.setInput(this.bean.getListType());
        Label lhorizSeparator = new Label(composite, 258);
        lhorizSeparator.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
        Label lblReqType = new Label(composite, 0);
        lblReqType.setText("Requirements");
        new Label(composite, 0);
        new Label(composite, 0);
        Composite compositeReq = new Composite(composite, 0);
        compositeReq.setLayout((Layout)new GridLayout(1, false));
        compositeReq.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.tvRequirements = new TableViewer(compositeReq, 2048);
        this.tableRequirements = this.tvRequirements.getTable();
        this.tableRequirements.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.tableRequirements.setHeaderVisible(true);
        this.tableRequirements.setLinesVisible(true);
        this.tvRequirements.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        TableViewerColumn tableViewerColumn = new TableViewerColumn(this.tvRequirements, 0);
        TableColumn tblclmnName = tableViewerColumn.getColumn();
        tblclmnName.setWidth(514);
        tblclmnName.setMoveable(true);
        tblclmnName.setText("Name");
        tableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Requirement) {
                    return ((Requirement)element).getNameReq();
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                if (element instanceof Requirement) {
                    for (IType req : DocMappingPage.this.getTypes()) {
                        if (!req.getName().equals(((Requirement)element).getNameReq())) continue;
                        return DocMappingPage.this.reqFound;
                    }
                    return DocMappingPage.this.reqNotFound;
                }
                return super.getImage(element);
            }
        });
        Label lblAttributeType = new Label(composite, 0);
        lblAttributeType.setText("Attributes");
        new Label(composite, 0);
        new Label(composite, 0);
        Composite compositeAttribute = new Composite(composite, 0);
        compositeAttribute.setLayout((Layout)new GridLayout(1, false));
        compositeAttribute.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.tvAttributes = new TableViewer(compositeAttribute, 67584);
        this.tvAttributes.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableAttributes = this.tvAttributes.getTable();
        this.tableAttributes.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.tableAttributes.setHeaderVisible(true);
        this.tableAttributes.setLinesVisible(true);
        this.tvcAttributesNames = this.createTableViewerColumn(this.tvAttributes, "Name", 0);
        this.tvcAttributesNames.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Attribute) {
                    return ((Attribute)element).getNameAttribute();
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                if (element instanceof Attribute) {
                    if (DocMappingPage.this.confAttributes != null) {
                        for (IAttribute att : DocMappingPage.this.confAttributes) {
                            if (!att.getName().equals(((Attribute)element).getNameAttribute())) continue;
                            return DocMappingPage.this.reqFound;
                        }
                    }
                    return DocMappingPage.this.attNotFound;
                }
                return super.getImage(element);
            }
        });
        this.tvcAttributesTypes = this.createTableViewerColumn(this.tvAttributes, "Attribute check", 0);
        this.tvcAttributesTypes.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Attribute) {
                    if (DocMappingPage.this.confAttributes != null) {
                        for (IAttribute att : DocMappingPage.this.confAttributes) {
                            if (!att.getName().equals(((Attribute)element).getNameAttribute())) continue;
                            return "OK";
                        }
                    }
                    return "Warning, this attribute is not found in a configuration";
                }
                return super.getText(element);
            }
        });
        this.hookListeners();
    }

    private void hookListeners() {
        this.cvTypeFile.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object obj;
                DocMappingPage.this.setErrorMessage(null);
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) instanceof Type) {
                    EList requirements = ((Type)obj).getRequirements();
                    DocMappingPage.this.tvRequirements.setInput((Object)requirements);
                    DocMappingPage.this.tvAttributes.setInput(null);
                    if (DocMappingPage.this.getTypes() != null) {
                        DocMappingPage.this.bean.setListValideRequirements((List<Requirement>)requirements);
                    }
                }
                DocMappingPage.this.getWizard().getContainer().updateButtons();
                DocMappingPage.this.getWizard().getContainer().updateMessage();
            }
        });
        this.tvRequirements.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object obj;
                DocMappingPage.this.setErrorMessage(null);
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) instanceof Requirement) {
                    DocMappingPage.this.fillValideAttributes((Requirement)obj);
                }
            }
        });
    }

    public boolean isPageComplete() {
        Boolean finish = true;
        StringBuffer error = new StringBuffer();
        if (this.cvTypeFile == null) {
            finish = false;
        } else if (this.cvTypeFile.getSelection().isEmpty()) {
            error.append("Choose a requirement type\n");
            finish = false;
        }
        if (!finish.booleanValue()) {
            this.setErrorMessage(error.toString());
        }
        return finish;
    }

    public void hasChanged() {
        if (this.cvTypeFile != null && (List)this.cvTypeFile.getInput() != this.bean.getListType()) {
            this.cvTypeFile.setInput(this.bean.getListType());
            this.tvRequirements.setInput(null);
            this.tvAttributes.setInput(null);
            this.setErrorMessage(null);
        } else if (this.cvTypeFile != null && this.bean.getDataModel() != null) {
            EList requirements = ((Type)((IStructuredSelection)this.cvTypeFile.getSelection()).getFirstElement()).getRequirements();
            this.tvRequirements.setInput((Object)requirements);
            this.fillValideAttributes((Requirement)((IStructuredSelection)this.tvRequirements.getSelection()).getFirstElement());
        }
    }

    public TableViewerColumn createTableViewerColumn(TableViewer viewer, String title, int style) {
        TableViewerColumn viewerColumn = new TableViewerColumn(viewer, style);
        TableColumn column = viewerColumn.getColumn();
        column.setWidth(168);
        column.setText(title);
        column.setResizable(true);
        column.setMoveable(true);
        return viewerColumn;
    }

    private Collection<IType> getTypes() {
        if (this.bean != null) {
            return this.bean.getDataModel().getTypes();
        }
        return null;
    }

    private void fillValideAttributes(Requirement requr) {
        Boolean notFound = false;
        for (IType reqType : this.getTypes()) {
            if (!(reqType instanceof IRequirementType)) continue;
            IRequirementType req = (IRequirementType)reqType;
            if (requr == null || !req.getName().equals(requr.getNameReq())) continue;
            this.confAttributes.addAll(req.getAttributes());
            notFound = true;
            break;
        }
        if (!notFound.booleanValue()) {
            this.setErrorMessage("This requirement is not found in a data type configuration");
            this.tvAttributes.setInput(null);
        } else {
            EList attributes = requr.getAttributesReq();
            this.tvAttributes.setInput((Object)attributes);
        }
    }

    public ComboViewer getCvTypeFile() {
        return this.cvTypeFile;
    }

    public void setCvTypeFile(ComboViewer cvTypeFile) {
        this.cvTypeFile = cvTypeFile;
    }

    public TableViewer getTvRequirement() {
        return this.tvRequirements;
    }

    public void setTvRequirement(TableViewer tvRequirement) {
        this.tvRequirements = tvRequirement;
    }

    public void handleEvent(Event event) {
    }
}

