/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.nls.bundle.pure.field;

import java.text.MessageFormat;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.nls.Messages;
import org.eclipse.wb.internal.core.nls.bundle.AbstractBundleSource;
import org.eclipse.wb.internal.core.nls.bundle.AbstractBundleSourceNewComposite;
import org.eclipse.wb.internal.core.nls.bundle.pure.field.FieldSource;
import org.eclipse.wb.internal.core.nls.bundle.pure.field.SourceParameters;
import org.eclipse.wb.internal.core.nls.edit.IEditableSource;
import org.eclipse.wb.internal.core.utils.dialogfields.StringDialogField;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;

public class FieldSourceNewComposite
extends AbstractBundleSourceNewComposite {
    private StringDialogField m_fieldNameField;
    private static final String KEY_FIELD_NAME = "KEY_FIELD_NAME";

    public FieldSourceNewComposite(Composite parent, int style, JavaInfo root) {
        super(parent, style, root);
        this.createFieldGroup();
        this.createPropertyGroup();
        this.m_fieldNameField.setText("BUNDLE");
        this.initializePropertyGroup();
    }

    private void createFieldGroup() {
        Group fieldGroup = new Group((Composite)this, 0);
        fieldGroup.setLayoutData((Object)new GridData(768));
        fieldGroup.setLayout((Layout)new GridLayout(3, false));
        fieldGroup.setText(Messages.FieldSourceNewComposite_fieldGroup);
        this.m_fieldNameField = new StringDialogField();
        this.m_fieldNameField.setDialogFieldListener(this.m_validateListener);
        this.m_fieldNameField.setLabelText(Messages.FieldSourceNewComposite_fieldNameLabel);
        this.createTextFieldControls((Composite)fieldGroup, this.m_fieldNameField, 3);
    }

    @Override
    protected void validateAll() {
        this.validateFieldName();
        super.validateAll();
    }

    private void validateFieldName() {
        final String fieldName = this.m_fieldNameField.getText();
        final boolean[] hasSuchName = new boolean[1];
        this.m_editor.getAstUnit().accept(new ASTVisitor(){

            public void endVisit(SimpleName node) {
                hasSuchName[0] = hasSuchName[0] | node.getIdentifier().equals(fieldName);
            }
        });
        if (hasSuchName[0]) {
            this.setInvalid(KEY_FIELD_NAME, MessageFormat.format(Messages.FieldSourceNewComposite_validateFieldExists, fieldName));
            return;
        }
        IStatus status = JavaConventions.validateFieldName((String)fieldName);
        if (!status.isOK()) {
            this.setStatus(KEY_FIELD_NAME, status);
            return;
        }
        this.setValid(KEY_FIELD_NAME);
    }

    public static String getTitle() {
        return Messages.FieldSourceNewComposite_title;
    }

    @Override
    public String getSample() {
        return "private static final BUNDLE = ResourceBundle.getBundle(\"full.bundle.name\");\n...\nbutton.setText( BUNDLE.getString(\"some.key\") );";
    }

    @Override
    public IEditableSource createEditableSource(Object o) {
        SourceParameters parameters = (SourceParameters)o;
        try {
            IEditableSource editableSource;
            if (parameters.m_propertyFileExists) {
                String fieldName = this.m_fieldNameField.getText();
                FieldSource source = new FieldSource(this.m_root, parameters.m_propertyBundleName, fieldName);
                editableSource = source.getEditable();
            } else {
                editableSource = this.createEmptyEditable(parameters.m_propertyBundleName);
            }
            editableSource.setKeyGeneratorStrategy(AbstractBundleSource.KEY_GENERATOR);
            return editableSource;
        }
        catch (Throwable e) {
            throw ReflectionUtils.propagate((Throwable)e);
        }
    }

    @Override
    public Object createParametersObject() throws Exception {
        SourceParameters parameters = new SourceParameters();
        parameters.m_fieldName = this.m_fieldNameField.getText();
        this.fillPropertyParameters(parameters);
        return parameters;
    }
}

