/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.nls;

import java.util.Calendar;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.nls.Messages;
import org.eclipse.wb.internal.core.nls.NlsSupport;
import org.eclipse.wb.internal.core.nls.model.AbstractSource;
import org.eclipse.wb.internal.core.nls.model.LocaleInfo;
import org.eclipse.wb.internal.core.nls.ui.LocaleUtils;
import org.eclipse.wb.internal.core.nls.ui.NlsDialog;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;

public final class ExternalizeStringsContributionItem
extends ContributionItem {
    private JavaInfo m_root;
    private ToolItem m_toolItem;
    private Menu m_menu;

    public void setRoot(JavaInfo root) {
        this.m_root = root;
        this.displayCurrentLocale();
    }

    public void fill(final ToolBar parent, int index) {
        this.m_toolItem = new ToolItem(parent, 4);
        if (this.isSpecialTime()) {
            this.m_toolItem.setImage(DesignerPlugin.getImage((String)"nls/ms16.png"));
            this.m_toolItem.setToolTipText("Back in USSR");
        } else {
            this.m_toolItem.setImage(DesignerPlugin.getImage((String)"nls/globe3.png"));
            this.m_toolItem.setToolTipText(Messages.ExternalizeStringsContributionItem_externalizeToolTip);
        }
        this.m_toolItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ExternalizeStringsContributionItem.this.handleClick(parent, event);
            }
        });
    }

    public void dispose() {
        super.dispose();
    }

    private void handleClick(final ToolBar parent, final Event event) {
        ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                if (event.detail == 4 && !ArrayUtils.isEmpty((Object[])ExternalizeStringsContributionItem.this.getLocales())) {
                    Rectangle bounds = ExternalizeStringsContributionItem.this.m_toolItem.getBounds();
                    Point point = parent.toDisplay(bounds.x, bounds.y + bounds.height);
                    ExternalizeStringsContributionItem.this.createMenu((Composite)parent);
                    ExternalizeStringsContributionItem.this.m_menu.setLocation(point);
                    ExternalizeStringsContributionItem.this.m_menu.setVisible(true);
                } else {
                    ExternalizeStringsContributionItem.this.openNLSDialog();
                }
            }
        });
    }

    private void createMenu(Composite parent) throws Exception {
        LocaleInfo[] locales;
        if (this.m_menu != null) {
            this.m_menu.dispose();
        }
        this.m_menu = new Menu((Control)parent);
        LocaleInfo currentLocale = AbstractSource.getLocaleInfo(this.m_root);
        LocaleInfo[] localeInfoArray = locales = this.getLocales();
        int n = locales.length;
        int n2 = 0;
        while (n2 < n) {
            final LocaleInfo locale = localeInfoArray[n2];
            final MenuItem menuItem = new MenuItem(this.m_menu, 16);
            menuItem.setImage(LocaleUtils.getImage(locale));
            menuItem.setText(locale.getTitle());
            menuItem.setSelection(locale.equals(currentLocale));
            menuItem.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    if (menuItem.getSelection()) {
                        AbstractSource.setLocaleInfo(ExternalizeStringsContributionItem.this.m_root, locale);
                        ExternalizeStringsContributionItem.this.setCurrentLocale(locale);
                    }
                }
            });
            ++n2;
        }
    }

    private LocaleInfo[] getLocales() throws Exception {
        NlsSupport support = NlsSupport.get(this.m_root);
        return support.getLocales();
    }

    private void openNLSDialog() throws Exception {
        boolean isDefaultPackage;
        boolean bl = isDefaultPackage = this.m_root.getEditor().getModelUnit().getPackageDeclarations().length == 0;
        if (isDefaultPackage) {
            MessageDialog.openError((Shell)DesignerPlugin.getShell(), (String)Messages.ExternalizeStringsContributionItem_defaultPackageTitle, (String)Messages.ExternalizeStringsContributionItem_defaultPackageMessage);
        } else {
            NlsDialog dialog = new NlsDialog(DesignerPlugin.getShell(), this.m_root);
            if (dialog.open() != 0) {
                return;
            }
            if (JavaInfoUtils.getState(this.m_root).isDisposed()) {
                return;
            }
            this.updateCurrentLocale();
        }
    }

    private void displayCurrentLocale() {
        ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                if (NlsSupport.get(ExternalizeStringsContributionItem.this.m_root).getLocales().length == 0) {
                    ExternalizeStringsContributionItem.this.m_toolItem.setImage(DesignerPlugin.getImage((String)(!ExternalizeStringsContributionItem.this.isSpecialTime() ? "nls/globe3.png" : "nls/ms16.png")));
                    ExternalizeStringsContributionItem.this.m_toolItem.setText("");
                } else {
                    LocaleInfo locale = AbstractSource.getLocaleInfo(ExternalizeStringsContributionItem.this.m_root);
                    ExternalizeStringsContributionItem.this.m_toolItem.setImage(LocaleUtils.getImage(locale));
                    ExternalizeStringsContributionItem.this.m_toolItem.setText(locale.getTitle());
                }
            }
        });
    }

    private void updateCurrentLocale() {
        ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                NlsSupport support = NlsSupport.get(ExternalizeStringsContributionItem.this.m_root);
                if (support.getSources().length == 0) {
                    return;
                }
                Object locale = AbstractSource.getLocaleInfo(ExternalizeStringsContributionItem.this.m_root);
                Object[] locales = support.getLocales();
                if (!ArrayUtils.contains((Object[])locales, (Object)locale)) {
                    locale = locales[0];
                }
                ExternalizeStringsContributionItem.this.setCurrentLocale((LocaleInfo)locale);
            }
        });
    }

    private void setCurrentLocale(final LocaleInfo locale) {
        ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                AbstractSource.setLocaleInfo(ExternalizeStringsContributionItem.this.m_root, locale);
                ExternalizeStringsContributionItem.this.displayCurrentLocale();
                ExternalizeStringsContributionItem.this.m_root.refresh();
            }
        });
    }

    private boolean isSpecialTime() {
        int month = Calendar.getInstance().get(2);
        int day = Calendar.getInstance().get(5);
        int hour = Calendar.getInstance().get(11);
        return month == 4 && day == 1 && hour > 16;
    }
}

