/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.generic.core.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourcePathComputerDelegate;
import org.eclipse.debug.core.sourcelookup.containers.FolderSourceContainer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerUtil;

public class GenericServerSourcePathComputerDelegate
implements ISourcePathComputerDelegate {
    public ISourceContainer[] computeSourceContainers(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        IRuntimeClasspathEntry[] unresolvedEntries = JavaRuntime.computeUnresolvedSourceLookupPath((ILaunchConfiguration)configuration);
        ArrayList<ISourceContainer> sourcefolderList = new ArrayList<ISourceContainer>();
        IServer server = ServerUtil.getServer((ILaunchConfiguration)configuration);
        IModule[] modules = server.getModules();
        ArrayList<IJavaProject> javaProjectList = new ArrayList<IJavaProject>();
        this.processModules(sourcefolderList, modules, javaProjectList, server, monitor);
        IRuntimeClasspathEntry[] projectEntries = new IRuntimeClasspathEntry[javaProjectList.size()];
        int i = 0;
        while (i < javaProjectList.size()) {
            projectEntries[i] = JavaRuntime.newDefaultProjectClasspathEntry((IJavaProject)((IJavaProject)javaProjectList.get(i)));
            ++i;
        }
        IRuntimeClasspathEntry[] entries = new IRuntimeClasspathEntry[projectEntries.length + unresolvedEntries.length];
        System.arraycopy(unresolvedEntries, 0, entries, 0, unresolvedEntries.length);
        System.arraycopy(projectEntries, 0, entries, unresolvedEntries.length, projectEntries.length);
        IRuntimeClasspathEntry[] resolved = JavaRuntime.resolveSourceLookupPath((IRuntimeClasspathEntry[])entries, (ILaunchConfiguration)configuration);
        ISourceContainer[] javaSourceContainers = JavaRuntime.getSourceContainers((IRuntimeClasspathEntry[])resolved);
        if (!sourcefolderList.isEmpty()) {
            ISourceContainer[] combinedSourceContainers = new ISourceContainer[javaSourceContainers.length + sourcefolderList.size()];
            sourcefolderList.toArray(combinedSourceContainers);
            System.arraycopy(javaSourceContainers, 0, combinedSourceContainers, sourcefolderList.size(), javaSourceContainers.length);
            javaSourceContainers = combinedSourceContainers;
        }
        return javaSourceContainers;
    }

    private void processModules(List<ISourceContainer> sourcefolderList, IModule[] modules, List<IJavaProject> javaProjectList, IServer server, IProgressMonitor monitor) {
        int i = 0;
        while (i < modules.length) {
            IProject project = modules[i].getProject();
            IModule[] pModule = new IModule[]{modules[i]};
            IModule[] cModule = server.getChildModules(pModule, monitor);
            if (cModule != null && cModule.length > 0) {
                this.processModules(sourcefolderList, cModule, javaProjectList, server, monitor);
            }
            if (project != null) {
                IFolder moduleFolder = project.getFolder(modules[i].getName());
                if (moduleFolder.exists()) {
                    sourcefolderList.add((ISourceContainer)new FolderSourceContainer((IContainer)moduleFolder, true));
                } else {
                    try {
                        IJavaProject javaProject;
                        if (project.hasNature("org.eclipse.jdt.core.javanature") && !javaProjectList.contains(javaProject = (IJavaProject)project.getNature("org.eclipse.jdt.core.javanature"))) {
                            javaProjectList.add(javaProject);
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            ++i;
        }
    }
}

