/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.lml.ui.providers.support;

import org.eclipse.ptp.rm.lml.core.LMLManager;
import org.eclipse.ptp.rm.lml.core.elements.ObjectType;
import org.eclipse.ptp.rm.lml.core.model.ObjectStatus;

public class EventForwarder
implements ObjectStatus.Updatable {
    private final LMLManager lmlManager = LMLManager.getInstance();
    private ObjectType lastChanged;
    private boolean wasMouseOver;
    private boolean wasMouseDown;

    public void updateStatus(ObjectType object, boolean mouseOver, boolean mouseDown) {
        if (object == null || object.getId() == null) {
            return;
        }
        String oid = object.getId();
        if (mouseOver) {
            this.lmlManager.selectObject(oid);
        }
        if (mouseDown) {
            this.lmlManager.markObject(oid);
        }
        if (this.lastChanged == object) {
            if (this.wasMouseOver && !mouseOver) {
                this.lmlManager.unselectObject(oid);
            }
            if (this.wasMouseOver && mouseOver && this.wasMouseDown && !mouseDown) {
                this.lmlManager.unmarkObject(oid);
            }
        }
        this.lastChanged = object;
        this.wasMouseOver = mouseOver;
        this.wasMouseDown = mouseDown;
    }
}

