/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.breakpointactions;

import java.io.ByteArrayOutputStream;
import java.io.StringReader;
import java.text.MessageFormat;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.cdt.debug.core.CDIDebugModel;
import org.eclipse.cdt.debug.core.breakpointactions.AbstractBreakpointAction;
import org.eclipse.cdt.debug.core.breakpointactions.IResumeActionEnabler;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.debug.ui.breakpointactions.Messages;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.IBreakpoint;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class ResumeAction
extends AbstractBreakpointAction {
    static final int INCRIMENT_MSEC = 100;
    int pauseTime = 0;

    public IStatus execute(IBreakpoint breakpoint, IAdaptable context, IProgressMonitor monitor) {
        Status errorStatus = null;
        long endTime = System.currentTimeMillis() + (long)(this.getPauseTime() * 1000);
        IResumeActionEnabler enabler = (IResumeActionEnabler)context.getAdapter(IResumeActionEnabler.class);
        if (enabler != null) {
            try {
                monitor.beginTask(this.getName(), this.getPauseTime() * 1000 / 100);
                long currentTime = System.currentTimeMillis();
                while (!monitor.isCanceled() && currentTime < endTime) {
                    monitor.setTaskName(MessageFormat.format(Messages.getString("ResumeAction.SummaryResumeTime"), (endTime - currentTime) / 1000L));
                    monitor.worked(1);
                    Thread.sleep(100L);
                    currentTime = System.currentTimeMillis();
                }
                if (!monitor.isCanceled()) {
                    monitor.setTaskName(Messages.getString("ResumeAction.SummaryImmediately"));
                    enabler.resume();
                }
                monitor.worked(1);
            }
            catch (Exception e) {
                errorStatus = new Status(4, CDIDebugModel.getPluginIdentifier(), 10002, e.getMessage(), (Throwable)e);
            }
        } else {
            errorStatus = new Status(4, CDebugUIPlugin.getUniqueIdentifier(), 150, Messages.getString("ResumeAction.error.0"), null);
        }
        if (errorStatus != null) {
            MultiStatus ms = new MultiStatus(CDIDebugModel.getPluginIdentifier(), 10002, Messages.getString("ResumeAction.error.1"), null);
            ms.add((IStatus)errorStatus);
            errorStatus = ms;
        } else {
            errorStatus = monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
        }
        return errorStatus;
    }

    public String getDefaultName() {
        return Messages.getString("ResumeAction.UntitledName");
    }

    public int getPauseTime() {
        return this.pauseTime;
    }

    public void setPauseTime(int pauseTime) {
        this.pauseTime = pauseTime;
    }

    public String getIdentifier() {
        return "org.eclipse.cdt.debug.ui.breakpointactions.ResumeAction";
    }

    public String getMemento() {
        String resumeData = "";
        DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = null;
        try {
            docBuilder = dfactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element rootElement = doc.createElement("resumeData");
            rootElement.setAttribute("pauseTime", Integer.toString(this.pauseTime));
            doc.appendChild(rootElement);
            ByteArrayOutputStream s = new ByteArrayOutputStream();
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(doc);
            StreamResult outputTarget = new StreamResult(s);
            transformer.transform(source, outputTarget);
            resumeData = s.toString("UTF8");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resumeData;
    }

    public String getSummary() {
        if (this.pauseTime == 0) {
            return Messages.getString("ResumeAction.SummaryImmediately");
        }
        return MessageFormat.format(Messages.getString("ResumeAction.SummaryResumeTime"), this.pauseTime);
    }

    public String getTypeName() {
        return Messages.getString("ResumeAction.TypeName");
    }

    public void initializeFromMemento(String data) {
        Element root = null;
        try {
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            parser.setErrorHandler(new DefaultHandler());
            root = parser.parse(new InputSource(new StringReader(data))).getDocumentElement();
            String value = root.getAttribute("pauseTime");
            if (value == null) {
                throw new Exception();
            }
            this.pauseTime = Integer.parseInt(value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

