/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.function;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.wst.xml.xpath2.api.EvaluationContext;
import org.eclipse.wst.xml.xpath2.api.Item;
import org.eclipse.wst.xml.xpath2.api.ResultBuffer;
import org.eclipse.wst.xml.xpath2.api.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.internal.function.Function;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyAtomicType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NodeType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;

public class FnData
extends Function {
    public FnData() {
        super(new QName("data"), 1);
    }

    public ResultSequence evaluate(Collection args, EvaluationContext ec) {
        assert (args.size() >= this.min_arity() && args.size() <= this.max_arity());
        ResultSequence argument = (ResultSequence)args.iterator().next();
        return FnData.atomize(argument);
    }

    public static ResultSequence atomize(ResultSequence arg) {
        ResultBuffer rs = new ResultBuffer();
        Iterator<Item> i = arg.iterator();
        while (i.hasNext()) {
            AnyType at = (AnyType)i.next();
            if (at instanceof AnyAtomicType) {
                rs.add(at);
                continue;
            }
            if (at instanceof NodeType) {
                NodeType nt = (NodeType)at;
                rs.concat(nt.typed_value());
                continue;
            }
            assert (false);
        }
        return rs.getSequence();
    }

    public static AnyType atomize(Item arg) {
        if (arg instanceof AnyAtomicType) {
            return (AnyAtomicType)arg;
        }
        if (arg instanceof NodeType) {
            NodeType nt = (NodeType)arg;
            return (AnyType)nt.typed_value().first();
        }
        assert (false);
        return null;
    }
}

