/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.launch;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.tcf.debug.ITCFLaunchProjectBuilder;
import org.eclipse.tcf.internal.debug.launch.TCFLaunchProjectBuilder;
import org.eclipse.tcf.internal.debug.launch.TCFLocalAgent;
import org.eclipse.tcf.internal.debug.model.TCFLaunch;
import org.eclipse.tcf.internal.debug.model.TCFMemoryRegion;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.JSON;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IMemoryMap;
import org.eclipse.tcf.util.TCFPathMapRule;
import org.eclipse.tcf.util.TCFTask;
import org.osgi.framework.Bundle;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TCFLaunchDelegate
extends LaunchConfigurationDelegate {
    public static final String ATTR_PEER_ID = "org.eclipse.tcf.debug.PeerID";
    public static final String ATTR_PROJECT_NAME = "org.eclipse.tcf.debug.ProjectName";
    public static final String ATTR_BUILD_BEFORE_LAUNCH = "org.eclipse.tcf.debug.BuildBeforeLaunch";
    public static final String ATTR_PROJECT_BUILD_CONFIG_ID = "org.eclipse.tcf.debug.ProjectBuildConfigID";
    public static final String ATTR_PROJECT_BUILD_CONFIG_AUTO = "org.eclipse.tcf.debug.ProjectBuildConfigAuto";
    public static final String ATTR_LOCAL_PROGRAM_FILE = "org.eclipse.tcf.debug.LocalProgramFile";
    public static final String ATTR_REMOTE_PROGRAM_FILE = "org.eclipse.tcf.debug.ProgramFile";
    public static final String ATTR_COPY_TO_REMOTE_FILE = "org.eclipse.tcf.debug.CopyToRemote";
    public static final String ATTR_PROGRAM_ARGUMENTS = "org.eclipse.tcf.debug.ProgramArguments";
    public static final String ATTR_WORKING_DIRECTORY = "org.eclipse.tcf.debug.WorkingDirectory";
    public static final String ATTR_ATTACH_CHILDREN = "org.eclipse.tcf.debug.AttachChildren";
    public static final String ATTR_STOP_AT_ENTRY = "org.eclipse.tcf.debug.StopAtEntry";
    public static final String ATTR_STOP_AT_MAIN = "org.eclipse.tcf.debug.StopAtMain";
    public static final String ATTR_DISCONNECT_ON_CTX_EXIT = "org.eclipse.tcf.debug.DisconnectOnCtxExit";
    public static final String ATTR_TERMINATE_ON_DISCONNECT = "org.eclipse.tcf.debug.TerminateOnDisconnect";
    public static final String ATTR_USE_TERMINAL = "org.eclipse.tcf.debug.UseTerminal";
    public static final String ATTR_RUN_LOCAL_SERVER = "org.eclipse.tcf.debug.RunLocalServer";
    public static final String ATTR_RUN_LOCAL_AGENT = "org.eclipse.tcf.debug.RunLocalAgent";
    public static final String ATTR_USE_LOCAL_AGENT = "org.eclipse.tcf.debug.UseLocalAgent";
    public static final String ATTR_SIGNALS_DONT_STOP = "org.eclipse.tcf.debug.SignalsDontStop";
    public static final String ATTR_SIGNALS_DONT_PASS = "org.eclipse.tcf.debug.SignalsDontPass";
    public static final String ATTR_FILES = "org.eclipse.tcf.debug.Files";
    public static final String ATTR_PATH_MAP = "org.eclipse.tcf.debug.PathMap";
    public static final String ATTR_MEMORY_MAP = "org.eclipse.tcf.debug.MemoryMap";
    public static final String ATTR_ATTACH_PATH = "org.eclipse.tcf.debug.Attach";
    public static final String ATTR_USE_CONTEXT_FILTER = "org.eclipse.tcf.debug.UseContextFilter";
    public static final String ATTR_CAPTURE_STDIN_FILE = "org.eclipse.debug.ui.ATTR_CAPTURE_STDIN_FILE";
    public static final String ATTR_CAPTURE_STDOUT_FILE = "org.eclipse.debug.ui.ATTR_CAPTURE_IN_FILE";
    public static final String ATTR_APPEND_TO_FILE = "org.eclipse.debug.ui.ATTR_APPEND_TO_FILE";
    public static final int BUILD_BEFORE_LAUNCH_USE_WORKSPACE_SETTING = 0;
    public static final int BUILD_BEFORE_LAUNCH_DISABLED = 1;
    public static final String FILES_CONTEXT_FULL_NAME = "Context";
    public static final String FILES_CONTEXT_ID = "ContextID";
    public static final String FILES_FILE_NAME = "File";
    public static final String FILES_LOAD_SYMBOLS = "LoadSymbols";
    public static final String FILES_RELOCATE = "Relocate";
    public static final String FILES_ADDRESS = "Addr";
    public static final String FILES_OFFSET = "Offs";
    public static final String FILES_SIZE = "Size";
    public static final String FILES_DOWNLOAD = "Download";
    public static final String FILES_SET_PC = "SetPC";
    public static final String FILES_ENABLE_OSA = "EnableOSA";
    private static Boolean is_headless;
    private static boolean ui_activation_done;

    public static ArrayList<PathMapRule> parsePathMapAttribute(String s) {
        ArrayList<PathMapRule> map = new ArrayList<PathMapRule>();
        StringBuffer bf = new StringBuffer();
        int i = 0;
        block0: while (i < s.length()) {
            PathMapRule e = new PathMapRule(new LinkedHashMap<String, Object>());
            block1: while (i < s.length()) {
                char ch;
                if ((ch = s.charAt(i++)) == '|') {
                    map.add(e);
                    continue block0;
                }
                bf.setLength(0);
                bf.append(ch);
                while (i < s.length()) {
                    if ((ch = s.charAt(i++)) == '=') break;
                    bf.append(ch);
                }
                String nm = bf.toString();
                bf.setLength(0);
                while (i < s.length()) {
                    if ((ch = s.charAt(i++)) == '|') {
                        if (bf.length() <= 0) continue block1;
                        e.getProperties().put(nm, bf.toString());
                        continue block1;
                    }
                    if (ch == '\\') {
                        int n = 0;
                        while (i < s.length()) {
                            char d;
                            if ((d = s.charAt(i++)) == ';') break;
                            n = n * 10 + (d - 48);
                        }
                        bf.append((char)n);
                        continue;
                    }
                    bf.append(ch);
                }
            }
        }
        return map;
    }

    public static ArrayList<PathMapRule> parseSourceLocatorMemento(String s) throws CoreException {
        ArrayList<PathMapRule> map = new ArrayList<PathMapRule>();
        if (s == null || s.length() == 0) {
            return map;
        }
        Element root = DebugPlugin.parseDocument((String)s);
        NodeList list = root.getChildNodes();
        int length = list.getLength();
        int i = 0;
        while (i < length) {
            Element entry;
            Node node = list.item(i);
            short type = node.getNodeType();
            if (type == 1 && (entry = (Element)node).getNodeName().equalsIgnoreCase("sourceContainers")) {
                TCFLaunchDelegate.parseSourceContainers(map, entry);
            }
            ++i;
        }
        return map;
    }

    private static void parseSourceContainers(ArrayList<PathMapRule> map, Element element) throws CoreException {
        NodeList list = element.getChildNodes();
        int length = list.getLength();
        int i = 0;
        while (i < length) {
            Element entry;
            String memento;
            Node node = list.item(i);
            short type = node.getNodeType();
            if (type == 1 && (memento = (entry = (Element)node).getAttribute("memento")) != null && memento.length() > 0) {
                TCFLaunchDelegate.readSourceContainer(map, memento);
            }
            ++i;
        }
    }

    private static void readSourceContainer(ArrayList<PathMapRule> map, String s) throws CoreException {
        Element root = null;
        try {
            root = DebugPlugin.parseDocument((String)s);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (root == null) {
            return;
        }
        if ("mapping".equals(root.getNodeName())) {
            NodeList list = root.getChildNodes();
            int length = list.getLength();
            int i = 0;
            while (i < length) {
                String memento;
                Element entry;
                Node node = list.item(i);
                short type = node.getNodeType();
                if (type == 1 && (entry = (Element)node).getNodeName().equalsIgnoreCase("mapEntry") && (memento = entry.getAttribute("memento")) != null && memento.length() > 0) {
                    Element map_entry = DebugPlugin.parseDocument((String)memento);
                    String src = map_entry.getAttribute("backendPath");
                    String dst = map_entry.getAttribute("localPath");
                    if (src != null) {
                        src = src.replace('\\', '/');
                    }
                    LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
                    props.put("Source", src);
                    props.put("Destination", dst);
                    map.add(new PathMapRule(props));
                }
                ++i;
            }
        }
    }

    public static void parseMemMapsAttribute(Map<String, ArrayList<IMemoryMap.MemoryRegion>> maps, String s) throws Exception {
        if (s == null || s.length() == 0) {
            return;
        }
        Collection list = (Collection)JSON.parseOne((byte[])s.getBytes("UTF-8"));
        if (list == null) {
            return;
        }
        for (Map map : list) {
            String id = (String)map.get("ID");
            if (id == null) continue;
            ArrayList<Object> l = maps.get(id);
            if (l == null) {
                l = new ArrayList();
                maps.put(id, l);
            }
            l.add((IMemoryMap.MemoryRegion)new TCFMemoryRegion(map));
        }
    }

    public static void getMemMapsAttribute(Map<String, ArrayList<IMemoryMap.MemoryRegion>> maps, ILaunchConfiguration cfg) throws Exception {
        String maps_cfg = cfg.getAttribute(ATTR_MEMORY_MAP, null);
        TCFLaunchDelegate.parseMemMapsAttribute(maps, maps_cfg);
    }

    public static String getProgramPath(String project_name, String program_name) {
        if (program_name == null || program_name.length() == 0) {
            return null;
        }
        if (project_name == null || project_name.length() == 0) {
            File file = new File(program_name);
            if (!file.isAbsolute()) {
                File ws = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile();
                file = new File(ws, program_name);
            }
            return file.getAbsolutePath();
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(project_name);
        Path program_path = new Path(program_name);
        if (!program_path.isAbsolute()) {
            if (project == null || !project.getFile(program_name).exists()) {
                return null;
            }
            program_path = project.getFile(program_name).getLocation();
        }
        return program_path.toOSString();
    }

    /*
     * Unable to fully structure code
     */
    public static Set<Integer> readSigSet(String s) {
        block8: {
            block9: {
                set = new HashSet<Integer>();
                l = s.length();
                i = 0;
                while (i < l && s.charAt(i) == ' ') {
                    ++i;
                }
                if (i >= l || s.charAt(i) != '[') break block9;
                do {
                    ++i;
                    n = 0;
                    while (i < l && s.charAt(i) == ' ') {
                        ++i;
                    }
                    if (i < l && s.charAt(i) >= '0' && s.charAt(i) <= '9') ** GOTO lbl17
                    break block8;
lbl-1000:
                    // 1 sources

                    {
                        n = n * 10 + (s.charAt(i++) - 48);
lbl17:
                        // 2 sources

                        ** while (i < l && s.charAt((int)i) >= '0' && s.charAt((int)i) <= '9')
                    }
lbl18:
                    // 1 sources

                    set.add(n);
                    while (i < l && s.charAt(i) == ' ') {
                        ++i;
                    }
                } while (i < l && s.charAt(i) == ',');
                break block8;
            }
            if (i < l) {
                n = Integer.parseInt(s, 16);
                m = 0;
                while (m < 31) {
                    if ((n & 1 << m) != 0) {
                        set.add(m);
                    }
                    ++m;
                }
            }
        }
        return set;
    }

    public static String writeSigSet(Set<Integer> s) {
        StringBuffer buf = new StringBuffer();
        buf.append('[');
        for (int n : s) {
            if (buf.length() > 1) {
                buf.append(',');
            }
            buf.append(n);
        }
        buf.append(']');
        return buf.toString();
    }

    protected IProject[] getBuildOrder(ILaunchConfiguration configuration, String mode) throws CoreException {
        ITCFLaunchProjectBuilder builder = TCFLaunchProjectBuilder.getLaunchProjectBuilder(configuration);
        if (builder != null) {
            return builder.getBuildOrder(configuration, mode);
        }
        String name = configuration.getAttribute(ATTR_PROJECT_NAME, "");
        if (name.length() == 0) {
            return null;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        if (project == null) {
            return null;
        }
        return new IProject[]{project};
    }

    public boolean buildForLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        int build = configuration.getAttribute(ATTR_BUILD_BEFORE_LAUNCH, 0);
        if (build == 1) {
            return false;
        }
        ITCFLaunchProjectBuilder builder = TCFLaunchProjectBuilder.getLaunchProjectBuilder(configuration);
        if (builder != null) {
            return builder.buildForLaunch(configuration, mode, monitor);
        }
        return super.buildForLaunch(configuration, mode, monitor);
    }

    public ILaunch getLaunch(final ILaunchConfiguration configuration, final String mode) throws CoreException {
        return (ILaunch)new TCFTask<ILaunch>(){
            int cnt;

            public void run() {
                if (is_headless == null) {
                    Bundle b = Platform.getBundle((String)"org.eclipse.ui.workbench");
                    is_headless = new Boolean(b == null || b.getState() != 32);
                }
                if (!is_headless.booleanValue() && !ui_activation_done) {
                    try {
                        Bundle bundle = Platform.getBundle((String)"org.eclipse.tcf.debug.ui");
                        bundle.start(1);
                    }
                    catch (Throwable x) {
                        Protocol.log((String)"TCF debugger UI startup error", (Throwable)x);
                    }
                    ui_activation_done = true;
                }
                if (this.cnt++ < 2) {
                    Protocol.invokeLater((Runnable)((Object)this));
                } else {
                    this.done((Object)new TCFLaunch(configuration, mode));
                }
            }
        }.getE();
    }

    public void launch(ILaunchConfiguration configuration, final String mode, final ILaunch launch, final IProgressMonitor monitor) throws CoreException {
        String agent_id;
        String local_id = null;
        if (configuration.getAttribute(ATTR_RUN_LOCAL_AGENT, false)) {
            if (monitor != null) {
                monitor.subTask("Starting TCF Agent");
            }
            local_id = TCFLocalAgent.runLocalAgent("agent");
        } else if (configuration.getAttribute(ATTR_USE_LOCAL_AGENT, true)) {
            if (monitor != null) {
                monitor.subTask("Searching TCF Agent");
            }
            if ((local_id = TCFLocalAgent.getLocalAgentID("agent")) == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.tcf.debug", 0, "Cannot find TCF agent on the local host", null));
            }
        }
        String id = configuration.getAttribute(ATTR_USE_LOCAL_AGENT, true) ? local_id : configuration.getAttribute(ATTR_PEER_ID, "");
        boolean run_server = configuration.getAttribute(ATTR_RUN_LOCAL_SERVER, false);
        if (!run_server && id.indexOf(47) < 0) {
            agent_id = id;
            run_server = (Boolean)new TCFTask<Boolean>(){

                public void run() {
                    IPeer peer = (IPeer)Protocol.getLocator().getPeers().get(agent_id);
                    this.done(peer != null && peer.getAttributes().get("NeedSyms") != null);
                }
            }.getE();
        }
        if (run_server) {
            if (monitor != null) {
                monitor.subTask("Starting TCF Server");
            }
            String server_id = TCFLocalAgent.runLocalAgent("server");
            id = String.valueOf(server_id) + "/" + id;
        }
        agent_id = id;
        new TCFTask<Boolean>(){

            public void run() {
                ((TCFLaunch)launch).launchTCF(mode, agent_id, this, monitor);
            }
        }.getE();
    }

    public static class PathMapRule
    extends TCFPathMapRule {
        public PathMapRule(Map<String, Object> props) {
            super(props);
        }

        public boolean equals(Object obj) {
            boolean equal = super.equals(obj);
            if (!equal && obj instanceof PathMapRule) {
                return this.toString().equals(((PathMapRule)((Object)obj)).toString());
            }
            return equal;
        }

        public String toString() {
            StringBuffer bf = new StringBuffer();
            Map props = this.getProperties();
            Object[] keySet = props.keySet().toArray(new String[props.size()]);
            Arrays.sort(keySet);
            Object[] objectArray = keySet;
            int n = keySet.length;
            int n2 = 0;
            while (n2 < n) {
                Object nm = objectArray[n2];
                Object o = props.get(nm);
                if (o != null) {
                    bf.append((String)nm);
                    bf.append('=');
                    String s = o.toString();
                    int i = 0;
                    while (i < s.length()) {
                        char ch = s.charAt(i);
                        if (ch >= ' ' && ch != '|' && ch != '\\') {
                            bf.append(ch);
                        } else {
                            bf.append('\\');
                            bf.append((int)ch);
                            bf.append(';');
                        }
                        ++i;
                    }
                    bf.append('|');
                }
                ++n2;
            }
            bf.append('|');
            return bf.toString();
        }
    }
}

