/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.model;

import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.tcf.debug.ui.ITCFAnnotationProvider;
import org.eclipse.tcf.internal.debug.ui.Activator;
import org.osgi.framework.Bundle;

public class TCFAnnotationProvider {
    private static ArrayList<ITCFAnnotationProvider> providers;

    public static ITCFAnnotationProvider getAnnotationProvider(Object selection) {
        if (selection == null) {
            return null;
        }
        if (providers == null) {
            ArrayList<ITCFAnnotationProvider> list = new ArrayList<ITCFAnnotationProvider>();
            try {
                IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.tcf.debug.ui", "annotation_provider");
                IExtension[] extensions = point.getExtensions();
                int i = 0;
                while (i < extensions.length) {
                    try {
                        Bundle bundle = Platform.getBundle((String)extensions[i].getContributor().getName());
                        bundle.start(1);
                        IConfigurationElement[] e = extensions[i].getConfigurationElements();
                        int j = 0;
                        while (j < e.length) {
                            String nm = e[j].getName();
                            if (nm.equals("class")) {
                                Class c = bundle.loadClass(e[j].getAttribute("name"));
                                list.add((ITCFAnnotationProvider)c.newInstance());
                            }
                            ++j;
                        }
                    }
                    catch (Throwable x) {
                        Activator.log("Cannot access annotation provider extension points", x);
                    }
                    ++i;
                }
            }
            catch (Exception x) {
                Activator.log("Cannot access annotation provider extension points", x);
            }
            providers = list;
        }
        for (ITCFAnnotationProvider p : providers) {
            if (!p.isSupportedSelection(selection)) continue;
            return p;
        }
        return null;
    }
}

