/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.proxy.server.core;

import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.remote.internal.proxy.server.core.CommandServer;
import org.eclipse.remote.proxy.protocol.core.StreamChannel;
import org.eclipse.remote.proxy.protocol.core.StreamChannelManager;

public class Server {
    private volatile boolean running;
    private Thread serverThread;
    private StreamChannel cmdChannel;
    private Map<Integer, StreamChannel> auxChannel = Collections.synchronizedMap(new HashMap());

    public void start() {
        final StreamChannelManager mux = new StreamChannelManager(System.in, (OutputStream)System.out);
        mux.setServer(true);
        mux.addListener(new StreamChannelManager.IChannelListener(){

            public void newChannel(StreamChannel chan) {
                System.err.println("newChannel: " + chan.getId());
                if (Server.this.cmdChannel == null) {
                    Server.this.cmdChannel = chan;
                    CommandServer runnable = new CommandServer(chan, Server.this);
                    new Thread(runnable).start();
                } else {
                    Server.this.auxChannel.put(chan.getId(), chan);
                }
            }

            public void closeChannel(StreamChannel chan) {
                System.err.println("closeChannel: " + chan.getId());
                Server.this.auxChannel.remove(chan.getId());
            }
        });
        this.serverThread = new Thread((Runnable)mux){

            @Override
            public void run() {
                Server.this.running = true;
                mux.run();
                Server.this.running = false;
            }
        };
        this.serverThread.start();
    }

    public StreamChannel getChannel(int id) {
        System.err.println("getChannel: " + id);
        return this.auxChannel.get(id);
    }

    public void waitFor() {
        if (this.running && this.serverThread != null) {
            try {
                this.serverThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

