/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.dap;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Optional;
import org.eclipse.cdt.debug.dap.Activator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class InitializeLaunchConfigurations {
    private boolean alreadyWarned;
    private Runnable warnNodeJSMissing;

    public InitializeLaunchConfigurations(Runnable warnNodeJSMissing) {
        Assert.isNotNull((Object)warnNodeJSMissing);
        this.warnNodeJSMissing = warnNodeJSMissing;
    }

    public Optional<String> getVSCodeLocation(String appendPathSuffix) {
        String res = null;
        if (Platform.getOS().equals("linux")) {
            res = "/usr/share/code";
        } else if (Platform.getOS().equals("win32")) {
            res = "C:/Program Files (x86)/Microsoft VS Code";
        } else if (Platform.getOS().equals("macosx")) {
            res = "/Applications/Visual Studio Code.app";
            Path path = new Path(appendPathSuffix);
            if (path.segmentCount() > 1 && path.segment(0).equals("resources")) {
                path = path.removeFirstSegments(1);
                appendPathSuffix = new Path("/Contents/Resources").append((IPath)path).toOSString();
            }
        }
        if (res != null && new File(res).isDirectory()) {
            if (res.contains(" ") && Platform.getOS().equals("win32")) {
                return Optional.of("\"" + res + appendPathSuffix + "\"");
            }
            return Optional.of(String.valueOf(res) + appendPathSuffix);
        }
        return Optional.empty();
    }

    public Optional<String> getNodeJsLocation() {
        String nodeJsLocation = System.getProperty("org.eclipse.wildwebdeveloper.nodeJSLocation");
        if (nodeJsLocation != null && Files.exists(Paths.get(nodeJsLocation, new String[0]), new LinkOption[0])) {
            return Optional.of(nodeJsLocation);
        }
        String res = "/path/to/node";
        String[] command = new String[]{"/bin/bash", "-c", "which node"};
        if (Platform.getOS().equals("win32")) {
            command = new String[]{"cmd", "/c", "where node"};
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(Runtime.getRuntime().exec(command).getInputStream()));){
                res = reader.readLine();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), e.getMessage(), (Throwable)e));
        }
        if (res == null && Platform.getOS().equals("macosx")) {
            res = "/usr/local/bin/node";
        }
        if (res != null && Files.exists(Paths.get(res, new String[0]), new LinkOption[0])) {
            return Optional.of(res);
        }
        if (!this.alreadyWarned) {
            this.warnNodeJSMissing.run();
            this.alreadyWarned = true;
        }
        return Optional.empty();
    }
}

