/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.ui.queryresult;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import com.google.common.collect.TreeMultimap;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.viatra.query.patternlanguage.emf.specification.SpecificationBuilder;
import org.eclipse.viatra.query.patternlanguage.emf.ui.EMFPatternLanguageUIPlugin;
import org.eclipse.viatra.query.runtime.api.AdvancedViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngineLifecycleListener;
import org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher;
import org.eclipse.viatra.query.runtime.api.scope.QueryScope;
import org.eclipse.viatra.query.runtime.base.api.BaseIndexOptions;
import org.eclipse.viatra.query.runtime.emf.EMFScope;
import org.eclipse.viatra.query.runtime.extensibility.IQuerySpecificationProvider;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryEvaluationHint;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistry;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistryChangeListener;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistryEntry;
import org.eclipse.viatra.query.runtime.registry.IRegistryView;
import org.eclipse.viatra.query.runtime.registry.IRegistryViewFactory;
import org.eclipse.viatra.query.runtime.registry.view.AbstractRegistryView;
import org.eclipse.viatra.query.runtime.ui.modelconnector.IModelConnector;
import org.eclipse.viatra.query.tooling.ui.preferences.RuntimePreferencesInterpreter;
import org.eclipse.viatra.query.tooling.ui.queryregistry.index.IPatternBasedSpecificationProvider;
import org.eclipse.viatra.query.tooling.ui.queryresult.IQueryResultViewModelListener;
import org.eclipse.viatra.query.tooling.ui.queryresult.QueryResultTreeMatcher;
import org.eclipse.viatra.query.tooling.ui.util.IFilteredMatcherCollection;
import org.eclipse.viatra.query.tooling.ui.util.IFilteredMatcherContent;
import org.eclipse.viatra.transformation.evm.api.ActivationLifeCycle;
import org.eclipse.viatra.transformation.evm.api.ExecutionSchema;
import org.eclipse.viatra.transformation.evm.api.Job;
import org.eclipse.viatra.transformation.evm.api.RuleSpecification;
import org.eclipse.viatra.transformation.evm.api.Scheduler;
import org.eclipse.viatra.transformation.evm.api.resolver.ConflictResolver;
import org.eclipse.viatra.transformation.evm.specific.ExecutionSchemas;
import org.eclipse.viatra.transformation.evm.specific.Jobs;
import org.eclipse.viatra.transformation.evm.specific.Lifecycles;
import org.eclipse.viatra.transformation.evm.specific.Rules;
import org.eclipse.viatra.transformation.evm.specific.Schedulers;
import org.eclipse.viatra.transformation.evm.specific.crud.CRUDActivationStateEnum;
import org.eclipse.viatra.transformation.evm.specific.resolver.InvertedDisappearancePriorityConflictResolver;
import org.eclipse.viatra.transformation.evm.specific.scheduler.UpdateCompleteBasedScheduler;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;

public class QueryResultTreeInput
implements IFilteredMatcherCollection {
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private AdvancedViatraQueryEngine engine;
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private boolean readOnlyEngine;
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private boolean engineOperational;
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private Map<String, QueryResultTreeMatcher<?>> matchers;
    @Accessors(value={AccessorType.PUBLIC_GETTER, AccessorType.PROTECTED_SETTER})
    private IModelConnector modelConnector;
    private Table<String, String, IQuerySpecificationRegistryEntry> loadedEntries;
    private Multimap<String, String> knownErrorEntries;
    private SpecificationBuilder builder;
    private ExecutionSchema schema;
    private EngineLifecycleListener lifecycleListener;
    private RegistryChangeListener registryListener;
    private IRegistryView view;
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private QueryEvaluationHint hintForBackendSelection;
    private Set<IQueryResultViewModelListener> listeners;

    public QueryResultTreeInput(AdvancedViatraQueryEngine engine, IQuerySpecificationRegistry registry, boolean readOnlyEngine, QueryEvaluationHint hint) {
        EngineLifecycleListener _engineLifecycleListener;
        SpecificationBuilder _specificationBuilder;
        this.engine = engine;
        this.engineOperational = true;
        this.hintForBackendSelection = hint;
        this.readOnlyEngine = readOnlyEngine;
        this.matchers = Maps.newTreeMap();
        this.loadedEntries = HashBasedTable.create();
        this.knownErrorEntries = TreeMultimap.create();
        this.builder = _specificationBuilder = new SpecificationBuilder();
        this.listeners = Sets.newHashSet();
        UpdateCompleteBasedScheduler.UpdateCompleteBasedSchedulerFactory _queryEngineSchedulerFactory = Schedulers.getQueryEngineSchedulerFactory((ViatraQueryEngine)engine);
        InvertedDisappearancePriorityConflictResolver _invertedDisappearancePriorityConflictResolver = new InvertedDisappearancePriorityConflictResolver();
        this.schema = ExecutionSchemas.createViatraQueryExecutionSchema((ViatraQueryEngine)engine, (Scheduler.ISchedulerFactory)_queryEngineSchedulerFactory, (ConflictResolver)_invertedDisappearancePriorityConflictResolver);
        Consumer<ViatraQueryMatcher> _function = it -> this.createMatcher((ViatraQueryMatcher)it);
        engine.getCurrentMatchers().forEach(_function);
        this.schema.startUnscheduledExecution();
        this.lifecycleListener = _engineLifecycleListener = new EngineLifecycleListener(this);
        engine.addLifecycleListener((ViatraQueryEngineLifecycleListener)this.lifecycleListener);
        if (!readOnlyEngine) {
            RegistryChangeListener _registryChangeListener;
            this.registryListener = _registryChangeListener = new RegistryChangeListener(this);
            IRegistryViewFactory _function_1 = it -> new AbstractRegistryView(registry, true){

                protected boolean isEntryRelevant(IQuerySpecificationRegistryEntry entry) {
                    return true;
                }
            };
            this.view = registry.createView(_function_1);
            this.view.addViewListener((IQuerySpecificationRegistryChangeListener)this.registryListener);
        }
    }

    public QueryEvaluationHint setHint(QueryEvaluationHint hint) {
        QueryEvaluationHint _xblockexpression = null;
        Preconditions.checkNotNull((Object)hint);
        _xblockexpression = this.hintForBackendSelection = hint;
        return _xblockexpression;
    }

    public <MATCH extends IPatternMatch> QueryResultTreeMatcher<MATCH> createMatcher(ViatraQueryMatcher<MATCH> matcher) {
        QueryResultTreeMatcher treeMatcher = new QueryResultTreeMatcher(this, matcher);
        Consumer<IPatternMatch> _function = match -> {
            Consumer<IQueryResultViewModelListener> _function_1 = it -> it.matchAdded(treeMatcher, (IPatternMatch)match);
            this.listeners.forEach(_function_1);
        };
        Job matchCreatedJob = Jobs.newStatelessJob((CRUDActivationStateEnum)CRUDActivationStateEnum.CREATED, _function);
        Consumer<IPatternMatch> _function_1 = match -> {
            Consumer<IQueryResultViewModelListener> _function_2 = it -> it.matchUpdated(treeMatcher, (IPatternMatch)match);
            this.listeners.forEach(_function_2);
        };
        Job matchUpdatedJob = Jobs.newStatelessJob((CRUDActivationStateEnum)CRUDActivationStateEnum.UPDATED, _function_1);
        Consumer<IPatternMatch> _function_2 = match -> {
            Consumer<IQueryResultViewModelListener> _function_3 = it -> it.matchRemoved(treeMatcher, (IPatternMatch)match);
            this.listeners.forEach(_function_3);
        };
        Job matchDeletedJob = Jobs.newStatelessJob((CRUDActivationStateEnum)CRUDActivationStateEnum.DELETED, _function_2);
        RuleSpecification ruleSpec = Rules.newMatcherRuleSpecification(matcher, (ActivationLifeCycle)Lifecycles.getDefault((boolean)true, (boolean)true), Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new Job[]{matchCreatedJob, matchUpdatedJob, matchDeletedJob})));
        treeMatcher.setRuleSpec(ruleSpec);
        String fullyQualifiedName = matcher.getSpecification().getFullyQualifiedName();
        this.matchers.put(fullyQualifiedName, treeMatcher);
        Consumer<IQueryResultViewModelListener> _function_3 = it -> it.matcherAdded(treeMatcher);
        this.listeners.forEach(_function_3);
        this.schema.addRule(ruleSpec);
        return treeMatcher;
    }

    public Object addMatcherIfLoaded(IQuerySpecificationRegistryEntry entry) {
        Object _xifexpression = null;
        boolean _contains = this.loadedEntries.contains((Object)entry.getSourceIdentifier(), (Object)entry.getFullyQualifiedName());
        if (_contains) {
            _xifexpression = null;
        }
        return _xifexpression;
    }

    public Object removeMatcherIfLoaded(IQuerySpecificationRegistryEntry entry) {
        Object _xifexpression = null;
        boolean _contains = this.loadedEntries.contains((Object)entry.getSourceIdentifier(), (Object)entry.getFullyQualifiedName());
        if (_contains) {
            _xifexpression = null;
        }
        return _xifexpression;
    }

    public QueryResultTreeMatcher<?> removeMatcher(IQuerySpecificationRegistryEntry entry) {
        QueryResultTreeMatcher<?> treeMatcher = this.matchers.get(entry.getFullyQualifiedName());
        if (treeMatcher != null && Objects.equal((Object)treeMatcher.getEntry().getSourceIdentifier(), (Object)entry.getSourceIdentifier())) {
            return this.removeMatcher(treeMatcher);
        }
        return null;
    }

    public QueryResultTreeMatcher<?> removeMatcher(QueryResultTreeMatcher<?> matcher) {
        ViatraQueryMatcher<?> _matcher;
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals;
        this.matchers.remove(matcher.getEntry().getFullyQualifiedName());
        Consumer<IQueryResultViewModelListener> _function = it -> it.matcherRemoved(matcher);
        this.listeners.forEach(_function);
        RuleSpecification<?> _ruleSpec = matcher.getRuleSpec();
        boolean bl = _tripleNotEquals = _ruleSpec != null;
        if (_tripleNotEquals) {
            this.schema.removeRule(matcher.getRuleSpec());
        }
        boolean bl2 = _tripleNotEquals_1 = (_matcher = matcher.getMatcher()) != null;
        if (_tripleNotEquals_1) {
            this.builder.forgetSpecificationTransitively(matcher.getMatcher().getSpecification());
        } else {
            Consumer<IQuerySpecification> _function_1 = it -> this.builder.forgetSpecificationTransitively(it);
            this.builder.getSpecification(matcher.getEntry().getFullyQualifiedName()).ifPresent(_function_1);
        }
        return matcher;
    }

    public void loadQueries(Iterable<IQuerySpecificationRegistryEntry> entries) {
        SpecificationBuilder _specificationBuilder;
        if (this.readOnlyEngine) {
            throw new UnsupportedOperationException("Cannot load queries to read-only engine");
        }
        this.builder = _specificationBuilder = new SpecificationBuilder();
        Iterator<IQuerySpecificationRegistryEntry> iterator = entries.iterator();
        while (this.engineOperational && iterator.hasNext()) {
            IQuerySpecificationRegistryEntry entry = iterator.next();
            boolean _containsKey = this.matchers.containsKey(entry.getFullyQualifiedName());
            if (_containsKey) {
                this.removeMatcher(entry);
            }
            this.loadQuery(entry);
            this.loadedEntries.put((Object)entry.getSourceIdentifier(), (Object)entry.getFullyQualifiedName(), (Object)entry);
        }
        if (this.engineOperational) {
            this.schema.startUnscheduledExecution();
        }
    }

    private QueryResultTreeMatcher<?> loadQuery(IQuerySpecificationRegistryEntry entry) {
        String entryFQN;
        boolean _containsKey;
        QueryResultTreeMatcher<IPatternMatch> _xblockexpression = null;
        if (!this.engineOperational) {
            IllegalStateException _illegalStateException = new IllegalStateException("Query engine encountered a fatal error or has been disposed");
            this.addErroneousMatcher(entry, _illegalStateException);
        }
        if (_containsKey = this.matchers.containsKey(entryFQN = entry.getFullyQualifiedName())) {
            this.removeMatcher(entry);
        }
        QueryResultTreeMatcher<IPatternMatch> _xtrycatchfinallyexpression = null;
        try {
            IQuerySpecification<?> _specificationOfProvider;
            QueryResultTreeMatcher<IPatternMatch> _xblockexpression_1 = null;
            IQuerySpecification<?> specification = _specificationOfProvider = this.getSpecificationOfProvider(entry.getProvider());
            QueryResultTreeMatcher<IPatternMatch> _xifexpression = null;
            PQuery.PQueryStatus _status = specification.getInternalQueryRepresentation().getStatus();
            boolean _equals = Objects.equal((Object)_status, (Object)PQuery.PQueryStatus.ERROR);
            if (!_equals) {
                boolean _notEquals;
                QueryEvaluationHint currentHint = this.hintForBackendSelection.overrideBy(RuntimePreferencesInterpreter.getHintOverridesFromPreferences());
                ViatraQueryMatcher matcher = this.engine.getMatcher(specification, currentHint);
                String specificationFQN = specification.getFullyQualifiedName();
                QueryResultTreeMatcher<?> treeMatcher = this.matchers.get(specificationFQN);
                boolean bl = _notEquals = !Objects.equal((Object)specificationFQN, (Object)entryFQN);
                if (_notEquals) {
                    this.matchers.remove(specificationFQN);
                    this.matchers.put(entryFQN, treeMatcher);
                }
                treeMatcher.setEntry(entry);
                treeMatcher.setHint(currentHint);
                this.knownErrorEntries.remove((Object)entry.getSourceIdentifier(), (Object)entryFQN);
                return treeMatcher;
            }
            IllegalArgumentException _illegalArgumentException = new IllegalArgumentException("Query definition contains errors");
            _xifexpression = this.addErroneousMatcher(entry, _illegalArgumentException);
            _xtrycatchfinallyexpression = _xblockexpression_1 = _xifexpression;
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception ex = (Exception)_t;
                return this.addErroneousMatcher(entry, ex);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        _xblockexpression = _xtrycatchfinallyexpression;
        return _xblockexpression;
    }

    private QueryResultTreeMatcher<IPatternMatch> addErroneousMatcher(IQuerySpecificationRegistryEntry entry, Exception ex) {
        String entryFQN = entry.getFullyQualifiedName();
        QueryResultTreeMatcher<IPatternMatch> treeMatcher = new QueryResultTreeMatcher<IPatternMatch>(this, null);
        treeMatcher.setException(ex);
        treeMatcher.setEntry(entry);
        this.matchers.put(entryFQN, treeMatcher);
        Consumer<IQueryResultViewModelListener> _function = it -> it.matcherAdded(treeMatcher);
        this.listeners.forEach(_function);
        boolean _put = this.knownErrorEntries.put((Object)entry.getSourceIdentifier(), (Object)entryFQN);
        if (_put) {
            String logMessage = String.format("Query Explorer has encountered an error during evaluation of query %s: %s", entryFQN, ex.getMessage());
            EMFPatternLanguageUIPlugin.getInstance().logException(logMessage, ex);
        }
        return treeMatcher;
    }

    private IQuerySpecification<?> getSpecificationOfProvider(IQuerySpecificationProvider provider) {
        if (provider instanceof IPatternBasedSpecificationProvider) {
            IQuerySpecification<?> specification = ((IPatternBasedSpecificationProvider)provider).getSpecification(this.builder);
            return specification;
        }
        IQuerySpecification specification_1 = (IQuerySpecification)provider.get();
        return specification_1;
    }

    public boolean addListener(IQueryResultViewModelListener listener) {
        return this.listeners.add(listener);
    }

    public boolean removeListener(IQueryResultViewModelListener listener) {
        return this.listeners.remove(listener);
    }

    public IRegistryView dispose() {
        IRegistryView _xblockexpression = null;
        if (this.schema != null) {
            this.schema.dispose();
        }
        this.schema = null;
        if (this.engine != null) {
            this.engine.removeLifecycleListener((ViatraQueryEngineLifecycleListener)this.lifecycleListener);
        }
        this.engine = null;
        this.resetMatchers();
        this.listeners.clear();
        if (this.view != null) {
            this.view.removeViewListener((IQuerySpecificationRegistryChangeListener)this.registryListener);
        }
        this.view = null;
        _xblockexpression = null;
        return _xblockexpression;
    }

    protected void resetInput() {
        Consumer<QueryResultTreeMatcher> _function = it -> {
            boolean _tripleNotEquals;
            RuleSpecification _ruleSpec = it.getRuleSpec();
            boolean bl = _tripleNotEquals = _ruleSpec != null;
            if (_tripleNotEquals) {
                this.schema.removeRule(it.getRuleSpec());
            }
        };
        this.matchers.values().forEach(_function);
        this.resetMatchers();
        if (!this.readOnlyEngine) {
            this.engine.removeLifecycleListener((ViatraQueryEngineLifecycleListener)this.lifecycleListener);
            this.engine.wipe();
            this.engine.addLifecycleListener((ViatraQueryEngineLifecycleListener)this.lifecycleListener);
        }
    }

    protected void resetMatchers() {
        SpecificationBuilder _specificationBuilder;
        Consumer<QueryResultTreeMatcher> _function = matcher -> {
            Consumer<IQueryResultViewModelListener> _function_1 = it -> it.matcherRemoved((QueryResultTreeMatcher<?>)matcher);
            this.listeners.forEach(_function_1);
        };
        this.matchers.values().forEach(_function);
        this.builder = _specificationBuilder = new SpecificationBuilder();
        this.matchers.clear();
        this.loadedEntries.clear();
    }

    public BaseIndexOptions getBaseIndexOptions() {
        QueryScope _scope = this.engine.getScope();
        EMFScope emfScope = (EMFScope)_scope;
        return emfScope.getOptions();
    }

    @Override
    public Iterable<IFilteredMatcherContent<?>> getFilteredMatchers() {
        Functions.Function1 _function = matcher -> (IFilteredMatcherContent)matcher;
        return IterableExtensions.map((Iterable)Iterables.filter(this.matchers.values(), IFilteredMatcherContent.class), (Functions.Function1)_function);
    }

    public void matcherFilterUpdated(QueryResultTreeMatcher<?> matcher) {
        Consumer<IQueryResultViewModelListener> _function = it -> it.matcherFilterUpdated(matcher);
        this.listeners.forEach(_function);
    }

    @Pure
    public AdvancedViatraQueryEngine getEngine() {
        return this.engine;
    }

    @Pure
    public boolean isReadOnlyEngine() {
        return this.readOnlyEngine;
    }

    @Pure
    public boolean isEngineOperational() {
        return this.engineOperational;
    }

    @Pure
    public Map<String, QueryResultTreeMatcher<?>> getMatchers() {
        return this.matchers;
    }

    @Pure
    public IModelConnector getModelConnector() {
        return this.modelConnector;
    }

    protected void setModelConnector(IModelConnector modelConnector) {
        this.modelConnector = modelConnector;
    }

    @Pure
    public QueryEvaluationHint getHintForBackendSelection() {
        return this.hintForBackendSelection;
    }

    @FinalFieldsConstructor
    public static class EngineLifecycleListener
    implements ViatraQueryEngineLifecycleListener {
        private final QueryResultTreeInput input;

        public void engineBecameTainted(String message, Throwable t) {
            this.input.engineOperational = false;
            this.input.dispose();
        }

        public void engineDisposed() {
            this.input.engineOperational = false;
            this.input.dispose();
        }

        public void engineWiped() {
            this.input.resetInput();
        }

        public void matcherInstantiated(ViatraQueryMatcher<? extends IPatternMatch> matcher) {
            this.input.createMatcher(matcher);
        }

        public EngineLifecycleListener(QueryResultTreeInput input) {
            this.input = input;
        }
    }

    @FinalFieldsConstructor
    public static class RegistryChangeListener
    implements IQuerySpecificationRegistryChangeListener {
        private final QueryResultTreeInput input;

        public void entryAdded(IQuerySpecificationRegistryEntry entry) {
            this.input.addMatcherIfLoaded(entry);
        }

        public void entryRemoved(IQuerySpecificationRegistryEntry entry) {
            this.input.removeMatcherIfLoaded(entry);
        }

        public RegistryChangeListener(QueryResultTreeInput input) {
            this.input = input;
        }
    }
}

