/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.papyrus.infra.core.log.LogHelper;
import org.eclipse.papyrus.infra.widgets.util.ImageDescriptorManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    private static final String BUNDLEENTRY_PROTOCOL = "bundleentry://";
    public static final String PLUGIN_ID = "org.eclipse.papyrus.infra.widgets";
    public static final String UML_VIS_ICONS_16x16 = "icons/obj16/";
    public static final String DEFAULT_IMAGE = "icons/PapyrusLogo16x16.gif";
    private static final String PLUGIN_PROTOCOL = "platform:/plugin/";
    private static Activator plugin;
    public static LogHelper log;
    public ImageDescriptorManager imageDescriptorManager;
    private static final IEclipsePreferences ModelExplorerPreferences;
    private static final String PREF_FILTER_LIVE_VALIDATION = "liveValidation";
    private static final String PREF_FILTER_VALIDATION_DELAY = "validateDelay";
    private static final int DEFAULT_VALIDATION_DELAY_VALUE = 600;
    private static final Boolean DEFAULT_FILTER_LIVE_VALIDATION_VALUE;
    public static final String PREF_MAX_LEVEL_TO_EXPAND = "maxLevelToExpand";
    public static final int DEFAULT_MAX_LEVEL_TO_EXPAND_VALUE = 15;
    public static final String PREF_FILTER_STEREOTYPE_REPLACED = "replaceStrereotypeDelimiter";
    public static final boolean DEFAULT_FILTER_STEREOTYPE_REPLACED_VALUE = true;
    public static final String ST_LEFT = "\u00ab";
    public static final String ST_RIGHT = "\u00bb";
    public static final String ST_RIGHT_BEFORE = ">>";
    public static final String ST_LEFT_BEFORE = "<<";

    static {
        ModelExplorerPreferences = InstanceScope.INSTANCE.getNode("org.eclipse.papyrus.views.modelexplorer");
        DEFAULT_FILTER_LIVE_VALIDATION_VALUE = true;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        log = new LogHelper((Plugin)plugin);
        this.imageDescriptorManager = new ImageDescriptorManager();
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        log = null;
        this.imageDescriptorManager.reset();
        this.imageDescriptorManager = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public Image getImage(String path) {
        return this.getImage(PLUGIN_ID, path);
    }

    public static Image getImageFromKey(String key) {
        String image_id = key;
        ImageRegistry registry = Activator.getDefault().getImageRegistry();
        Image image = registry.get(image_id);
        if (image == null) {
            ImageDescriptor desc = AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)key);
            registry.put(key, desc);
            image = registry.get(image_id);
        }
        if (image == null && !image_id.equals(DEFAULT_IMAGE)) {
            image = Activator.getDefault().getImage(DEFAULT_IMAGE);
        }
        return image;
    }

    public static String getPath(String plugin, String localPath) {
        return PLUGIN_PROTOCOL + plugin + localPath;
    }

    public static String retrieveBundleId(String initialValue) {
        String result = null;
        if (initialValue.startsWith(PLUGIN_PROTOCOL)) {
            String tmp = initialValue.substring(PLUGIN_PROTOCOL.length());
            int bundleIdEndIndex = tmp.indexOf("/");
            result = tmp.substring(0, bundleIdEndIndex);
        } else if (initialValue.startsWith(BUNDLEENTRY_PROTOCOL)) {
            String absolutePath = null;
            try {
                URL url = new URL(initialValue);
                absolutePath = FileLocator.resolve((URL)url).getPath();
            }
            catch (MalformedURLException e) {
                log.error((Throwable)e);
            }
            catch (IOException e) {
                log.error((Throwable)e);
            }
            int bundleIdEndIndex = absolutePath.indexOf("/icon");
            result = absolutePath.substring(0, bundleIdEndIndex);
            if (-1 != result.indexOf("/")) {
                result = result.substring(result.lastIndexOf("/") + 1);
            }
        } else {
            result = "org.eclipse.uml2.uml.edit";
        }
        return result;
    }

    public static String retrieveLocalPath(String initialValue) {
        String result = "";
        if (initialValue.startsWith(PLUGIN_PROTOCOL)) {
            String tmp = initialValue.substring(PLUGIN_PROTOCOL.length());
            int bundleIdEndIndex = tmp.indexOf("/");
            result = tmp.substring(bundleIdEndIndex);
        } else if (initialValue.startsWith(BUNDLEENTRY_PROTOCOL)) {
            String absolutePath = null;
            try {
                URL url = new URL(initialValue);
                absolutePath = FileLocator.resolve((URL)url).getPath();
            }
            catch (MalformedURLException e) {
                log.error((Throwable)e);
            }
            catch (IOException e) {
                log.error((Throwable)e);
            }
            int bundleIdEndIndex = absolutePath.indexOf("/icon");
            result = absolutePath.substring(bundleIdEndIndex);
        }
        return result;
    }

    public Image getImage(String pluginId, String path) {
        String key;
        ImageRegistry registry = this.getImageRegistry();
        Image image = registry.get(key = String.valueOf(pluginId) + "/" + path);
        if (image == null) {
            registry.put(key, AbstractUIPlugin.imageDescriptorFromPlugin((String)pluginId, (String)path));
            image = registry.get(key);
        }
        return image;
    }

    public Image getImage(ImageDescriptor descriptor) {
        ImageRegistry registry = this.getImageRegistry();
        if (this.imageDescriptorManager == null || registry == null) {
            return null;
        }
        String key = this.imageDescriptorManager.getKey(descriptor);
        Image image = registry.get(key);
        if (image == null) {
            registry.put(key, descriptor);
            image = registry.get(key);
        }
        return image;
    }

    public ImageDescriptor getImageDescriptor(String pluginId, String path) {
        String key;
        ImageRegistry registry = this.getImageRegistry();
        ImageDescriptor descriptor = registry.getDescriptor(key = String.valueOf(pluginId) + "/" + path);
        if (descriptor == null) {
            registry.put(key, AbstractUIPlugin.imageDescriptorFromPlugin((String)pluginId, (String)path));
            descriptor = registry.getDescriptor(key);
        }
        return descriptor;
    }

    public ImageDescriptor getImageDescriptor(String path) {
        return this.getImageDescriptor(PLUGIN_ID, path);
    }

    public Image getImageFromPlugin(String imagePath) {
        Image image;
        if (imagePath.startsWith("/")) {
            String path = imagePath.substring(1, imagePath.length());
            String pluginId = path.substring(0, imagePath.indexOf("/"));
            path = path.substring(path.indexOf("/"), path.length());
            image = this.getImage(pluginId, path);
        } else {
            image = this.getImage(imagePath);
        }
        return image;
    }

    public URL getURL(String path) {
        return this.getURL(PLUGIN_ID, path);
    }

    public URL getURL(String bundleName, String path) {
        Bundle bundle = Platform.getBundle((String)bundleName);
        if (bundle != null) {
            URL url = bundle.getEntry(path);
            try {
                return FileLocator.toFileURL((URL)url);
            }
            catch (IOException e) {
                log.error((Throwable)e);
            }
        }
        return null;
    }

    public static boolean isFilterValidateOnDelay() {
        return ModelExplorerPreferences.getBoolean(PREF_FILTER_LIVE_VALIDATION, DEFAULT_FILTER_LIVE_VALIDATION_VALUE.booleanValue());
    }

    public static int getValidationDelay() {
        return ModelExplorerPreferences.getInt(PREF_FILTER_VALIDATION_DELAY, 600);
    }

    public static int getMaxLevelToExpandValue() {
        return ModelExplorerPreferences.getInt(PREF_MAX_LEVEL_TO_EXPAND, 15);
    }

    public static boolean isStereotypeDelimitersReplaced() {
        return ModelExplorerPreferences.getBoolean(PREF_FILTER_STEREOTYPE_REPLACED, true);
    }
}

