/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.shared.ui.editor.preferences;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.xtend.shared.ui.Activator;
import org.eclipse.xtend.shared.ui.editor.preferences.FontstyleFieldEditor;
import org.eclipse.xtend.shared.ui.editor.preferences.Messages;

public class UiDetailsPreferencePage
extends FieldEditorPreferencePage {
    private PreferenceStore bufferStore = new PreferenceStore();
    private Map<FieldEditor, String> editors;
    private IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
    private String currentToken;

    public UiDetailsPreferencePage() {
        super(Messages.xtendxpanduipref_lookfeel, 1);
    }

    protected void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        FontstyleFieldEditor fontstyleEditor = new FontstyleFieldEditor("", Messages.xtendxpanduipref_fontstyle, parent);
        this.addField(fontstyleEditor);
        ColorFieldEditor fgcolorEditor = new ColorFieldEditor("", Messages.xtendxpanduipref_textcolor, parent);
        this.addField((FieldEditor)fgcolorEditor);
        this.editors = new HashMap<FieldEditor, String>();
        this.editors.put((FieldEditor)fgcolorEditor, ".fgcolor");
        this.editors.put(fontstyleEditor, ".fstyle");
    }

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        return super.createContents(parent);
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return new ChainedPreferenceStore(new IPreferenceStore[]{this.bufferStore, this.preferenceStore});
    }

    protected void load(String tokenName) {
        this.setCurrentTokenName(tokenName);
        this.initialize();
    }

    protected void loadDefaults(String tokenName) {
        this.setCurrentTokenName(tokenName);
        this.performDefaults();
        for (FieldEditor fe : this.editors.keySet()) {
            if (!fe.presentsDefaultValue()) continue;
            this.bufferStore.setDefault(fe.getPreferenceName(), this.preferenceStore.getDefaultString(fe.getPreferenceName()));
        }
    }

    public final boolean performOk() {
        boolean changed = false;
        String[] stringArray = this.bufferStore.preferenceNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (!this.bufferStore.isDefault(name)) {
                this.preferenceStore.putValue(name, this.bufferStore.getString(name));
                changed = true;
            } else {
                this.preferenceStore.setToDefault(name);
            }
            ++n2;
        }
        if (changed) {
            this.preferenceStore.firePropertyChangeEvent(this.currentToken, null, null);
        }
        this.bufferStore = new PreferenceStore();
        this.setPreferenceStore(null);
        return true;
    }

    public final void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() instanceof FieldEditor) {
            FieldEditor fe = (FieldEditor)event.getSource();
            fe.setPreferenceStore((IPreferenceStore)this.bufferStore);
            fe.store();
        }
        super.propertyChange(event);
    }

    private void setCurrentTokenName(String currentTokenName) {
        this.currentToken = currentTokenName;
        for (Map.Entry<FieldEditor, String> e : this.editors.entrySet()) {
            FieldEditor fieldEditor = e.getKey();
            fieldEditor.setPreferenceName(String.valueOf(currentTokenName) + e.getValue());
        }
    }
}

