/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.profile.ui.views;

import java.io.File;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.profile.core.data.ProfilerFileData;
import org.eclipse.php.profile.core.data.ProfilerGlobalData;
import org.eclipse.php.profile.core.engine.IProfileSessionListener;
import org.eclipse.php.profile.core.engine.ProfileSessionsManager;
import org.eclipse.php.profile.core.engine.ProfilerDB;
import org.eclipse.php.profile.ui.PHPProfileUIMessages;
import org.eclipse.php.profile.ui.utils.ChartUtil;
import org.eclipse.php.profile.ui.views.AbstractProfilerView;
import org.eclipse.php.profile.ui.views.ChartViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class ProfilerInformationView
extends AbstractProfilerView
implements IProfileSessionListener {
    private DecimalFormat fDecimalFormat = new DecimalFormat("#0.0##", new DecimalFormatSymbols(new Locale("en")));
    private ScrolledForm fForm;
    private Label fUriLabel;
    private Label fQueryLabel;
    private Label fPathLabel;
    private Label fTotalTimeLabel;
    private Label fFileCountLabel;
    private Label fDateLabel;
    private ProfilerDB fProfilerDB;
    private ChartViewer fChartViewer;

    public void createPartControl(Composite parent) {
        this.createForm(parent);
        ProfileSessionsManager.addProfileSessionListener((IProfileSessionListener)this);
        this.setInput(ProfileSessionsManager.getCurrent());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.php.help.profiler_information_view");
    }

    public void dispose() {
        ProfileSessionsManager.removeProfileSessionListener((IProfileSessionListener)this);
        super.dispose();
    }

    private void createForm(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        this.fForm = toolkit.createScrolledForm(parent);
        FillLayout layout = new FillLayout();
        layout.type = 256;
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.spacing = 10;
        this.fForm.getBody().setLayout((Layout)layout);
        this.createGeneralSection(toolkit);
        this.createChartSection(toolkit);
    }

    private void createGeneralSection(FormToolkit toolkit) {
        Section section = toolkit.createSection(this.fForm.getBody(), -1);
        section.setText(PHPProfileUIMessages.getString("ProfilerInformationView_0"));
        Composite sectionClient = new Composite((Composite)section, 0);
        toolkit.paintBordersFor(sectionClient);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 10;
        sectionClient.setLayout((Layout)layout);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.fUriLabel = toolkit.createLabel(sectionClient, "");
        this.fUriLabel.setLayoutData((Object)data);
        this.fQueryLabel = toolkit.createLabel(sectionClient, "");
        this.fQueryLabel.setLayoutData((Object)data);
        this.fPathLabel = toolkit.createLabel(sectionClient, "");
        this.fPathLabel.setLayoutData((Object)data);
        this.fTotalTimeLabel = toolkit.createLabel(sectionClient, "");
        this.fTotalTimeLabel.setLayoutData((Object)data);
        this.fFileCountLabel = toolkit.createLabel(sectionClient, "");
        this.fFileCountLabel.setLayoutData((Object)data);
        this.fDateLabel = toolkit.createLabel(sectionClient, "");
        this.fDateLabel.setLayoutData((Object)data);
        section.setClient((Control)sectionClient);
        toolkit.adapt(sectionClient);
    }

    private void createChartSection(FormToolkit toolkit) {
        Section section = toolkit.createSection(this.fForm.getBody(), -1);
        section.setText(PHPProfileUIMessages.getString("ProfilerInformationView_1"));
        Composite sectionClient = new Composite((Composite)section, 0);
        toolkit.paintBordersFor(sectionClient);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        sectionClient.setLayout((Layout)layout);
        this.fChartViewer = new ChartViewer(sectionClient, 0);
        toolkit.adapt((Control)this.fChartViewer, false, false);
        GridData data = new GridData();
        data.widthHint = 300;
        data.heightHint = 400;
        data.grabExcessHorizontalSpace = true;
        this.fChartViewer.setLayoutData(data);
        section.setClient((Control)sectionClient);
        toolkit.adapt(sectionClient);
    }

    private void redrawPieChart(ProfilerDB db) {
        if (db != null) {
            ProfilerGlobalData globalData = db.getGlobalData();
            String[] fileNames = globalData.getFileNames();
            int fileCount = fileNames.length;
            ArrayList<FileTime> fileTimeValues = new ArrayList<FileTime>();
            int i = 0;
            while (i < fileCount) {
                ProfilerFileData fileData = db.getFileData(fileNames[i]);
                if (fileData != null) {
                    fileTimeValues.add(new FileTime(fileData.getTotalOwnTimeInMilli(), fileData.getName()));
                }
                ++i;
            }
            fileCount = fileTimeValues.size();
            Object[] allValues = fileTimeValues.toArray(new FileTime[fileCount]);
            Arrays.sort(allValues);
            int slicesLimit = 5;
            int actualNumber = Math.min(slicesLimit, fileCount);
            FileTime[] selectedFiles = new FileTime[actualNumber];
            int index = 0;
            int i2 = fileCount - 1;
            while (i2 >= 0) {
                if (index >= slicesLimit - 1 && fileCount != slicesLimit) {
                    if (selectedFiles[slicesLimit - 1] == null) {
                        selectedFiles[slicesLimit - 1] = new FileTime(((FileTime)allValues[i2]).getTime(), NLS.bind((String)PHPProfileUIMessages.getString("ProfilerInformationView_8"), (Object)Integer.toString(fileCount - slicesLimit + 1)));
                    } else {
                        selectedFiles[slicesLimit - 1].setTime(selectedFiles[slicesLimit - 1].getTime() + ((FileTime)allValues[i2]).getTime());
                    }
                } else {
                    selectedFiles[index] = new FileTime(((FileTime)allValues[i2]).getTime(), ((FileTime)allValues[i2]).getName());
                    ++index;
                }
                --i2;
            }
            double globalTime = 0.0;
            final double[] values = new double[selectedFiles.length];
            int i3 = 0;
            while (i3 < selectedFiles.length) {
                values[i3] = selectedFiles[i3].getTime() * 1000.0;
                globalTime += selectedFiles[i3].getTime();
                ++i3;
            }
            final String[] labels = new String[selectedFiles.length];
            String[] tooltips = new String[selectedFiles.length];
            DecimalFormat percentFormat = new DecimalFormat("#0.#", new DecimalFormatSymbols(new Locale("en")));
            double percentageSum = 0.0;
            int i4 = 0;
            while (i4 < selectedFiles.length) {
                FileTime file = selectedFiles[i4];
                if (file != null) {
                    File currentFile = new File(file.getName());
                    String percentageString = "";
                    if (i4 == selectedFiles.length - 1) {
                        percentageString = NLS.bind((String)PHPProfileUIMessages.getString("ProfilerInformationView_11"), (Object)percentFormat.format(100.0 - percentageSum));
                    } else {
                        double currentPercent = file.getTime() / globalTime * 100.0;
                        percentageSum += currentPercent;
                        percentageString = NLS.bind((String)PHPProfileUIMessages.getString("ProfilerInformationView_11"), (Object)percentFormat.format(currentPercent));
                    }
                    labels[i4] = NLS.bind((String)PHPProfileUIMessages.getString("ProfilerInformationView_12"), (Object[])new String[]{currentFile.getName(), file.isMicroSecOrLess() ? "<= " + this.fDecimalFormat.format(file.getTime()) : this.fDecimalFormat.format(file.getTime()), percentageString});
                    String fullPath = currentFile.getAbsolutePath();
                    if (currentFile.getName().startsWith(PHPProfileUIMessages.getString("ProfilerInformationView_8").substring(0, PHPProfileUIMessages.getString("ProfilerInformationView_8").indexOf("("))) && i4 == selectedFiles.length - 1) {
                        fullPath = currentFile.getName();
                    }
                    tooltips[i4] = NLS.bind((String)PHPProfileUIMessages.getString("ProfilerInformationView_12"), (Object[])new String[]{fullPath, this.fDecimalFormat.format(file.getTime()), percentageString});
                }
                ++i4;
            }
            if (labels.length > 0) {
                Display display = this.getSite().getShell().getDisplay();
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        BusyIndicator.showWhile((Display)ProfilerInformationView.this.getSite().getShell().getDisplay(), (Runnable)new Runnable(){

                            @Override
                            public void run() {
                                Chart chart = ChartUtil.createPieChart(labels, values);
                                chart.getBlock().setBackground((Fill)ColorDefinitionImpl.create((int)ProfilerInformationView.this.fForm.getBackground().getRed(), (int)ProfilerInformationView.this.fForm.getBackground().getGreen(), (int)ProfilerInformationView.this.fForm.getBackground().getBlue()));
                                ProfilerInformationView.this.fChartViewer.updateChartModel(chart);
                            }
                        });
                    }
                });
            }
        } else {
            this.fChartViewer.updateChartModel(null);
        }
    }

    private void setGeneralInfoLabelText(ProfilerDB db) {
        if (db != null) {
            ProfilerGlobalData globalData = db.getGlobalData();
            this.fUriLabel.setText(NLS.bind((String)PHPProfileUIMessages.getString("ProfilerInformationView_2"), (Object)globalData.getOriginalURL().replaceAll("&", "&&")));
            this.fUriLabel.setToolTipText(NLS.bind((String)PHPProfileUIMessages.getString("ProfilerInformationView_2"), (Object)globalData.getOriginalURL()));
            this.fQueryLabel.setText(NLS.bind((String)PHPProfileUIMessages.getString("ProfilerInformationView_3"), (Object)ProfilerInformationView.calculateQueryMessage(globalData.getQuery().replaceAll("&", "&&"))));
            this.fQueryLabel.setToolTipText(NLS.bind((String)PHPProfileUIMessages.getString("ProfilerInformationView_3"), (Object)ProfilerInformationView.calculateQueryMessage(globalData.getQuery())));
            this.fPathLabel.setText(NLS.bind((String)PHPProfileUIMessages.getString("ProfilerInformationView_4"), (Object)globalData.getPath()));
            this.fPathLabel.setToolTipText(NLS.bind((String)PHPProfileUIMessages.getString("ProfilerInformationView_4"), (Object)globalData.getPath()));
            String totalTime = this.fDecimalFormat.format(globalData.getGlobalTimeInMilli());
            this.fTotalTimeLabel.setText(NLS.bind((String)PHPProfileUIMessages.getString("ProfilerInformationView_5"), (Object)totalTime));
            this.fTotalTimeLabel.setToolTipText(NLS.bind((String)PHPProfileUIMessages.getString("ProfilerInformationView_5"), (Object)totalTime));
            this.fFileCountLabel.setText(NLS.bind((String)PHPProfileUIMessages.getString("ProfilerInformationView_6"), (Object)Integer.toString(globalData.getFileCount())));
            this.fFileCountLabel.setToolTipText(NLS.bind((String)PHPProfileUIMessages.getString("ProfilerInformationView_6"), (Object)Integer.toString(globalData.getFileCount())));
            this.fDateLabel.setText(NLS.bind((String)PHPProfileUIMessages.getString("ProfilerInformationView_7"), (Object)db.getProfileDate().toString()));
            this.fDateLabel.setToolTipText(NLS.bind((String)PHPProfileUIMessages.getString("ProfilerInformationView_7"), (Object)db.getProfileDate().toString()));
        } else {
            this.fUriLabel.setText("");
            this.fUriLabel.setToolTipText("");
            this.fQueryLabel.setText("");
            this.fQueryLabel.setToolTipText("");
            this.fPathLabel.setText("");
            this.fPathLabel.setToolTipText("");
            this.fTotalTimeLabel.setText("");
            this.fTotalTimeLabel.setToolTipText("");
            this.fFileCountLabel.setText("");
            this.fFileCountLabel.setToolTipText("");
            this.fDateLabel.setText("");
            this.fDateLabel.setToolTipText("");
        }
        this.fForm.redraw();
    }

    public static String calculateQueryMessage(String query) {
        String newString = query;
        if (query.indexOf("start_debug") != -1) {
            newString = query.substring(0, query.indexOf("start_debug"));
        }
        if (newString.equals("")) {
            return PHPProfileUIMessages.getString("ProfilerInformationView_10");
        }
        if (newString.endsWith("&")) {
            newString = newString.substring(0, newString.length() - 1);
        }
        return newString;
    }

    @Override
    public ProfilerDB getInput() {
        return this.fProfilerDB;
    }

    @Override
    public void setInput(ProfilerDB profilerDB) {
        if (this.fProfilerDB != profilerDB) {
            this.setGeneralInfoLabelText(profilerDB);
            this.redrawPieChart(profilerDB);
            this.fProfilerDB = profilerDB;
        }
    }

    public void setFocus() {
    }

    public void currentSessionChanged(final ProfilerDB current) {
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ProfilerInformationView.this.setInput(current);
            }
        });
    }

    public void profileSessionAdded(ProfilerDB db) {
    }

    public void profileSessionRemoved(ProfilerDB db) {
    }

    private static class FileTime
    implements Comparable<Object> {
        private static final double microSecOrLess = 0.001;
        private double time;
        private String name;

        public FileTime(double time, String name) {
            this.time = time > 0.0 ? time : 0.001;
            this.name = name;
        }

        public double getTime() {
            return this.time;
        }

        public String getName() {
            return this.name;
        }

        public boolean isMicroSecOrLess() {
            return this.time == 0.001;
        }

        public void setTime(double time) {
            this.time = time;
        }

        @Override
        public int compareTo(Object o) {
            double newTime = ((FileTime)o).getTime();
            if (this.time - newTime <= 0.0) {
                if (this.time - newTime == 0.0) {
                    return 0;
                }
                return -1;
            }
            return 1;
        }
    }
}

