/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.sshd;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.kex.KexProposalOption;
import org.apache.sshd.common.kex.extension.KexExtensionHandler;
import org.apache.sshd.common.kex.extension.parser.ServerSignatureAlgorithms;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;
import org.eclipse.jgit.util.StringUtils;

public class JGitKexExtensionHandler
extends AbstractLoggingBean
implements KexExtensionHandler {
    public static final JGitKexExtensionHandler INSTANCE = new JGitKexExtensionHandler();
    private static final AttributeRepository.AttributeKey<Boolean> CLIENT_PROPOSAL_MADE = new AttributeRepository.AttributeKey();
    public static final AttributeRepository.AttributeKey<Set<String>> SERVER_ALGORITHMS = new AttributeRepository.AttributeKey();

    private JGitKexExtensionHandler() {
    }

    public boolean isKexExtensionsAvailable(Session session, KexExtensionHandler.AvailabilityPhase phase) throws IOException {
        return !KexExtensionHandler.AvailabilityPhase.PREKEX.equals((Object)phase);
    }

    public void handleKexInitProposal(Session session, boolean initiator, Map<KexProposalOption, String> proposal) throws IOException {
        if (session == null || session.isServerSession() || !initiator) {
            return;
        }
        if (session.getAttribute(CLIENT_PROPOSAL_MADE) != null) {
            return;
        }
        String kexAlgorithms = proposal.get(KexProposalOption.SERVERKEYS);
        if (StringUtils.isEmptyOrNull((String)kexAlgorithms)) {
            return;
        }
        ArrayList<String> algorithms = new ArrayList<String>();
        String[] stringArray = kexAlgorithms.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String algo = stringArray[n2];
            if (!"ext-info-c".equalsIgnoreCase(algo) && !"ext-info-s".equalsIgnoreCase(algo)) {
                algorithms.add(algo);
            }
            ++n2;
        }
        algorithms.add("ext-info-c");
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleKexInitProposal({}): proposing HostKeyAlgorithms {}", (Object)session, algorithms);
        }
        proposal.put(KexProposalOption.SERVERKEYS, String.join((CharSequence)",", algorithms));
        session.setAttribute(CLIENT_PROPOSAL_MADE, (Object)Boolean.TRUE);
    }

    public boolean handleKexExtensionRequest(Session session, int index, int count, String name, byte[] data) throws IOException {
        if ("server-sig-algs".equals(name)) {
            this.handleServerSignatureAlgorithms(session, (Collection)ServerSignatureAlgorithms.INSTANCE.parseExtension(data));
        }
        return true;
    }

    protected void handleServerSignatureAlgorithms(Session session, Collection<String> serverAlgorithms) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleServerSignatureAlgorithms({}): {}", (Object)session, serverAlgorithms);
        }
        if (serverAlgorithms != null && !serverAlgorithms.isEmpty()) {
            ArrayList clientAlgorithms = new ArrayList(session.getSignatureFactories());
            if (this.log.isDebugEnabled()) {
                this.log.debug("handleServerSignatureAlgorithms({}): PubkeyAcceptedAlgorithms before: {}", (Object)session, clientAlgorithms);
            }
            ArrayList<NamedFactory> unknown = new ArrayList<NamedFactory>();
            TreeSet<String> known = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            known.addAll(serverAlgorithms);
            Iterator iter = clientAlgorithms.iterator();
            while (iter.hasNext()) {
                NamedFactory algo = (NamedFactory)iter.next();
                if (known.contains(algo.getName())) continue;
                unknown.add(algo);
                iter.remove();
            }
            clientAlgorithms.addAll(unknown);
            if (this.log.isDebugEnabled()) {
                this.log.debug("handleServerSignatureAlgorithms({}): PubkeyAcceptedAlgorithms after: {}", (Object)session, clientAlgorithms);
            }
            session.setAttribute(SERVER_ALGORITHMS, known);
            session.setSignatureFactories(clientAlgorithms);
        }
    }
}

