/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.cdt.build.core.scannerconfig.ICfgScannerConfigBuilderInfo2Set;
import org.eclipse.cdt.build.internal.core.scannerconfig.CfgDiscoveredPathManager;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.cdtvariables.CdtVariableException;
import org.eclipse.cdt.core.settings.model.CLibraryPathEntry;
import org.eclipse.cdt.core.settings.model.CSourceEntry;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICExternalSetting;
import org.eclipse.cdt.core.settings.model.ICOutputEntry;
import org.eclipse.cdt.core.settings.model.ICSettingEntry;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.core.settings.model.extension.CBuildData;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationData;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.core.settings.model.util.LanguageSettingEntriesSerializer;
import org.eclipse.cdt.core.settings.model.util.PathSettingsContainer;
import org.eclipse.cdt.internal.core.SafeStringInterner;
import org.eclipse.cdt.managedbuilder.buildproperties.IBuildProperty;
import org.eclipse.cdt.managedbuilder.buildproperties.IBuildPropertyType;
import org.eclipse.cdt.managedbuilder.buildproperties.IBuildPropertyValue;
import org.eclipse.cdt.managedbuilder.buildproperties.IOptionalBuildProperties;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IBuildObjectProperties;
import org.eclipse.cdt.managedbuilder.core.IBuildPropertiesRestriction;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IFileInfo;
import org.eclipse.cdt.managedbuilder.core.IFolderInfo;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineGenerator;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionApplicability;
import org.eclipse.cdt.managedbuilder.core.IOptionCommandGenerator;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITargetPlatform;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.envvar.IConfigurationEnvironmentVariableSupplier;
import org.eclipse.cdt.managedbuilder.internal.core.BooleanExpressionApplicabilityCalculator;
import org.eclipse.cdt.managedbuilder.internal.core.BuildObject;
import org.eclipse.cdt.managedbuilder.internal.core.BuildObjectProperties;
import org.eclipse.cdt.managedbuilder.internal.core.BuildSettingsUtil;
import org.eclipse.cdt.managedbuilder.internal.core.Builder;
import org.eclipse.cdt.managedbuilder.internal.core.FolderInfo;
import org.eclipse.cdt.managedbuilder.internal.core.IBuildPropertyChangeListener;
import org.eclipse.cdt.managedbuilder.internal.core.IRealBuildObjectAssociation;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedConfigStorageElement;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedMakeMessages;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedProject;
import org.eclipse.cdt.managedbuilder.internal.core.OptionalBuildProperties;
import org.eclipse.cdt.managedbuilder.internal.core.ProjectType;
import org.eclipse.cdt.managedbuilder.internal.core.PropertyManager;
import org.eclipse.cdt.managedbuilder.internal.core.ResourceConfiguration;
import org.eclipse.cdt.managedbuilder.internal.core.ResourceInfo;
import org.eclipse.cdt.managedbuilder.internal.core.ResourceInfoContainer;
import org.eclipse.cdt.managedbuilder.internal.core.SourcePath;
import org.eclipse.cdt.managedbuilder.internal.core.SupportedProperties;
import org.eclipse.cdt.managedbuilder.internal.core.TargetPlatform;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.cdt.managedbuilder.internal.core.ToolChain;
import org.eclipse.cdt.managedbuilder.internal.dataprovider.BuildConfigurationData;
import org.eclipse.cdt.managedbuilder.internal.macros.BuildMacroProvider;
import org.eclipse.cdt.managedbuilder.internal.macros.BuildfileMacroSubstitutor;
import org.eclipse.cdt.managedbuilder.internal.macros.FileContextData;
import org.eclipse.cdt.managedbuilder.internal.macros.IMacroContextInfo;
import org.eclipse.cdt.managedbuilder.internal.macros.OptionContextData;
import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;
import org.eclipse.cdt.managedbuilder.macros.IConfigurationBuildMacroSupplier;
import org.eclipse.cdt.utils.cdtvariables.IVariableSubstitutor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Version;

public class Configuration
extends BuildObject
implements IConfiguration,
IBuildPropertiesRestriction,
IBuildPropertyChangeListener,
IRealBuildObjectAssociation {
    private static final String WHITE_SPACE = " ";
    private static final String EMPTY_STRING = "";
    private static final String EMPTY_CFG_ID = "org.eclipse.cdt.build.core.emptycfg";
    private static final String LANGUAGE_SETTINGS_PROVIDER_DELIMITER = ";";
    private static final String LANGUAGE_SETTINGS_PROVIDER_NEGATION_SIGN = "-";
    private static final String $TOOLCHAIN = "${Toolchain}";
    private String parentId;
    private IConfiguration parent;
    private ProjectType projectType;
    private ManagedProject managedProject;
    private String artifactName;
    private String cleanCommand;
    private String artifactExtension;
    private String errorParserIds;
    private String defaultLanguageSettingsProvidersAttribute;
    private String[] defaultLanguageSettingsProviderIds;
    private String prebuildStep;
    private String postbuildStep;
    private String preannouncebuildStep;
    private String postannouncebuildStep;
    private String description;
    private ICSourceEntry[] sourceEntries;
    private BuildObjectProperties buildProperties;
    private OptionalBuildProperties optionalBuildProperties;
    private boolean isTest;
    private SupportedProperties supportedProperties;
    private boolean isExtensionConfig = false;
    private boolean isDirty = false;
    private boolean rebuildNeeded = false;
    private boolean resolved = true;
    private boolean isTemporary = false;
    private PathSettingsContainer pathSettings = PathSettingsContainer.createRootContainer();
    private ResourceInfoContainer rcInfos = new ResourceInfoContainer(this.pathSettings, true);
    private BooleanExpressionApplicabilityCalculator booleanExpressionCalculator;
    private FolderInfo rootFolderInfo;
    private BuildConfigurationData fCfgData;
    private ICConfigurationDescription fCfgDes;
    private ICfgScannerConfigBuilderInfo2Set cfgScannerInfo;
    private boolean isPreferenceConfig;
    private List<IPath> excludeList;
    private static final String REBUILD_STATE = "rebuildState";
    private static final String RC_CHANGE_STATE = "rcState";
    private int resourceChangeState = -1;

    public Configuration(ProjectType projectType, IManagedConfigElement element, String managedBuildRevision) {
        String artType;
        String optionalProps;
        String props;
        IManagedConfigElement[] enablements;
        this.projectType = projectType;
        this.isExtensionConfig = true;
        this.resolved = false;
        this.setManagedBuildRevision(managedBuildRevision);
        this.loadFromManifest(element);
        ManagedBuildManager.addExtensionConfiguration(this);
        if (projectType != null) {
            projectType.addConfiguration(this);
        }
        if ((enablements = element.getChildren("enablement")).length > 0) {
            this.booleanExpressionCalculator = new BooleanExpressionApplicabilityCalculator(enablements);
        }
        IManagedConfigElement[] configElements = element.getChildren();
        ArrayList<IPath> srcPathList = new ArrayList<IPath>();
        this.excludeList = new ArrayList<IPath>();
        int l = 0;
        while (l < configElements.length) {
            ResourceInfo resConfig;
            IManagedConfigElement configElement = configElements[l];
            if (configElement.getName().equals("toolChain")) {
                this.rootFolderInfo = new FolderInfo((IConfiguration)this, configElement, managedBuildRevision, false);
                this.addResourceConfiguration(this.rootFolderInfo);
            } else if ("folderInfo".equals(configElement.getName())) {
                resConfig = new FolderInfo((IConfiguration)this, configElement, managedBuildRevision, true);
                this.addResourceConfiguration(resConfig);
            } else if ("fileInfo".equals(configElement.getName()) || "resourceConfiguration".equals(configElement.getName())) {
                resConfig = new ResourceConfiguration((IConfiguration)this, configElement, managedBuildRevision);
                this.addResourceConfiguration(resConfig);
            } else if ("sourcePath".equals(configElement.getName())) {
                SourcePath p = new SourcePath(configElement);
                if (p.getPath() != null) {
                    srcPathList.add(p.getPath());
                }
            } else if (configElement.getName().equals("supportedProperties")) {
                this.loadProperties(configElement);
            } else if ("sourceEntries".equals(configElement.getName())) {
                List seList = LanguageSettingEntriesSerializer.loadEntriesList((ICStorageElement)new ManagedConfigStorageElement(configElement), (int)128);
                this.sourceEntries = seList.toArray(new ICSourceEntry[seList.size()]);
            }
            ++l;
        }
        this.sourceEntries = Configuration.createSourceEntries(this.sourceEntries, srcPathList, this.excludeList);
        this.excludeList = null;
        if (this.rootFolderInfo == null) {
            this.createRootFolderInfo();
        }
        if ((props = SafeStringInterner.safeIntern((String)element.getAttribute("buildProperties"))) != null) {
            this.buildProperties = new BuildObjectProperties(props, (IBuildPropertiesRestriction)this, (IBuildPropertyChangeListener)this);
        }
        if ((optionalProps = SafeStringInterner.safeIntern((String)element.getAttribute("optionalBuildProperties"))) != null) {
            this.optionalBuildProperties = new OptionalBuildProperties(optionalProps);
        }
        if ((artType = SafeStringInterner.safeIntern((String)element.getAttribute("buildArtefactType"))) != null) {
            if (this.buildProperties == null) {
                this.buildProperties = new BuildObjectProperties(this, this);
            }
            try {
                this.buildProperties.setProperty("org.eclipse.cdt.build.core.buildArtefactType", artType, true);
            }
            catch (CoreException e) {
                ManagedBuilderCorePlugin.log(e);
            }
        }
        if (projectType != null && projectType.buildProperties != null) {
            if (this.buildProperties == null) {
                this.buildProperties = new BuildObjectProperties(projectType.buildProperties, (IBuildPropertiesRestriction)this, (IBuildPropertyChangeListener)this);
            } else {
                IBuildProperty[] properties = projectType.buildProperties.getProperties();
                int i = 0;
                while (i < properties.length) {
                    try {
                        this.buildProperties.internalSetProperty(properties[i].getPropertyType().getId(), properties[i].getValue().getId());
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                    ++i;
                }
            }
        }
        this.setDirty(false);
    }

    private static ICSourceEntry[] createSourceEntries(ICSourceEntry[] curEntries, List<IPath> pathList, List<IPath> excludeList) {
        int i = 0;
        while (i < excludeList.size()) {
            IPath path = excludeList.get(i);
            if (path.segmentCount() == 0) {
                excludeList.remove(i);
            }
            ++i;
        }
        if (pathList.size() == 0) {
            pathList.add((IPath)Path.EMPTY);
        }
        if (pathList.size() == 1 && pathList.get(0).equals((Object)Path.EMPTY) && excludeList.size() == 0) {
            return curEntries;
        }
        int pathSize = pathList.size();
        LinkedHashMap<IPath, ICSourceEntry> map = new LinkedHashMap<IPath, ICSourceEntry>();
        int i2 = 0;
        while (i2 < pathSize) {
            IPath path = pathList.get(i2);
            ICSourceEntry entry = (ICSourceEntry)map.get(path);
            if (entry == null) {
                entry = new CSourceEntry(path, null, 24);
            }
            if ((entry = CDataUtil.addExcludePaths((ICSourceEntry)entry, excludeList, (boolean)true)) != null) {
                map.put(path, entry);
            }
            ++i2;
        }
        return map.values().toArray(new ICSourceEntry[map.size()]);
    }

    public Configuration(ProjectType projectType, IConfiguration parentConfig, String id) {
        this.setId(id);
        this.projectType = projectType;
        this.isExtensionConfig = true;
        this.resolved = false;
        if (parentConfig != null) {
            this.name = parentConfig.getName();
            this.parent = parentConfig.getParent() == null ? parentConfig : parentConfig.getParent();
        }
        ManagedBuildManager.addExtensionConfiguration(this);
        if (projectType != null) {
            projectType.addConfiguration(this);
            this.setManagedBuildRevision(projectType.getManagedBuildRevision());
        }
    }

    public Configuration(ProjectType projectType, IConfiguration parentConfig, String id, String name) {
        this.setId(id);
        this.setName(name);
        this.projectType = projectType;
        this.parent = parentConfig;
        this.isExtensionConfig = true;
        ManagedBuildManager.addExtensionConfiguration(this);
        if (projectType != null) {
            projectType.addConfiguration(this);
            this.setManagedBuildRevision(projectType.getManagedBuildRevision());
        }
    }

    public Configuration(ManagedProject managedProject, ICStorageElement element, String managedBuildRevision, boolean isPreference) {
        String rcChangeState;
        this.managedProject = managedProject;
        this.isPreferenceConfig = isPreference;
        this.isExtensionConfig = false;
        this.fCfgData = new BuildConfigurationData(this);
        this.setManagedBuildRevision(managedBuildRevision);
        this.loadFromProject(element);
        if (managedProject != null) {
            managedProject.addConfiguration(this);
        }
        ICStorageElement[] configElements = element.getChildren();
        ArrayList<IPath> srcPathList = new ArrayList<IPath>();
        this.excludeList = new ArrayList<IPath>();
        int i = 0;
        while (i < configElements.length) {
            ResourceInfo resConfig;
            ICStorageElement configElement = configElements[i];
            if (configElement.getName().equals("toolChain")) {
                this.rootFolderInfo = new FolderInfo((IConfiguration)this, configElement, managedBuildRevision, false);
                this.addResourceConfiguration(this.rootFolderInfo);
            } else if ("folderInfo".equals(configElement.getName())) {
                resConfig = new FolderInfo((IConfiguration)this, configElement, managedBuildRevision, true);
                this.addResourceConfiguration(resConfig);
            } else if ("fileInfo".equals(configElement.getName()) || "resourceConfiguration".equals(configElement.getName())) {
                resConfig = new ResourceConfiguration((IConfiguration)this, configElement, managedBuildRevision);
                this.addResourceConfiguration(resConfig);
            } else if ("sourcePath".equals(configElement.getName())) {
                SourcePath p = new SourcePath(configElement);
                if (p.getPath() != null) {
                    srcPathList.add(p.getPath());
                }
            } else if ("sourceEntries".equals(configElement.getName())) {
                List seList = LanguageSettingEntriesSerializer.loadEntriesList((ICStorageElement)configElement, (int)128);
                this.sourceEntries = seList.toArray(new ICSourceEntry[seList.size()]);
            }
            ++i;
        }
        this.resolveProjectReferences(true);
        this.sourceEntries = Configuration.createSourceEntries(this.sourceEntries, srcPathList, this.excludeList);
        this.excludeList = null;
        PropertyManager mngr = PropertyManager.getInstance();
        String rebuild = mngr.getProperty(this, REBUILD_STATE);
        if (rebuild == null || Boolean.valueOf(rebuild).booleanValue()) {
            this.rebuildNeeded = true;
        }
        if ((rcChangeState = mngr.getProperty(this, RC_CHANGE_STATE)) == null) {
            this.resourceChangeState = -1;
        } else {
            try {
                this.resourceChangeState = Integer.parseInt(rcChangeState);
            }
            catch (NumberFormatException e) {
                this.resourceChangeState = -1;
            }
        }
        this.setDirty(false);
    }

    public Configuration(ManagedProject managedProject, IToolChain tCh, String id, String name) {
        this.setId(id);
        this.setName(name);
        this.managedProject = managedProject;
        this.isExtensionConfig = false;
        if (tCh == null) {
            IConfiguration cfg = ManagedBuildManager.getPreferenceConfiguration(false);
            if (cfg != null) {
                this.copySettingsFrom((Configuration)cfg, true);
            }
        } else {
            TargetPlatform tp;
            ITargetPlatform tpBase;
            String subId;
            Configuration baseCfg = (Configuration)ManagedBuildManager.getExtensionConfiguration(EMPTY_CFG_ID);
            this.fCfgData = new BuildConfigurationData(this);
            if (baseCfg.buildProperties != null) {
                this.buildProperties = new BuildObjectProperties(baseCfg.buildProperties, (IBuildPropertiesRestriction)this, (IBuildPropertyChangeListener)this);
            }
            if (baseCfg.optionalBuildProperties != null) {
                this.optionalBuildProperties = new OptionalBuildProperties(baseCfg.optionalBuildProperties);
            }
            this.setManagedBuildRevision(baseCfg.getManagedBuildRevision());
            this.parent = baseCfg.isExtensionConfig || baseCfg.getParent() == null ? baseCfg : baseCfg.getParent();
            this.projectType = baseCfg.projectType;
            this.artifactName = baseCfg.artifactName;
            this.cleanCommand = baseCfg.cleanCommand;
            this.artifactExtension = baseCfg.artifactExtension;
            this.errorParserIds = baseCfg.errorParserIds;
            this.prebuildStep = baseCfg.prebuildStep;
            this.postbuildStep = baseCfg.postbuildStep;
            this.preannouncebuildStep = baseCfg.preannouncebuildStep;
            this.postannouncebuildStep = baseCfg.postannouncebuildStep;
            if (baseCfg.sourceEntries != null) {
                this.sourceEntries = (ICSourceEntry[])baseCfg.sourceEntries.clone();
            }
            this.defaultLanguageSettingsProvidersAttribute = baseCfg.defaultLanguageSettingsProvidersAttribute;
            if (baseCfg.defaultLanguageSettingsProviderIds != null) {
                this.defaultLanguageSettingsProviderIds = (String[])baseCfg.defaultLanguageSettingsProviderIds.clone();
            }
            String tcId = ManagedBuildManager.calculateChildId(tCh.getId(), null);
            IToolChain newChain = this.createToolChain(tCh, tcId, tCh.getName(), false);
            newChain.createOptions(tCh);
            ITool[] tools = tCh.getTools();
            int i = 0;
            while (i < tools.length) {
                Tool toolChild = (Tool)tools[i];
                subId = ManagedBuildManager.calculateChildId(toolChild.getId(), null);
                newChain.createTool(toolChild, subId, toolChild.getName(), false);
                ++i;
            }
            ITargetPlatform extTp = tpBase = tCh.getTargetPlatform();
            while (extTp != null && !extTp.isExtensionElement()) {
                extTp = extTp.getSuperClass();
            }
            if (extTp != null) {
                int nnn = ManagedBuildManager.getRandomNumber();
                subId = String.valueOf(extTp.getId()) + "." + nnn;
                tp = new TargetPlatform(newChain, subId, tpBase.getName(), (TargetPlatform)tpBase);
            } else {
                subId = ManagedBuildManager.calculateChildId(this.getId(), null);
                String subName = EMPTY_STRING;
                tp = new TargetPlatform((ToolChain)newChain, null, subId, subName, false);
            }
            ((ToolChain)newChain).setTargetPlatform(tp);
            managedProject.addConfiguration(this);
            IBuilder builder = this.getEditableBuilder();
            try {
                builder.setManagedBuildOn(false);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            this.propertiesChanged();
        }
        this.setDirty(true);
        this.setRebuildState(true);
    }

    public Configuration(ManagedProject managedProject, Configuration cloneConfig, String id, boolean cloneChildren, boolean temporary) {
        this(managedProject, cloneConfig, id, cloneChildren, temporary, false);
    }

    public Configuration(ManagedProject managedProject, Configuration cloneConfig, String id, boolean cloneChildren, boolean temporary, boolean isPreferenceConfig) {
        this.setId(id);
        this.setName(cloneConfig.getName());
        this.isPreferenceConfig = isPreferenceConfig;
        this.managedProject = managedProject;
        this.isExtensionConfig = false;
        this.isTemporary = temporary;
        this.copySettingsFrom(cloneConfig, cloneChildren);
    }

    private void copySettingsFrom(Configuration cloneConfig, boolean cloneChildren) {
        this.fCfgData = new BuildConfigurationData(this);
        if (cloneConfig.buildProperties != null) {
            this.buildProperties = new BuildObjectProperties(cloneConfig.buildProperties, (IBuildPropertiesRestriction)this, (IBuildPropertyChangeListener)this);
        }
        if (cloneConfig.optionalBuildProperties != null) {
            this.optionalBuildProperties = new OptionalBuildProperties(cloneConfig.optionalBuildProperties);
        }
        this.description = cloneConfig.getDescription();
        this.setManagedBuildRevision(cloneConfig.getManagedBuildRevision());
        if (!cloneConfig.isExtensionConfig) {
            cloneChildren = true;
        }
        this.parent = cloneConfig.isExtensionConfig || cloneConfig.getParent() == null ? cloneConfig : cloneConfig.getParent();
        this.parentId = this.parent.getId();
        this.projectType = cloneConfig.projectType;
        this.artifactName = cloneConfig.artifactName;
        this.cleanCommand = cloneConfig.cleanCommand;
        this.artifactExtension = cloneConfig.artifactExtension;
        this.errorParserIds = cloneConfig.errorParserIds;
        this.prebuildStep = cloneConfig.prebuildStep;
        this.postbuildStep = cloneConfig.postbuildStep;
        this.preannouncebuildStep = cloneConfig.preannouncebuildStep;
        this.postannouncebuildStep = cloneConfig.postannouncebuildStep;
        if (cloneConfig.sourceEntries != null) {
            this.sourceEntries = (ICSourceEntry[])cloneConfig.sourceEntries.clone();
        }
        this.defaultLanguageSettingsProvidersAttribute = cloneConfig.defaultLanguageSettingsProvidersAttribute;
        if (cloneConfig.defaultLanguageSettingsProviderIds != null) {
            this.defaultLanguageSettingsProviderIds = (String[])cloneConfig.defaultLanguageSettingsProviderIds.clone();
        }
        boolean copyIds = cloneConfig.getId().equals(this.id);
        HashMap<IPath, Map<String, String>> toolIdMap = new HashMap<IPath, Map<String, String>>();
        IResourceInfo[] infos = cloneConfig.rcInfos.getResourceInfos();
        int i = 0;
        while (i < infos.length) {
            String subId;
            if (infos[i] instanceof FolderInfo) {
                FolderInfo folderInfo = (FolderInfo)infos[i];
                subId = copyIds ? folderInfo.getId() : ManagedBuildManager.calculateChildId(this.getId(), folderInfo.getPath().toString());
                FolderInfo newFolderInfo = new FolderInfo((IConfiguration)this, folderInfo, subId, toolIdMap, cloneChildren);
                this.addResourceConfiguration(newFolderInfo);
            } else {
                ResourceConfiguration fileInfo = (ResourceConfiguration)infos[i];
                subId = copyIds ? fileInfo.getId() : ManagedBuildManager.calculateChildId(this.getId(), fileInfo.getPath().toString());
                ResourceConfiguration newResConfig = new ResourceConfiguration(this, fileInfo, subId, toolIdMap, cloneChildren);
                this.addResourceConfiguration(newResConfig);
            }
            ++i;
        }
        this.resolveProjectReferences(false);
        if (cloneChildren) {
            BuildMacroProvider macroProvider = (BuildMacroProvider)ManagedBuildManager.getBuildMacroProvider();
            macroProvider.expandMacrosInBuildfile(this, macroProvider.areMacrosExpandedInBuildfile(cloneConfig));
        }
        if (this.managedProject != null) {
            this.managedProject.addConfiguration(this);
        }
        if (cloneConfig.isExtensionConfig) {
            this.propertiesChanged();
        }
        if (copyIds) {
            this.rebuildNeeded = cloneConfig.rebuildNeeded;
            this.resourceChangeState = cloneConfig.resourceChangeState;
            this.isDirty = cloneConfig.isDirty;
        } else {
            if (cloneConfig.isExtensionConfig) {
                this.exportArtifactInfo();
            }
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    public void applyToManagedProject(ManagedProject mProj) {
        this.managedProject = mProj;
        this.isPreferenceConfig = false;
        this.isTemporary = false;
        this.managedProject.addConfiguration(this);
    }

    protected void loadFromManifest(IManagedConfigElement element) {
        ManagedBuildManager.putConfigElement(this, element);
        this.setId(SafeStringInterner.safeIntern((String)element.getAttribute("id")));
        this.name = SafeStringInterner.safeIntern((String)element.getAttribute("name"));
        this.description = SafeStringInterner.safeIntern((String)element.getAttribute("description"));
        this.parentId = SafeStringInterner.safeIntern((String)element.getAttribute("parent"));
        this.artifactName = SafeStringInterner.safeIntern((String)element.getAttribute("artifactName"));
        this.errorParserIds = SafeStringInterner.safeIntern((String)element.getAttribute("errorParsers"));
        this.defaultLanguageSettingsProvidersAttribute = SafeStringInterner.safeIntern((String)element.getAttribute("languageSettingsProviders"));
        this.artifactExtension = SafeStringInterner.safeIntern((String)element.getAttribute("artifactExtension"));
        this.cleanCommand = SafeStringInterner.safeIntern((String)element.getAttribute("cleanCommand"));
        this.prebuildStep = SafeStringInterner.safeIntern((String)element.getAttribute("prebuildStep"));
        this.postbuildStep = SafeStringInterner.safeIntern((String)element.getAttribute("postbuildStep"));
        this.preannouncebuildStep = SafeStringInterner.safeIntern((String)element.getAttribute("preannouncebuildStep"));
        this.postannouncebuildStep = SafeStringInterner.safeIntern((String)element.getAttribute("postannouncebuildStep"));
        String tmp = element.getAttribute("isSystem");
        if (tmp != null) {
            this.isTest = Boolean.valueOf(tmp);
        }
    }

    protected void loadFromProject(ICStorageElement element) {
        String artType;
        String optionalProps;
        String props;
        this.setId(element.getAttribute("id"));
        if (element.getAttribute("name") != null) {
            this.setName(SafeStringInterner.safeIntern((String)element.getAttribute("name")));
        }
        if (element.getAttribute("description") != null) {
            this.description = SafeStringInterner.safeIntern((String)element.getAttribute("description"));
        }
        if ((props = element.getAttribute("buildProperties")) != null) {
            this.buildProperties = new BuildObjectProperties(props, (IBuildPropertiesRestriction)this, (IBuildPropertyChangeListener)this);
        }
        if ((optionalProps = element.getAttribute("optionalBuildProperties")) != null) {
            this.optionalBuildProperties = new OptionalBuildProperties(optionalProps);
        }
        if ((artType = SafeStringInterner.safeIntern((String)element.getAttribute("buildArtefactType"))) != null) {
            if (this.buildProperties == null) {
                this.buildProperties = new BuildObjectProperties(this, this);
            }
            try {
                this.buildProperties.setProperty("org.eclipse.cdt.build.core.buildArtefactType", artType, true);
            }
            catch (CoreException e) {
                ManagedBuilderCorePlugin.log(e);
            }
        }
        if (element.getAttribute("parent") != null) {
            if (this.managedProject != null) {
                this.parent = this.managedProject.getConfiguration(element.getAttribute("parent"));
            }
            if (this.parent == null) {
                this.parent = ManagedBuildManager.getExtensionConfiguration(element.getAttribute("parent"));
                if (this.parent == null) {
                    String message = NLS.bind((String)ManagedMakeMessages.getResourceString("Configuration.orphaned"), (Object)this.getId(), (Object)element.getAttribute("parent"));
                    ManagedBuilderCorePlugin.error(message);
                }
            }
        }
        if (element.getAttribute("artifactName") != null) {
            this.artifactName = SafeStringInterner.safeIntern((String)element.getAttribute("artifactName"));
        }
        if (element.getAttribute("errorParsers") != null) {
            this.errorParserIds = SafeStringInterner.safeIntern((String)element.getAttribute("errorParsers"));
        }
        if (element.getAttribute("artifactExtension") != null) {
            this.artifactExtension = SafeStringInterner.safeIntern((String)element.getAttribute("artifactExtension"));
        }
        if (element.getAttribute("cleanCommand") != null) {
            this.cleanCommand = SafeStringInterner.safeIntern((String)element.getAttribute("cleanCommand"));
        }
        if (element.getAttribute("prebuildStep") != null) {
            this.prebuildStep = SafeStringInterner.safeIntern((String)element.getAttribute("prebuildStep"));
        }
        if (element.getAttribute("postbuildStep") != null) {
            this.postbuildStep = SafeStringInterner.safeIntern((String)element.getAttribute("postbuildStep"));
        }
        if (element.getAttribute("preannouncebuildStep") != null) {
            this.preannouncebuildStep = SafeStringInterner.safeIntern((String)element.getAttribute("preannouncebuildStep"));
        }
        if (element.getAttribute("postannouncebuildStep") != null) {
            this.postannouncebuildStep = SafeStringInterner.safeIntern((String)element.getAttribute("postannouncebuildStep"));
        }
    }

    public void serialize(ICStorageElement element) {
        element.setAttribute("id", this.id);
        if (this.name != null) {
            element.setAttribute("name", this.name);
        }
        if (this.description != null) {
            element.setAttribute("description", this.description);
        }
        if (this.buildProperties != null) {
            element.setAttribute("buildProperties", this.buildProperties.toString());
            IBuildProperty prop = this.buildProperties.getProperty("org.eclipse.cdt.build.core.buildArtefactType");
            if (prop != null) {
                IBuildPropertyValue val = prop.getValue();
                element.setAttribute("buildArtefactType", val.getId());
            }
        }
        if (this.optionalBuildProperties != null) {
            element.setAttribute("optionalBuildProperties", this.optionalBuildProperties.toString());
        }
        if (this.parent != null) {
            element.setAttribute("parent", this.parent.getId());
        }
        if (this.artifactName != null) {
            element.setAttribute("artifactName", this.artifactName);
        }
        if (this.errorParserIds != null) {
            element.setAttribute("errorParsers", this.errorParserIds);
        }
        if (this.artifactExtension != null) {
            element.setAttribute("artifactExtension", this.artifactExtension);
        }
        if (this.cleanCommand != null) {
            element.setAttribute("cleanCommand", this.cleanCommand);
        }
        if (this.prebuildStep != null) {
            element.setAttribute("prebuildStep", this.prebuildStep);
        }
        if (this.postbuildStep != null) {
            element.setAttribute("postbuildStep", this.postbuildStep);
        }
        if (this.preannouncebuildStep != null) {
            element.setAttribute("preannouncebuildStep", this.preannouncebuildStep);
        }
        if (this.postannouncebuildStep != null) {
            element.setAttribute("postannouncebuildStep", this.postannouncebuildStep);
        }
        IResourceInfo[] infos = this.rcInfos.getResourceInfos();
        int i = 0;
        while (i < infos.length) {
            String elementName = infos[i].getKind() == 8 ? "fileInfo" : "folderInfo";
            ICStorageElement resElement = element.createChild(elementName);
            ((ResourceInfo)infos[i]).serialize(resElement);
            ++i;
        }
        PropertyManager.getInstance().serialize(this);
        if (this.sourceEntries != null && this.sourceEntries.length > 0) {
            ICStorageElement el = element.createChild("sourceEntries");
            LanguageSettingEntriesSerializer.serializeEntries((ICSettingEntry[])this.sourceEntries, (ICStorageElement)el);
        }
        this.setDirty(false);
    }

    @Override
    public IConfiguration getParent() {
        return this.parent;
    }

    @Override
    public IResource getOwner() {
        if (this.managedProject != null) {
            return this.managedProject.getOwner();
        }
        return null;
    }

    @Override
    public IProjectType getProjectType() {
        return this.projectType;
    }

    @Override
    public IManagedProject getManagedProject() {
        return this.managedProject;
    }

    @Override
    public IToolChain createToolChain(IToolChain superClass, String Id, String name, boolean isExtensionElement) {
        if (this.rootFolderInfo == null) {
            this.createRootFolderInfo();
        }
        return this.rootFolderInfo.createToolChain(superClass, Id, name, isExtensionElement);
    }

    private IFolderInfo createRootFolderInfo() {
        String id = ManagedBuildManager.calculateChildId(this.id, null);
        String name = "/";
        this.rootFolderInfo = new FolderInfo((IConfiguration)this, (IPath)new Path(name), id, name, this.isExtensionConfig);
        this.addResourceConfiguration(this.rootFolderInfo);
        return this.rootFolderInfo;
    }

    @Override
    public IToolChain getToolChain() {
        return this.rootFolderInfo.getToolChain();
    }

    @Override
    public IResourceConfiguration[] getResourceConfigurations() {
        return (IResourceConfiguration[])this.rcInfos.getResourceInfos(8, IResourceConfiguration.class);
    }

    @Override
    public IResourceConfiguration getResourceConfiguration(String resPath) {
        return this.rcInfos.getFileInfo(new Path(resPath).removeFirstSegments(1));
    }

    @Override
    public ITool[] getFilteredTools() {
        return this.rootFolderInfo.getFilteredTools();
    }

    @Override
    public ITool[] getTools() {
        return this.rootFolderInfo.getTools();
    }

    @Override
    public ITool getTool(String id) {
        return this.rootFolderInfo.getTool(id);
    }

    @Override
    public ITool[] getToolsBySuperClassId(String id) {
        return this.rootFolderInfo.getToolsBySuperClassId(id);
    }

    @Override
    public ITool getTargetTool() {
        String[] targetToolIds = this.rootFolderInfo.getToolChain().getTargetToolList();
        if (targetToolIds == null || targetToolIds.length == 0) {
            return null;
        }
        ITool[] tools = this.getFilteredTools();
        int i = 0;
        while (i < targetToolIds.length) {
            String targetToolId = targetToolIds[i];
            int j = 0;
            while (j < tools.length) {
                ITool targetTool;
                ITool tool = targetTool = tools[j];
                do {
                    if (!targetToolId.equals(tool.getId())) continue;
                    return targetTool;
                } while ((tool = tool.getSuperClass()) != null);
                ++j;
            }
            ++i;
        }
        return null;
    }

    @Override
    public String getToolCommand(ITool tool) {
        return tool.getToolCommand();
    }

    @Override
    public void setToolCommand(ITool tool, String command) {
        tool.setToolCommand(command);
    }

    @Override
    public IOption setOption(IHoldsOptions holder, IOption option, boolean value) throws BuildException {
        return this.getRootFolderInfo().setOption(holder, option, value);
    }

    @Override
    public IOption setOption(IHoldsOptions holder, IOption option, String value) throws BuildException {
        return this.getRootFolderInfo().setOption(holder, option, value);
    }

    @Override
    public IOption setOption(IHoldsOptions holder, IOption option, String[] value) throws BuildException {
        return this.getRootFolderInfo().setOption(holder, option, value);
    }

    void addResourceConfiguration(IResourceInfo resConfig) {
        if (resConfig.getPath().segmentCount() == 0) {
            this.rootFolderInfo = (FolderInfo)resConfig;
        }
        this.rcInfos.addResourceInfo(resConfig);
        this.isDirty = true;
    }

    @Override
    public void removeResourceConfiguration(IResourceInfo resConfig) {
        ManagedBuildManager.performValueHandlerEvent(resConfig, 2);
        ITool[] tools = resConfig.getTools();
        this.rcInfos.removeResourceInfo(resConfig.getPath());
        ((ResourceInfo)resConfig).removed();
        BuildSettingsUtil.disconnectDepentents((IConfiguration)this, tools);
        this.isDirty = true;
        this.rebuildNeeded = true;
    }

    @Override
    public String getName() {
        return this.name == null && this.parent != null ? this.parent.getName() : this.name;
    }

    @Override
    public String getArtifactExtension() {
        String ext = this.getArtifactExtensionAttribute(true);
        return ext != null ? ext : EMPTY_STRING;
    }

    public String getArtifactExtensionAttribute(boolean querySuperClass) {
        if (this.artifactExtension == null) {
            if (this.parent != null) {
                return this.parent.getArtifactExtension();
            }
            return null;
        }
        return this.artifactExtension;
    }

    @Override
    public String getArtifactName() {
        if (this.artifactName == null) {
            if (this.parent != null) {
                return this.parent.getArtifactName();
            }
            return EMPTY_STRING;
        }
        return this.artifactName;
    }

    @Override
    public String getBuildArguments() {
        IToolChain tc = this.getToolChain();
        IBuilder builder = tc.getBuilder();
        if (builder != null) {
            return builder.getArguments();
        }
        return "-k";
    }

    @Override
    public String getBuildCommand() {
        IToolChain tc = this.getToolChain();
        IBuilder builder = tc.getBuilder();
        if (builder != null) {
            return builder.getCommand();
        }
        return "make";
    }

    @Override
    public String getPrebuildStep() {
        if (this.prebuildStep == null) {
            if (this.parent != null) {
                return this.parent.getPrebuildStep();
            }
            return EMPTY_STRING;
        }
        return this.prebuildStep;
    }

    @Override
    public String getPostbuildStep() {
        if (this.postbuildStep == null) {
            if (this.parent != null) {
                return this.parent.getPostbuildStep();
            }
            return EMPTY_STRING;
        }
        return this.postbuildStep;
    }

    @Override
    public String getPreannouncebuildStep() {
        if (this.preannouncebuildStep == null) {
            if (this.parent != null) {
                return this.parent.getPreannouncebuildStep();
            }
            return EMPTY_STRING;
        }
        return this.preannouncebuildStep;
    }

    @Override
    public String getPostannouncebuildStep() {
        if (this.postannouncebuildStep == null) {
            if (this.parent != null) {
                return this.parent.getPostannouncebuildStep();
            }
            return EMPTY_STRING;
        }
        return this.postannouncebuildStep;
    }

    @Override
    public String getCleanCommand() {
        if (this.cleanCommand == null) {
            if (this.parent != null) {
                return this.parent.getCleanCommand();
            }
            if (Platform.getOS().equals("win32")) {
                return "del";
            }
            return "rm";
        }
        return this.cleanCommand;
    }

    @Override
    public String getDescription() {
        if (this.description == null) {
            if (this.parent != null) {
                return this.parent.getDescription();
            }
            return EMPTY_STRING;
        }
        return this.description;
    }

    @Override
    public String getErrorParserIds() {
        if (this.errorParserIds != null) {
            return this.errorParserIds;
        }
        String errorParsers = null;
        if (this.parent != null) {
            errorParsers = this.parent.getErrorParserIds();
        }
        if (errorParsers == null && this.rootFolderInfo != null) {
            errorParsers = this.rootFolderInfo.getErrorParserIds();
        }
        return errorParsers;
    }

    public String getErrorParserIdsAttribute() {
        if (this.errorParserIds != null) {
            return this.errorParserIds;
        }
        String errorParsers = null;
        if (this.parent != null) {
            errorParsers = ((Configuration)this.parent).getErrorParserIdsAttribute();
        }
        return errorParsers;
    }

    @Override
    public String[] getErrorParserList() {
        Set<String> set = this.contributeErrorParsers(null, true);
        if (set != null) {
            String[] result = new String[set.size()];
            set.toArray(result);
            return result;
        }
        return ErrorParserManager.getErrorParserAvailableIdsInContext((String)"build");
    }

    public Set<String> contributeErrorParsers(Set<String> set, boolean includeChildren) {
        String parserIDs = this.getErrorParserIdsAttribute();
        if (parserIDs != null) {
            if (set == null) {
                set = new LinkedHashSet<String>();
            }
            if (parserIDs.length() != 0) {
                StringTokenizer tok = new StringTokenizer(parserIDs, LANGUAGE_SETTINGS_PROVIDER_DELIMITER);
                while (tok.hasMoreElements()) {
                    set.add(tok.nextToken());
                }
            }
        }
        if (includeChildren) {
            IResourceInfo[] rcInfos = this.getResourceInfos();
            int i = 0;
            while (i < rcInfos.length) {
                ResourceInfo rcInfo = (ResourceInfo)rcInfos[i];
                set = rcInfo.contributeErrorParsers(set);
                ++i;
            }
        }
        return set;
    }

    private String getDefaultLanguageSettingsProvidersAttribute() {
        if (this.defaultLanguageSettingsProvidersAttribute == null && this.parent instanceof Configuration) {
            this.defaultLanguageSettingsProvidersAttribute = ((Configuration)this.parent).getDefaultLanguageSettingsProvidersAttribute();
        }
        return this.defaultLanguageSettingsProvidersAttribute;
    }

    @Override
    public String[] getDefaultLanguageSettingsProviderIds() {
        if (this.defaultLanguageSettingsProviderIds == null) {
            this.defaultLanguageSettingsProvidersAttribute = this.getDefaultLanguageSettingsProvidersAttribute();
            if (this.defaultLanguageSettingsProvidersAttribute != null) {
                String[] defaultIds;
                ArrayList<String> ids = new ArrayList<String>();
                String[] stringArray = defaultIds = this.defaultLanguageSettingsProvidersAttribute.split(LANGUAGE_SETTINGS_PROVIDER_DELIMITER);
                int n = defaultIds.length;
                int n2 = 0;
                while (n2 < n) {
                    String id = stringArray[n2];
                    if (id != null && !id.isEmpty()) {
                        if (id.startsWith(LANGUAGE_SETTINGS_PROVIDER_NEGATION_SIGN)) {
                            id = id.substring(1);
                            ids.remove(id);
                        } else if (!ids.contains(id)) {
                            if (id.contains($TOOLCHAIN)) {
                                String toolchainProvidersIds;
                                IToolChain toolchain = this.getToolChain();
                                if (toolchain != null && (toolchainProvidersIds = toolchain.getDefaultLanguageSettingsProviderIds()) != null) {
                                    ids.addAll(Arrays.asList(toolchainProvidersIds.split(LANGUAGE_SETTINGS_PROVIDER_DELIMITER)));
                                }
                            } else {
                                ids.add(id);
                            }
                        }
                    }
                    ++n2;
                }
                this.defaultLanguageSettingsProviderIds = ids.toArray(new String[ids.size()]);
            } else if (this.parent != null) {
                this.defaultLanguageSettingsProviderIds = this.parent.getDefaultLanguageSettingsProviderIds();
            }
        }
        return this.defaultLanguageSettingsProviderIds;
    }

    @Override
    public void setArtifactExtension(String extension) {
        if (extension == null && this.artifactExtension == null) {
            return;
        }
        if (this.artifactExtension == null || extension == null || !this.artifactExtension.equals(extension)) {
            this.artifactExtension = extension;
            if (!this.isExtensionElement()) {
                ITool tool = this.calculateTargetTool();
                if (tool != null) {
                    tool.setRebuildState(true);
                } else {
                    this.setRebuildState(true);
                }
            }
            this.isDirty = true;
        }
    }

    @Override
    public void setArtifactName(String name) {
        if (name == null && this.artifactName == null) {
            return;
        }
        if (this.artifactName == null || name == null || !this.artifactName.equals(name)) {
            if (this.canExportedArtifactInfo()) {
                ICConfigurationDescription des = ManagedBuildManager.getDescriptionForConfiguration(this);
                ICSettingEntry[] unresolved = new ICSettingEntry[]{CDataUtil.createCLibraryFileEntry((String)this.getArtifactName(), (int)0)};
                ICSettingEntry[] libs = CDataUtil.resolveEntries((ICSettingEntry[])unresolved, (ICConfigurationDescription)des);
                if (libs.length > 0) {
                    ICExternalSetting[] iCExternalSettingArray = des.getExternalSettings();
                    int n = iCExternalSettingArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ICExternalSetting setting = iCExternalSettingArray[n2];
                        LinkedHashSet<ICSettingEntry> entries = new LinkedHashSet<ICSettingEntry>(Arrays.asList(setting.getEntries()));
                        ICSettingEntry[] iCSettingEntryArray = libs;
                        int n3 = libs.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            ICSettingEntry lib = iCSettingEntryArray[n4];
                            if (entries.contains(lib)) {
                                entries.remove(lib);
                                des.removeExternalSetting(setting);
                                des.createExternalSetting(setting.getCompatibleLanguageIds(), setting.getCompatibleContentTypeIds(), setting.getCompatibleExtensions(), entries.toArray(new ICSettingEntry[entries.size()]));
                            }
                            ++n4;
                        }
                        ++n2;
                    }
                }
            }
            this.artifactName = name;
            if (!this.isExtensionElement()) {
                ITool tool = this.calculateTargetTool();
                if (tool != null) {
                    tool.setRebuildState(true);
                } else {
                    this.setRebuildState(true);
                }
            }
            this.isDirty = true;
            this.exportArtifactInfo();
        }
    }

    @Override
    public void setErrorParserIds(String ids) {
        String currentIds = this.getErrorParserIds();
        if (ids == null && currentIds == null) {
            return;
        }
        if (currentIds == null || ids == null || !currentIds.equals(ids)) {
            this.errorParserIds = ids;
            this.isDirty = true;
        }
    }

    @Override
    public void setCleanCommand(String command) {
        if (command == null && this.cleanCommand == null) {
            return;
        }
        if (this.cleanCommand == null || command == null || !this.cleanCommand.equals(command)) {
            this.cleanCommand = command;
            this.isDirty = true;
        }
    }

    @Override
    public void setDescription(String description) {
        if (description == null && this.description == null) {
            return;
        }
        if (this.description == null || description == null || !description.equals(this.description)) {
            this.description = description;
            this.isDirty = true;
        }
    }

    @Override
    public void setBuildArguments(String makeArgs) {
        IToolChain tc = this.getToolChain();
        IBuilder builder = tc.getBuilder();
        if (makeArgs == null) {
            if (!builder.isExtensionElement()) {
                builder.setArguments(makeArgs);
            }
        } else if (!makeArgs.equals(builder.getArguments())) {
            if (builder.isExtensionElement()) {
                String subId = ManagedBuildManager.calculateChildId(builder.getId(), null);
                String builderName = String.valueOf(builder.getName()) + "." + this.getName();
                builder = this.getToolChain().createBuilder(builder, subId, builderName, false);
            }
            builder.setArguments(makeArgs);
        }
    }

    @Override
    public void setBuildCommand(String command) {
        IToolChain tc = this.getToolChain();
        IBuilder builder = tc.getBuilder();
        if (command == null) {
            if (!builder.isExtensionElement()) {
                builder.setCommand(command);
            }
        } else if (!command.equals(builder.getCommand())) {
            if (builder.isExtensionElement()) {
                String subId = ManagedBuildManager.calculateChildId(builder.getId(), null);
                String builderName = String.valueOf(builder.getName()) + "." + this.getName();
                builder = this.getToolChain().createBuilder(builder, subId, builderName, false);
            }
            builder.setCommand(command);
        }
    }

    @Override
    public void setPrebuildStep(String step) {
        String currentPrebuildStep = this.getPrebuildStep();
        if (step == null && this.prebuildStep == null) {
            return;
        }
        if (currentPrebuildStep == null || step == null || !currentPrebuildStep.equals(step)) {
            this.prebuildStep = step;
            this.isDirty = true;
        }
    }

    @Override
    public void setPostbuildStep(String step) {
        String currentPostbuildStep = this.getPostbuildStep();
        if (step == null && this.postbuildStep == null) {
            return;
        }
        if (currentPostbuildStep == null || step == null || !currentPostbuildStep.equals(step)) {
            this.postbuildStep = step;
            this.isDirty = true;
        }
    }

    @Override
    public void setPreannouncebuildStep(String announceStep) {
        String currentPreannouncebuildStep = this.getPreannouncebuildStep();
        if (announceStep == null && this.preannouncebuildStep == null) {
            return;
        }
        if (currentPreannouncebuildStep == null || announceStep == null || !currentPreannouncebuildStep.equals(announceStep)) {
            this.preannouncebuildStep = announceStep;
            this.isDirty = true;
        }
    }

    @Override
    public void setPostannouncebuildStep(String announceStep) {
        String currentAnnounceStep = this.getPostannouncebuildStep();
        if (announceStep == null && this.postannouncebuildStep == null) {
            return;
        }
        if (currentAnnounceStep == null || announceStep == null || !currentAnnounceStep.equals(announceStep)) {
            this.postannouncebuildStep = announceStep;
            this.isDirty = true;
        }
    }

    @Override
    public boolean isSupported() {
        IFolderInfo foInfo = this.getRootFolderInfo();
        if (foInfo != null) {
            return foInfo.isSupported();
        }
        return false;
    }

    @Override
    public boolean isHeaderFile(String ext) {
        return this.getRootFolderInfo().isHeaderFile(ext);
    }

    @Override
    public boolean isExtensionElement() {
        return this.isExtensionConfig;
    }

    @Override
    public boolean isDirty() {
        if (this.isExtensionConfig) {
            return false;
        }
        if (this.isDirty) {
            return true;
        }
        IResourceInfo[] infos = this.rcInfos.getResourceInfos();
        int i = 0;
        while (i < infos.length) {
            if (infos[i].isDirty()) {
                return true;
            }
            ++i;
        }
        return this.isDirty;
    }

    @Override
    public boolean needsRebuild() {
        return this.needsRebuild(true);
    }

    @Override
    public boolean needsFullRebuild() {
        return this.needsRebuild(false);
    }

    public boolean needsRebuild(boolean checkChildren) {
        boolean needRebuild;
        boolean bl = needRebuild = this.rebuildNeeded || this.resourceChangesRequireRebuild();
        if (needRebuild || !checkChildren) {
            return needRebuild;
        }
        IResourceInfo[] infos = this.rcInfos.getResourceInfos();
        int i = 0;
        while (i < infos.length) {
            if (infos[i].needsRebuild()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
        if (!isDirty) {
            IResourceInfo[] infos = this.rcInfos.getResourceInfos();
            int i = 0;
            while (i < infos.length) {
                infos[i].setDirty(false);
                ++i;
            }
        }
    }

    @Override
    public void setRebuildState(boolean rebuild) {
        if (this.isExtensionElement() && rebuild) {
            return;
        }
        if (this.rebuildNeeded != rebuild) {
            this.rebuildNeeded = rebuild;
            this.saveRebuildState();
        }
        if (!this.rebuildNeeded) {
            this.setResourceChangeState(0);
            IResourceInfo[] infos = this.rcInfos.getResourceInfos();
            int i = 0;
            while (i < infos.length) {
                infos[i].setRebuildState(false);
                ++i;
            }
        }
    }

    @Override
    public boolean hasOverriddenBuildCommand() {
        IBuilder superB;
        IBuilder builder = this.getToolChain().getBuilder();
        if (builder != null && (superB = builder.getSuperClass()) != null) {
            String superA;
            String superC;
            String command = builder.getCommand();
            if (command != null && (superC = superB.getCommand()) != null && !command.equals(superC)) {
                return true;
            }
            String args = builder.getArguments();
            if (args != null && (superA = superB.getArguments()) != null && !args.equals(superA)) {
                return true;
            }
        }
        return false;
    }

    public void resolveReferences() {
        if (!this.resolved) {
            this.resolved = true;
            ResourceInfo[] infos = (ResourceInfo[])this.rcInfos.getResourceInfos(ResourceInfo.class);
            int i = 0;
            while (i < infos.length) {
                infos[i].resolveReferences();
                ++i;
            }
            if (this.parentId != null) {
                this.parent = ManagedBuildManager.getExtensionConfiguration(this.parentId);
            }
        }
    }

    public void reset() {
        ((FolderInfo)this.getRootFolderInfo()).resetOptionSettings();
    }

    @Override
    public IResourceConfiguration createResourceConfiguration(IFile file) {
        return this.createFileInfo(file.getFullPath().removeFirstSegments(1));
    }

    @Override
    public IFileInfo createFileInfo(IPath path) {
        String resourceName = path.lastSegment();
        String id = ManagedBuildManager.calculateChildId(this.getId(), path.toString());
        return this.createFileInfo(path, id, resourceName);
    }

    @Override
    public IFileInfo createFileInfo(IPath path, String id, String name) {
        IResourceInfo info = this.getResourceInfo(path, false);
        IFileInfo fileInfo = null;
        if (info instanceof IFileInfo) {
            fileInfo = (IFileInfo)info;
        } else if (info instanceof IFolderInfo) {
            IFolderInfo base = (IFolderInfo)info;
            fileInfo = this.createFileInfo(path, base, null, id, name);
        }
        return fileInfo;
    }

    @Override
    public IFileInfo createFileInfo(IPath path, IFolderInfo base, ITool baseTool, String id, String name) {
        if (base.getPath().equals((Object)path)) {
            return null;
        }
        ResourceConfiguration fileInfo = new ResourceConfiguration((FolderInfo)base, baseTool, id, name, path);
        this.addResourceConfiguration(fileInfo);
        ManagedBuildManager.performValueHandlerEvent(fileInfo, 1);
        return fileInfo;
    }

    @Override
    public IFileInfo createFileInfo(IPath path, IFileInfo base, String id, String name) {
        if (base.getPath().equals((Object)path)) {
            return null;
        }
        ResourceConfiguration fileInfo = new ResourceConfiguration((ResourceConfiguration)base, path, id, name);
        this.addResourceConfiguration(fileInfo);
        ManagedBuildManager.performValueHandlerEvent(fileInfo, 1);
        return fileInfo;
    }

    @Override
    public IConfigurationEnvironmentVariableSupplier getEnvironmentVariableSupplier() {
        IToolChain toolChain = this.getToolChain();
        if (toolChain != null) {
            return toolChain.getEnvironmentVariableSupplier();
        }
        return null;
    }

    @Override
    public Version getVersion() {
        if (this.version == null && this.rootFolderInfo.getToolChain() != null) {
            return this.rootFolderInfo.getToolChain().getVersion();
        }
        return this.version;
    }

    @Override
    public void setVersion(Version version) {
    }

    @Override
    public IConfigurationBuildMacroSupplier getBuildMacroSupplier() {
        IToolChain toolChain = this.getToolChain();
        if (toolChain != null) {
            return toolChain.getBuildMacroSupplier();
        }
        return null;
    }

    @Override
    public boolean isTemporary() {
        return this.isTemporary;
    }

    @Override
    public void updateManagedBuildRevision(String revision) {
        super.updateManagedBuildRevision(revision);
        ResourceInfo[] infos = (ResourceInfo[])this.rcInfos.getResourceInfos(ResourceInfo.class);
        int i = 0;
        while (i < infos.length) {
            infos[i].updateManagedBuildRevision(revision);
            ++i;
        }
    }

    public void setParent(IConfiguration parent) {
        if (this.parent != parent) {
            this.parent = parent;
            if (!this.isExtensionElement()) {
                this.setDirty(true);
            }
        }
    }

    @Override
    public ITool calculateTargetTool() {
        ITool tool = this.getTargetTool();
        if (tool == null) {
            tool = this.getToolFromOutputExtension(this.getArtifactExtension());
        }
        if (tool == null) {
            IConfiguration extCfg = this;
            while (extCfg != null && !extCfg.isExtensionElement()) {
                extCfg = extCfg.getParent();
            }
            if (extCfg != null) {
                tool = this.getToolFromOutputExtension(extCfg.getArtifactExtension());
            }
        }
        return tool;
    }

    @Override
    public ITool getToolFromOutputExtension(String extension) {
        return this.getRootFolderInfo().getToolFromOutputExtension(extension);
    }

    @Override
    public ITool getToolFromInputExtension(String sourceExtension) {
        return this.getRootFolderInfo().getToolFromInputExtension(sourceExtension);
    }

    public void addResourceChangeState(int state) {
        this.setResourceChangeState(state | this.resourceChangeState);
    }

    private void setResourceChangeState(int state) {
        if (this.resourceChangeState != state) {
            this.resourceChangeState = state;
            this.saveResourceChangeState();
        }
    }

    private boolean resourceChangesRequireRebuild() {
        return this.isInternalBuilderEnabled() ? this.resourceChangeState != 0 : (this.resourceChangeState & 2) == 2;
    }

    private void saveRebuildState() {
        PropertyManager.getInstance().setProperty(this, REBUILD_STATE, Boolean.toString(this.rebuildNeeded));
    }

    private void saveResourceChangeState() {
        PropertyManager.getInstance().setProperty(this, RC_CHANGE_STATE, Integer.toString(this.resourceChangeState));
    }

    public void enableInternalBuilder(boolean enable) {
        if (enable == this.isInternalBuilderEnabled()) {
            return;
        }
        IBuilder builder = this.getBuilderForInternalBuilderEnablement(enable, true);
        if (builder != null) {
            if (enable) {
                this.savePrevBuilderId(this.getBuilder());
            }
            this.changeBuilder(builder, ManagedBuildManager.calculateChildId(builder.getId(), null), builder.getName(), true);
            if (enable) {
                try {
                    this.setManagedBuildOn(true);
                }
                catch (BuildException buildException) {
                    // empty catch block
                }
            }
        }
    }

    public boolean canEnableInternalBuilder(boolean enable) {
        return this.getBuilderForInternalBuilderEnablement(enable, true) != null;
    }

    /*
     * Unable to fully structure code
     */
    private IBuilder getBuilderForInternalBuilderEnablement(boolean enable, boolean checkCompatibility) {
        block6: {
            block5: {
                newBuilder = null;
                if (!enable) break block5;
                if (this.supportsBuild(true, false) && (b = ManagedBuildManager.getInternalBuilder()) != null && (!checkCompatibility || this.isBuilderCompatible(b))) {
                    newBuilder = b;
                }
                break block6;
            }
            id = this.getPrevBuilderId();
            if (id != null && (b = ManagedBuildManager.getExtensionBuilder(id)) != null && (!checkCompatibility || this.isBuilderCompatible(b))) {
                newBuilder = b;
            }
            if (newBuilder != null) break block6;
            tc = this.getToolChain();
            while (tc != null) {
                block7: {
                    b = tc.getBuilder();
                    if (!b.isInternalBuilder()) ** GOTO lbl17
                    break block7;
lbl-1000:
                    // 1 sources

                    {
                        b = b.getSuperClass();
lbl17:
                        // 2 sources

                        ** while (b != null && !b.isExtensionElement())
                    }
lbl18:
                    // 1 sources

                    if (b != null && (!checkCompatibility || this.isBuilderCompatible(b))) {
                        newBuilder = b;
                        break;
                    }
                }
                tc = tc.getSuperClass();
            }
        }
        return newBuilder;
    }

    private void savePrevBuilderId(IBuilder builder) {
        ToolChain tc;
        IBuilder b = builder;
        while (b != null && !b.isExtensionElement()) {
            b = b.getSuperClass();
        }
        if (b == null) {
            b = builder;
        }
        if ((tc = (ToolChain)this.getToolChain()) != null) {
            tc.setNonInternalBuilderId(b.getId());
        }
    }

    private String getPrevBuilderId() {
        ToolChain tc = (ToolChain)this.getToolChain();
        if (tc != null) {
            return tc.getNonInternalBuilderId();
        }
        return null;
    }

    public boolean isInternalBuilderEnabled() {
        return this.getBuilder().isInternalBuilder();
    }

    public void setInternalBuilderIgnoreErr(boolean ignore) {
        try {
            this.getEditableBuilder().setStopOnError(!ignore);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public boolean getInternalBuilderIgnoreErr() {
        return !this.getBuilder().isStopOnError();
    }

    @Deprecated
    public void setInternalBuilderParallel(boolean parallel) {
        this.setParallelDef(parallel);
    }

    @Deprecated
    public boolean getInternalBuilderParallel() {
        return this.getParallelDef();
    }

    public void setParallelDef(boolean parallel) {
        if (this.getParallelDef() == parallel) {
            return;
        }
        try {
            this.getEditableBuilder().setParallelBuildOn(parallel);
        }
        catch (CoreException e) {
            ManagedBuilderCorePlugin.log(e);
        }
    }

    public boolean getParallelDef() {
        return this.getBuilder().isParallelBuildOn();
    }

    public void setParallelNumber(int jobs) {
        try {
            this.getEditableBuilder().setParallelizationNum(jobs);
        }
        catch (CoreException e) {
            ManagedBuilderCorePlugin.log(e);
        }
    }

    public int getParallelNumber() {
        return this.getBuilder().getParallelizationNum();
    }

    @Override
    public IResourceInfo[] getResourceInfos() {
        return this.rcInfos.getResourceInfos();
    }

    @Override
    public IResourceInfo getResourceInfo(IPath path, boolean exactPath) {
        return this.rcInfos.getResourceInfo(path, exactPath);
    }

    @Override
    public IResourceInfo getResourceInfoById(String id) {
        IResourceInfo[] infos = this.rcInfos.getResourceInfos();
        int i = 0;
        while (i < infos.length) {
            if (id.equals(infos[i].getId())) {
                return infos[i];
            }
            ++i;
        }
        return null;
    }

    @Override
    public IFolderInfo getRootFolderInfo() {
        return this.rootFolderInfo;
    }

    ResourceInfoContainer getRcInfoContainer(IResourceInfo rcInfo) {
        PathSettingsContainer cr = this.pathSettings.getChildContainer(rcInfo.getPath(), true, true);
        return new ResourceInfoContainer(cr, false);
    }

    @Override
    public CConfigurationData getConfigurationData() {
        return this.fCfgData;
    }

    @Override
    public void removeResourceInfo(IPath path) {
        IResourceInfo info = this.getResourceInfo(path, true);
        if (info != null) {
            this.removeResourceConfiguration(info);
        }
    }

    @Override
    public IFolderInfo createFolderInfo(IPath path) {
        String resourceName = path.lastSegment();
        String id = ManagedBuildManager.calculateChildId(this.getId(), path.toString());
        return this.createFolderInfo(path, id, resourceName);
    }

    @Override
    public IFolderInfo createFolderInfo(IPath path, String id, String name) {
        IResourceInfo info = this.getResourceInfo(path, false);
        IFolderInfo folderInfo = null;
        if (!(info instanceof IFileInfo) && info instanceof IFolderInfo) {
            IFolderInfo base = (IFolderInfo)info;
            folderInfo = this.createFolderInfo(path, base, id, name);
        }
        return folderInfo;
    }

    @Override
    public IFolderInfo createFolderInfo(IPath path, IFolderInfo base, String id, String name) {
        if (base.getPath().equals((Object)path)) {
            return null;
        }
        FolderInfo folderInfo = new FolderInfo((FolderInfo)base, id, name, path);
        this.addResourceConfiguration(folderInfo);
        folderInfo.propertiesChanged();
        ManagedBuildManager.performValueHandlerEvent(folderInfo, 1);
        return folderInfo;
    }

    @Override
    public ICSourceEntry[] getSourceEntries() {
        if (this.sourceEntries == null || this.sourceEntries.length == 0) {
            if (this.parent != null && this.sourceEntries == null) {
                return this.parent.getSourceEntries();
            }
            return new ICSourceEntry[]{new CSourceEntry((IPath)Path.EMPTY, null, 24)};
        }
        return (ICSourceEntry[])this.sourceEntries.clone();
    }

    @Override
    public void setSourceEntries(ICSourceEntry[] entries) {
        this.setSourceEntries(entries, true);
    }

    public void setSourceEntries(ICSourceEntry[] entries, boolean setRebuildState) {
        this.exportArtifactInfo();
        if (Arrays.equals(this.getSourceEntries(), entries)) {
            return;
        }
        ICSourceEntry[] iCSourceEntryArray = this.sourceEntries = entries != null ? (ICSourceEntry[])entries.clone() : null;
        if (setRebuildState) {
            this.setDirty(true);
            this.setRebuildState(true);
        }
    }

    public void setErrorParserAttribute(String[] ids) {
        if (ids == null) {
            this.setErrorParserIds(null);
        } else if (ids.length == 0) {
            this.setErrorParserIds(EMPTY_STRING);
        } else {
            StringBuilder buf = new StringBuilder();
            buf.append(ids[0]);
            int i = 1;
            while (i < ids.length) {
                buf.append(LANGUAGE_SETTINGS_PROVIDER_DELIMITER).append(ids[i]);
                ++i;
            }
            this.setErrorParserIds(buf.toString());
        }
    }

    @Override
    public void setErrorParserList(String[] ids) {
        if (ids == null) {
            this.resetErrorParsers();
        } else {
            this.setErrorParserAttribute(ids);
        }
    }

    public void resetErrorParsers() {
        this.errorParserIds = null;
        IResourceInfo[] rcInfos = this.getResourceInfos();
        int i = 0;
        while (i < rcInfos.length) {
            ResourceInfo rcInfo = (ResourceInfo)rcInfos[i];
            rcInfo.resetErrorParsers();
            ++i;
        }
    }

    void removeErrorParsers(Set<String> set) {
        if (set != null && set.isEmpty()) {
            Set<String> oldSet = this.contributeErrorParsers(null, false);
            if (oldSet == null) {
                oldSet = new LinkedHashSet<String>();
            }
            oldSet.removeAll(set);
            this.setErrorParserAttribute(oldSet.toArray(new String[oldSet.size()]));
            IResourceInfo[] rcInfos = this.getResourceInfos();
            int i = 0;
            while (i < rcInfos.length) {
                ResourceInfo rcInfo = (ResourceInfo)rcInfos[i];
                rcInfo.removeErrorParsers(set);
                ++i;
            }
        }
    }

    @Override
    public CBuildData getBuildData() {
        return this.getEditableBuilder().getBuildData();
    }

    @Override
    public IBuilder getEditableBuilder() {
        IToolChain tc = this.getToolChain();
        IBuilder builder = tc.getBuilder();
        if (builder.isExtensionElement()) {
            String subId = ManagedBuildManager.calculateChildId(builder.getId(), null);
            String builderName = String.valueOf(builder.getName()) + "." + this.getName();
            builder = this.getToolChain().createBuilder(builder, subId, builderName, false);
        }
        return builder;
    }

    @Override
    public IBuilder getBuilder() {
        return this.getToolChain().getBuilder();
    }

    @Override
    public String getOutputPrefix(String outputExtension) {
        String ext = outputExtension == null ? EMPTY_STRING : outputExtension;
        String flags = EMPTY_STRING;
        ITool[] tools = this.getFilteredTools();
        int index = 0;
        while (index < tools.length) {
            ITool tool = tools[index];
            if (tool.producesFileType(ext)) {
                flags = tool.getOutputPrefix();
            }
            ++index;
        }
        return flags;
    }

    public ICConfigurationDescription getConfigurationDescription() {
        return this.fCfgDes;
    }

    public void setConfigurationDescription(ICConfigurationDescription cfgDes) {
        this.fCfgDes = cfgDes;
    }

    @Override
    public IBuildObjectProperties getBuildProperties() {
        if (this.buildProperties == null) {
            BuildObjectProperties parentProps = this.findBuildProperties();
            this.buildProperties = parentProps != null ? new BuildObjectProperties(parentProps, (IBuildPropertiesRestriction)this, (IBuildPropertyChangeListener)this) : new BuildObjectProperties(this, this);
        }
        return this.buildProperties;
    }

    @Override
    public IOptionalBuildProperties getOptionalBuildProperties() {
        if (this.optionalBuildProperties == null) {
            OptionalBuildProperties parentProps = this.findOptionalBuildProperties();
            this.optionalBuildProperties = parentProps != null ? new OptionalBuildProperties(parentProps) : new OptionalBuildProperties();
        }
        return this.optionalBuildProperties;
    }

    private BuildObjectProperties findBuildProperties() {
        if (this.buildProperties == null) {
            if (this.parent != null) {
                return ((Configuration)this.parent).findBuildProperties();
            }
            return null;
        }
        return this.buildProperties;
    }

    private OptionalBuildProperties findOptionalBuildProperties() {
        if (this.optionalBuildProperties == null) {
            if (this.parent != null) {
                return ((Configuration)this.parent).findOptionalBuildProperties();
            }
            return null;
        }
        return this.optionalBuildProperties;
    }

    public boolean supportsType(IBuildPropertyType type) {
        return this.supportsType(type.getId());
    }

    public boolean supportsValue(IBuildPropertyType type, IBuildPropertyValue value) {
        return this.supportsValue(type.getId(), value.getId());
    }

    @Override
    public void propertiesChanged() {
        if (this.isExtensionConfig) {
            return;
        }
        BooleanExpressionApplicabilityCalculator calculator = this.getBooleanExpressionCalculator();
        if (calculator != null) {
            calculator.adjustConfiguration(this, false);
        }
        IResourceInfo[] infos = this.getResourceInfos();
        int i = 0;
        while (i < infos.length) {
            ((ResourceInfo)infos[i]).propertiesChanged();
            ++i;
        }
    }

    public BooleanExpressionApplicabilityCalculator getBooleanExpressionCalculator() {
        if (this.booleanExpressionCalculator == null && this.parent != null) {
            return ((Configuration)this.parent).getBooleanExpressionCalculator();
        }
        return this.booleanExpressionCalculator;
    }

    @Override
    public boolean isSystemObject() {
        if (this.isTest) {
            return true;
        }
        if (this.getProjectType() != null) {
            return this.getProjectType().isSystemObject();
        }
        return false;
    }

    @Override
    public String getOutputExtension(String resourceExtension) {
        return this.getRootFolderInfo().getOutputExtension(resourceExtension);
    }

    @Override
    public String getOutputFlag(String outputExt) {
        String ext = outputExt == null ? EMPTY_STRING : outputExt;
        String flags = EMPTY_STRING;
        ITool[] tools = this.getFilteredTools();
        int index = 0;
        while (index < tools.length) {
            ITool tool = tools[index];
            if (tool.producesFileType(ext)) {
                flags = tool.getOutputFlag();
            }
            ++index;
        }
        return flags;
    }

    @Override
    public IManagedCommandLineInfo generateToolCommandLineInfo(String sourceExtension, String[] flags, String outputFlag, String outputPrefix, String outputName, String[] inputResources, IPath inputLocation, IPath outputLocation) {
        ITool[] tools = this.getFilteredTools();
        int index = 0;
        while (index < tools.length) {
            ITool tool = tools[index];
            if (tool.buildsFileType(sourceExtension)) {
                String cmd = tool.getToolCommand();
                try {
                    String resolvedCommand = null;
                    resolvedCommand = inputLocation != null && inputLocation.toString().indexOf(WHITE_SPACE) != -1 || outputLocation != null && outputLocation.toString().indexOf(WHITE_SPACE) != -1 ? ManagedBuildManager.getBuildMacroProvider().resolveValue(cmd, EMPTY_STRING, WHITE_SPACE, 1, new FileContextData(inputLocation, outputLocation, null, tool)) : ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(cmd, EMPTY_STRING, WHITE_SPACE, 1, new FileContextData(inputLocation, outputLocation, null, tool));
                    resolvedCommand = resolvedCommand.trim();
                    if (resolvedCommand.length() > 0) {
                        cmd = resolvedCommand;
                    }
                }
                catch (BuildMacroException resolvedCommand) {
                    // empty catch block
                }
                IManagedCommandLineGenerator gen = tool.getCommandLineGenerator();
                return gen.generateCommandLineInfo(tool, cmd, flags, outputFlag, outputPrefix, outputName, inputResources, tool.getCommandLinePattern());
            }
            ++index;
        }
        return null;
    }

    @Override
    public String[] getUserObjects(String extension) {
        Vector<String> objs = new Vector<String>();
        ITool tool = this.calculateTargetTool();
        if (tool == null) {
            tool = this.getToolFromOutputExtension(extension);
        }
        if (tool != null) {
            IOption[] opts = tool.getOptions();
            int i = 0;
            while (i < opts.length) {
                block12: {
                    IOption option = opts[i];
                    try {
                        String[] unresolved;
                        IOptionApplicability applicabilityCalculator;
                        if (option.getValueType() != 7 || (applicabilityCalculator = option.getApplicabilityCalculator()) != null && !applicabilityCalculator.isOptionUsedInCommandLine(this, tool, option)) break block12;
                        boolean generateDefaultCommand = true;
                        IOptionCommandGenerator commandGenerator = option.getCommandGenerator();
                        if (commandGenerator != null) {
                            BuildfileMacroSubstitutor macroSubstitutor = new BuildfileMacroSubstitutor(null, EMPTY_STRING, WHITE_SPACE);
                            BuildMacroProvider provider = BuildMacroProvider.getDefault();
                            IMacroContextInfo info = provider.getMacroContextInfo(2, new OptionContextData(option, (IBuildObject)tool));
                            if (info != null) {
                                macroSubstitutor.setMacroContextInfo(info);
                                String command = commandGenerator.generateCommand(option, (IVariableSubstitutor)macroSubstitutor);
                                if (command != null) {
                                    objs.add(command);
                                    generateDefaultCommand = false;
                                }
                            }
                        }
                        if (!generateDefaultCommand || (unresolved = option.getUserObjects()) == null || unresolved.length <= 0) break block12;
                        int k = 0;
                        while (k < unresolved.length) {
                            try {
                                String[] resolved = ManagedBuildManager.getBuildMacroProvider().resolveStringListValueToMakefileFormat(unresolved[k], EMPTY_STRING, WHITE_SPACE, 2, new OptionContextData(option, (IBuildObject)tool));
                                if (resolved != null && resolved.length > 0) {
                                    objs.addAll(Arrays.asList(resolved));
                                }
                            }
                            catch (BuildMacroException buildMacroException) {
                                // empty catch block
                            }
                            ++k;
                        }
                    }
                    catch (CdtVariableException | BuildException throwable) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
        return objs.toArray(new String[objs.size()]);
    }

    @Override
    public String[] getLibs(String extension) {
        Vector<String> libs = new Vector<String>();
        ITool tool = this.calculateTargetTool();
        if (tool == null) {
            tool = this.getToolFromOutputExtension(extension);
        }
        if (tool != null) {
            IOption[] opts = tool.getOptions();
            int i = 0;
            while (i < opts.length) {
                block14: {
                    IOption option = opts[i];
                    try {
                        IOptionApplicability applicabilityCalculator;
                        if (option.getValueType() != 6 || (applicabilityCalculator = option.getApplicabilityCalculator()) != null && !applicabilityCalculator.isOptionUsedInCommandLine(this, tool, option)) break block14;
                        boolean generateDefaultCommand = true;
                        IOptionCommandGenerator commandGenerator = option.getCommandGenerator();
                        if (commandGenerator != null) {
                            BuildfileMacroSubstitutor macroSubstitutor = new BuildfileMacroSubstitutor(null, EMPTY_STRING, WHITE_SPACE);
                            BuildMacroProvider provider = BuildMacroProvider.getDefault();
                            IMacroContextInfo info = provider.getMacroContextInfo(2, new OptionContextData(option, (IBuildObject)tool));
                            if (info != null) {
                                macroSubstitutor.setMacroContextInfo(info);
                                String command = commandGenerator.generateCommand(option, (IVariableSubstitutor)macroSubstitutor);
                                if (command != null) {
                                    libs.add(command);
                                    generateDefaultCommand = false;
                                }
                            }
                        }
                        if (!generateDefaultCommand) break block14;
                        String command = option.getCommand();
                        String[] allLibs = option.getLibraries();
                        int j = 0;
                        while (j < allLibs.length) {
                            try {
                                String[] resolved = ManagedBuildManager.getBuildMacroProvider().resolveStringListValueToMakefileFormat(allLibs[j], WHITE_SPACE, WHITE_SPACE, 2, new OptionContextData(option, (IBuildObject)tool));
                                if (resolved != null && resolved.length > 0) {
                                    int k = 0;
                                    while (k < resolved.length) {
                                        String string = resolved[k];
                                        if (string.length() > 0) {
                                            libs.add(String.valueOf(command) + string);
                                        }
                                        ++k;
                                    }
                                }
                            }
                            catch (BuildMacroException buildMacroException) {
                                // empty catch block
                            }
                            ++j;
                        }
                    }
                    catch (CdtVariableException | BuildException throwable) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
        return libs.toArray(new String[libs.size()]);
    }

    @Override
    public boolean buildsFileType(String srcExt) {
        return this.getRootFolderInfo().buildsFileType(srcExt);
    }

    public boolean canExportedArtifactInfo() {
        if (this.isExtensionConfig) {
            return false;
        }
        IBuildObjectProperties props = this.getBuildProperties();
        IBuildProperty prop = props.getProperty("org.eclipse.cdt.build.core.buildArtefactType");
        if (prop == null) {
            return false;
        }
        String valueId = prop.getValue().getId();
        if (!"org.eclipse.cdt.build.core.buildArtefactType.sharedLib".equals(valueId) && !"org.eclipse.cdt.build.core.buildArtefactType.staticLib".equals(valueId)) {
            return false;
        }
        ICConfigurationDescription des = ManagedBuildManager.getDescriptionForConfiguration(this);
        return des != null && !des.isReadOnly();
    }

    public void exportArtifactInfo() {
        if (!this.canExportedArtifactInfo()) {
            return;
        }
        ICConfigurationDescription des = ManagedBuildManager.getDescriptionForConfiguration(this);
        if (des != null && !des.isReadOnly()) {
            ICOutputEntry[] entries = this.getConfigurationData().getBuildData().getOutputDirectories();
            IPath path = this.getOwner().getFullPath();
            ArrayList<Object> list = new ArrayList<Object>(entries.length + 1);
            list.add(CDataUtil.createCIncludePathEntry((String)path.toString(), (int)8));
            entries = CDataUtil.resolveEntries((ICOutputEntry[])entries, (ICConfigurationDescription)des);
            int i = 0;
            while (i < entries.length) {
                ICOutputEntry out = entries[i];
                String value = out.getValue();
                Path p = new Path(value);
                if (!p.isAbsolute()) {
                    value = this.getOwner().getFullPath().append(value).toString();
                }
                CLibraryPathEntry lib = CDataUtil.createCLibraryPathEntry((String)value, (int)(out.getFlags() & 0xFFFFFFEF));
                list.add(lib);
                ++i;
            }
            ICSettingEntry[] unresolved = new ICSettingEntry[]{CDataUtil.createCLibraryFileEntry((String)this.getArtifactName(), (int)0)};
            ICSettingEntry[] libFiles = CDataUtil.resolveEntries((ICSettingEntry[])unresolved, (ICConfigurationDescription)des);
            list.add(libFiles[0]);
            des.createExternalSetting(null, null, null, list.toArray(new ICSettingEntry[list.size()]));
        }
    }

    @Override
    public boolean supportsBuild(boolean managed) {
        return this.supportsBuild(managed, true);
    }

    public boolean supportsBuild(boolean managed, boolean checkBuilder) {
        IBuilder builder;
        IResourceInfo[] rcs = this.getResourceInfos();
        int i = 0;
        while (i < rcs.length) {
            if (!rcs[i].supportsBuild(managed)) {
                return false;
            }
            ++i;
        }
        return !checkBuilder || (builder = this.getBuilder()) == null || builder.supportsBuild(managed);
    }

    @Override
    public boolean supportsType(String typeId) {
        SupportedProperties props = this.findSupportedProperties();
        boolean supports = false;
        if (props != null) {
            supports = props.supportsType(typeId);
        }
        if (!supports) {
            supports = ((ToolChain)this.getToolChain()).supportsType(typeId);
        }
        return supports;
    }

    @Override
    public boolean supportsValue(String typeId, String valueId) {
        SupportedProperties props = this.findSupportedProperties();
        boolean supports = false;
        if (props != null) {
            supports = props.supportsValue(typeId, valueId);
        }
        if (!supports) {
            supports = ((ToolChain)this.getToolChain()).supportsValue(typeId, valueId);
        }
        return supports;
    }

    private SupportedProperties findSupportedProperties() {
        if (this.supportedProperties == null && this.parent != null) {
            return ((Configuration)this.parent).findSupportedProperties();
        }
        return this.supportedProperties;
    }

    private void loadProperties(IManagedConfigElement el) {
        this.supportedProperties = new SupportedProperties(el);
    }

    @Override
    public String[] getRequiredTypeIds() {
        SupportedProperties props = this.findSupportedProperties();
        ArrayList<String> list = new ArrayList<String>();
        if (props != null) {
            list.addAll(Arrays.asList(props.getRequiredTypeIds()));
        }
        list.addAll(Arrays.asList(((ToolChain)this.getToolChain()).getRequiredTypeIds()));
        return list.toArray(new String[list.size()]);
    }

    @Override
    public String[] getSupportedTypeIds() {
        SupportedProperties props = this.findSupportedProperties();
        ArrayList<String> list = new ArrayList<String>();
        if (props != null) {
            list.addAll(Arrays.asList(props.getSupportedTypeIds()));
        }
        list.addAll(Arrays.asList(((ToolChain)this.getToolChain()).getSupportedTypeIds()));
        return list.toArray(new String[list.size()]);
    }

    @Override
    public String[] getSupportedValueIds(String typeId) {
        SupportedProperties props = this.findSupportedProperties();
        ArrayList<String> list = new ArrayList<String>();
        if (props != null) {
            list.addAll(Arrays.asList(props.getSupportedValueIds(typeId)));
        }
        list.addAll(Arrays.asList(((ToolChain)this.getToolChain()).getSupportedValueIds(typeId)));
        return list.toArray(new String[list.size()]);
    }

    @Override
    public boolean requiresType(String typeId) {
        SupportedProperties props = this.findSupportedProperties();
        boolean requires = false;
        if (props != null) {
            requires = props.requiresType(typeId);
        }
        if (!requires) {
            requires = ((ToolChain)this.getToolChain()).requiresType(typeId);
        }
        return requires;
    }

    @Override
    public boolean isManagedBuildOn() {
        return this.getBuilder().isManagedBuildOn();
    }

    @Override
    public void setManagedBuildOn(boolean on) throws BuildException {
        try {
            this.getEditableBuilder().setManagedBuildOn(on);
        }
        catch (CoreException e) {
            throw new BuildException(e.getLocalizedMessage());
        }
    }

    @Override
    public void changeBuilder(IBuilder newBuilder, String id, String name) {
        this.changeBuilder(newBuilder, id, name, false);
    }

    public void changeBuilder(IBuilder newBuilder, String id, String name, boolean allBuildSettings) {
        ToolChain tc = (ToolChain)this.getToolChain();
        Builder cur = (Builder)this.getEditableBuilder();
        Builder newCfgBuilder = null;
        if (newBuilder.getParent() == tc) {
            newCfgBuilder = (Builder)newBuilder;
        } else {
            IBuilder curReal = ManagedBuildManager.getRealBuilder(cur);
            IBuilder newReal = ManagedBuildManager.getRealBuilder(newBuilder);
            if (newReal != curReal) {
                IBuilder extBuilder = newBuilder;
                while (extBuilder != null && !extBuilder.isExtensionElement()) {
                    extBuilder = extBuilder.getSuperClass();
                }
                if (extBuilder == null) {
                    extBuilder = newBuilder;
                }
                newCfgBuilder = new Builder(tc, extBuilder, id, name, false);
                newCfgBuilder.copySettings(cur, allBuildSettings);
            }
        }
        if (newCfgBuilder != null) {
            tc.setBuilder(newCfgBuilder);
        }
    }

    @Override
    public boolean isBuilderCompatible(IBuilder builder) {
        return builder.supportsBuild(this.isManagedBuildOn());
    }

    ITool findToolById(String id) {
        IResourceInfo[] rcInfos = this.getResourceInfos();
        ITool tool = null;
        int i = 0;
        while (i < rcInfos.length) {
            ResourceInfo info = (ResourceInfo)rcInfos[i];
            tool = info.getToolById(id);
            if (tool != null) break;
            ++i;
        }
        return tool;
    }

    void resolveProjectReferences(boolean onLoad) {
        IResourceInfo[] rcInfos = this.getResourceInfos();
        int i = 0;
        while (i < rcInfos.length) {
            ResourceInfo info = (ResourceInfo)rcInfos[i];
            info.resolveProjectReferences(onLoad);
            ++i;
        }
    }

    public boolean isPerRcTypeDiscovery() {
        ToolChain tc = (ToolChain)this.getRootFolderInfo().getToolChain();
        return tc.isPerRcTypeDiscovery();
    }

    public void setPerRcTypeDiscovery(boolean on) {
        ToolChain tc = (ToolChain)this.getRootFolderInfo().getToolChain();
        tc.setPerRcTypeDiscovery(on);
    }

    public CfgDiscoveredPathManager.PathInfoCache setDiscoveredPathInfo(CfgDiscoveredPathManager.PathInfoCache info) {
        ToolChain tc = (ToolChain)this.getRootFolderInfo().getToolChain();
        return tc.setDiscoveredPathInfo(info);
    }

    public CfgDiscoveredPathManager.PathInfoCache getDiscoveredPathInfo() {
        ToolChain tc = (ToolChain)this.getRootFolderInfo().getToolChain();
        return tc.getDiscoveredPathInfo();
    }

    public String getDiscoveryProfileId() {
        ToolChain tc = (ToolChain)this.getRootFolderInfo().getToolChain();
        return tc.getScannerConfigDiscoveryProfileId();
    }

    public CfgDiscoveredPathManager.PathInfoCache clearDiscoveredPathInfo() {
        ToolChain tc = (ToolChain)this.getRootFolderInfo().getToolChain();
        return tc.clearDiscoveredPathInfo();
    }

    public ICfgScannerConfigBuilderInfo2Set getCfgScannerConfigInfo() {
        return this.cfgScannerInfo;
    }

    public void setCfgScannerConfigInfo(ICfgScannerConfigBuilderInfo2Set info) {
        this.cfgScannerInfo = info;
    }

    public void clearCachedData() {
        this.cfgScannerInfo = null;
    }

    public boolean isPreference() {
        return this.isPreferenceConfig;
    }

    @Override
    public IBuildPropertyValue getBuildArtefactType() {
        IBuildProperty prop;
        BuildObjectProperties props = this.findBuildProperties();
        if (props != null && (prop = props.getProperty("org.eclipse.cdt.build.core.buildArtefactType")) != null) {
            return prop.getValue();
        }
        return null;
    }

    @Override
    public void setBuildArtefactType(String id) throws BuildException {
        IBuildObjectProperties props = this.getBuildProperties();
        try {
            props.setProperty("org.eclipse.cdt.build.core.buildArtefactType", id);
        }
        catch (CoreException e) {
            throw new BuildException(e.getLocalizedMessage());
        }
        this.exportArtifactInfo();
    }

    boolean isExcluded(IPath path) {
        ICSourceEntry[] entries = this.getSourceEntries();
        return CDataUtil.isExcluded((IPath)path, (ICSourceEntry[])entries);
    }

    void setExcluded(IPath path, boolean isFolder, boolean excluded) {
        if (this.excludeList == null) {
            ICSourceEntry[] newEntries = this.getUpdatedEntries(path, isFolder, excluded);
            if (newEntries != null) {
                this.setSourceEntries(newEntries, false);
            }
        } else if (excluded) {
            this.excludeList.add(path);
        }
    }

    private ICSourceEntry[] getUpdatedEntries(IPath path, boolean isFolder, boolean excluded) {
        try {
            ICSourceEntry[] entries = this.getSourceEntries();
            return CDataUtil.setExcluded((IPath)path, (boolean)isFolder, (boolean)excluded, (ICSourceEntry[])entries, (boolean)false);
        }
        catch (CoreException e) {
            ManagedBuilderCorePlugin.log(e);
            return null;
        }
    }

    boolean canExclude(IPath path, boolean isFolder, boolean excluded) {
        if (this.excludeList == null) {
            ICSourceEntry[] newEntries = this.getUpdatedEntries(path, isFolder, excluded);
            return newEntries != null;
        }
        if (excluded) {
            this.excludeList.add(path);
        }
        return true;
    }

    @Override
    public IRealBuildObjectAssociation getExtensionObject() {
        return this.isExtensionConfig ? this : (Configuration)this.getParent();
    }

    @Override
    public IRealBuildObjectAssociation[] getIdenticBuildObjects() {
        return new Configuration[]{(Configuration)this.getExtensionObject()};
    }

    @Override
    public IRealBuildObjectAssociation getRealBuildObject() {
        return this.getExtensionObject();
    }

    @Override
    public IRealBuildObjectAssociation getSuperClassObject() {
        return (IRealBuildObjectAssociation)((Object)this.getParent());
    }

    @Override
    public int getType() {
        return 32;
    }

    @Override
    public boolean isRealBuildObject() {
        return this.getRealBuildObject() == this;
    }

    @Override
    public String getUniqueRealName() {
        return this.getName();
    }

    @Override
    public boolean isExtensionBuildObject() {
        return this.isExtensionElement();
    }
}

