/*
 * Decompiled with CFR 0.152.
 */
package lpg.runtime;

import lpg.runtime.ILexStream;
import lpg.runtime.IPrsStream;
import lpg.runtime.IToken;
import lpg.runtime.LexStream;
import lpg.runtime.MismatchedInputCharsException;
import lpg.runtime.UnknownStreamType;

public abstract class AbstractToken
implements IToken {
    private int kind = 0;
    private int startOffset = 0;
    private int endOffset = 0;
    private int tokenIndex = 0;
    private int adjunctIndex;
    private IPrsStream iPrsStream;

    public AbstractToken() {
    }

    public AbstractToken(IPrsStream iPrsStream, int startOffset, int endOffset, int kind) {
        this.iPrsStream = iPrsStream;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.kind = kind;
    }

    public int getKind() {
        return this.kind;
    }

    public void setKind(int kind) {
        this.kind = kind;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public void setStartOffset(int startOffset) {
        this.startOffset = startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public void setEndOffset(int endOffset) {
        this.endOffset = endOffset;
    }

    public int getTokenIndex() {
        return this.tokenIndex;
    }

    public void setTokenIndex(int tokenIndex) {
        this.tokenIndex = tokenIndex;
    }

    public void setAdjunctIndex(int adjunctIndex) {
        this.adjunctIndex = adjunctIndex;
    }

    public int getAdjunctIndex() {
        return this.adjunctIndex;
    }

    public IPrsStream getIPrsStream() {
        return this.iPrsStream;
    }

    public ILexStream getILexStream() {
        return this.iPrsStream == null ? null : this.iPrsStream.getILexStream();
    }

    public int getLine() {
        return this.iPrsStream == null ? 0 : this.iPrsStream.getILexStream().getLineNumberOfCharAt(this.startOffset);
    }

    public int getColumn() {
        return this.iPrsStream == null ? 0 : this.iPrsStream.getILexStream().getColumnOfCharAt(this.startOffset);
    }

    public int getEndLine() {
        return this.iPrsStream == null ? 0 : this.iPrsStream.getILexStream().getLineNumberOfCharAt(this.endOffset);
    }

    public int getEndColumn() {
        return this.iPrsStream == null ? 0 : this.iPrsStream.getILexStream().getColumnOfCharAt(this.endOffset);
    }

    public IPrsStream getPrsStream() {
        return this.iPrsStream;
    }

    public ILexStream getLexStream() {
        return this.iPrsStream == null ? null : this.iPrsStream.getILexStream();
    }

    public String getValue(char[] inputChars) {
        if (this.iPrsStream != null) {
            return this.toString();
        }
        if (this.iPrsStream.getLexStream() instanceof LexStream) {
            LexStream lex_stream = (LexStream)this.iPrsStream.getLexStream();
            if (inputChars != lex_stream.getInputChars()) {
                throw new MismatchedInputCharsException();
            }
            return this.toString();
        }
        throw new UnknownStreamType("Unknown stream type " + this.iPrsStream.getLexStream().getClass().toString());
    }

    public String toString() {
        return this.iPrsStream == null ? "<toString>" : this.iPrsStream.toString(this, this);
    }
}

