/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.figure.node;

import org.eclipse.draw2d.AbstractBackground;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.graphics.ColorRegistry;
import org.eclipse.papyrus.uml.diagram.common.figure.node.NodeNamedElementFigure;
import org.eclipse.papyrus.uml.diagram.common.figure.node.PapyrusSendNodeShadowBorder;
import org.eclipse.swt.graphics.Color;

public class PapyrusSendNodeFigure
extends NodeNamedElementFigure {
    public int widthArrow = 15;

    public PapyrusSendNodeFigure() {
        this.shadowborder = new PapyrusSendNodeShadowBorder(1, this.getBorderColor(), this.widthArrow);
        this.setBorder((Border)this.shadowborder);
    }

    @Override
    protected Border getDefaultBorder(Color borderColor) {
        return new PapyrusSendNodeShadowBorder(1, borderColor, this.widthArrow);
    }

    @Override
    public void paintFigure(Graphics graphics) {
        if (this.isOpaque() && this.getBorder() != null) {
            Rectangle tempRect = new Rectangle(this.getBounds());
            tempRect.crop(this.getBorder().getInsets((IFigure)this));
            graphics.fillRoundRectangle(tempRect, this.widthArrow, this.widthArrow);
            return;
        }
        if (this.isOpaque()) {
            graphics.fillRoundRectangle(this.getBounds(), this.widthArrow, this.widthArrow);
        }
        if (this.getBorder() instanceof AbstractBackground) {
            ((AbstractBackground)this.getBorder()).paintBackground((IFigure)this, graphics, NO_INSETS);
        }
        this.paintBackground(graphics, this.getBounds());
        this.shadowborder.setColor(this.getForegroundColor());
    }

    @Override
    protected void paintBackground(Graphics graphics, Rectangle rectangle) {
        PointList ptList = new PointList();
        ptList.addPoint(this.getBounds().getLocation());
        ptList.addPoint(this.getBounds().x + this.getBounds().width - this.widthArrow, this.getBounds().y);
        ptList.addPoint(this.getBounds().x + this.getBounds().width, this.getBounds().y + this.getBounds().height / 2);
        ptList.addPoint(this.getBounds().x + this.getBounds().width - this.widthArrow, this.getBounds().y + this.getBounds().height);
        ptList.addPoint(this.getBounds().getBottomLeft());
        if (this.isUsingGradient()) {
            this.applyTransparency(graphics);
            graphics.setBackgroundColor(ColorRegistry.getInstance().getColor(Integer.valueOf(this.getGradientColor1())));
            graphics.setForegroundColor(this.getForegroundColor());
            graphics.fillPolygon(ptList);
            Rectangle rect1 = new Rectangle(rectangle.getLocation(), new Dimension(this.getBounds().width - this.widthArrow, rectangle.height));
            graphics.setBackgroundColor(ColorRegistry.getInstance().getColor(Integer.valueOf(this.getGradientColor1())));
            graphics.setForegroundColor(ColorRegistry.getInstance().getColor(Integer.valueOf(this.getGradientColor2())));
            graphics.fillGradient(rect1, false);
        } else {
            graphics.setBackgroundColor(this.getBackgroundColor());
            graphics.setForegroundColor(this.getForegroundColor());
            graphics.fillPolygon(ptList);
        }
    }
}

