/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.editpolicies;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.AbstractMaskManagedEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.helper.FloatingLabelHelper;
import org.eclipse.papyrus.uml.tools.utils.ICustomAppearance;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.TypedElement;
import org.eclipse.uml2.uml.UMLPackage;

public class MaskManagedFloatingLabelEditPolicy
extends AbstractMaskManagedEditPolicy {
    @Override
    public void addAdditionalListeners() {
        super.addAdditionalListeners();
        NamedElement umlElement = this.getUMLElement();
        if (umlElement == null) {
            Activator.log.error("No semantic element present when adding listeners in FloatingLabelEditPolicy", null);
            return;
        }
        if (umlElement instanceof TypedElement && ((TypedElement)umlElement).getType() != null) {
            this.getDiagramEventBroker().addNotificationListener((EObject)((TypedElement)umlElement).getType(), (NotificationListener)this);
        }
        if (umlElement instanceof MultiplicityElement) {
            this.getDiagramEventBroker().addNotificationListener((EObject)((MultiplicityElement)umlElement).getUpperValue(), (NotificationListener)this);
            this.getDiagramEventBroker().addNotificationListener((EObject)((MultiplicityElement)umlElement).getLowerValue(), (NotificationListener)this);
        }
    }

    @Override
    public Collection<String> getDefaultDisplayValue() {
        return ICustomAppearance.DEFAULT_UML_FLOATING_LABEL;
    }

    public Map<String, String> getMasks() {
        return FloatingLabelHelper.getInstance().getMasks();
    }

    public NamedElement getUMLElement() {
        Element element = super.getUMLElement();
        if (element instanceof NamedElement) {
            return (NamedElement)element;
        }
        return null;
    }

    @Override
    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        Object object = notification.getNotifier();
        NamedElement property = this.getUMLElement();
        Object feature = notification.getFeature();
        if (object == null || property == null || feature == null) {
            return;
        }
        if (feature == UMLPackage.eINSTANCE.getLiteralInteger_Value()) {
            this.refreshDisplay();
        } else if (feature == UMLPackage.eINSTANCE.getLiteralUnlimitedNatural_Value()) {
            this.refreshDisplay();
        }
        if (object.equals(property)) {
            this.notifyNamedElementChanged(property, notification);
        }
        if (this.isMaskManagedAnnotation(object)) {
            this.refreshDisplay();
        }
        if (this.isRemovedMaskManagedLabelAnnotation(object, notification)) {
            this.refreshDisplay();
        }
    }

    protected void notifyNamedElementChanged(NamedElement namedElement, Notification notification) {
        switch (notification.getFeatureID(NamedElement.class)) {
            case 5: {
                this.refreshDisplay();
                break;
            }
            case 9: {
                this.refreshDisplay();
                break;
            }
        }
    }

    @Override
    protected View getView() {
        EditPart host = this.getHost();
        if (host == null) {
            return null;
        }
        Object hostView = host.getModel();
        if (hostView instanceof View) {
            return (View)hostView;
        }
        return null;
    }

    @Override
    public void refreshDisplay() {
        FloatingLabelHelper.getInstance().refreshEditPartDisplay((GraphicalEditPart)this.getHost());
    }

    @Override
    protected void removeAdditionalListeners() {
        super.removeAdditionalListeners();
        NamedElement umlElement = this.getUMLElement();
        if (umlElement == null) {
            return;
        }
        if (umlElement instanceof TypedElement && ((TypedElement)umlElement).getType() != null) {
            this.getDiagramEventBroker().removeNotificationListener((EObject)((TypedElement)umlElement).getType(), (NotificationListener)this);
        }
        if (umlElement instanceof MultiplicityElement) {
            this.getDiagramEventBroker().removeNotificationListener((EObject)((MultiplicityElement)umlElement).getUpperValue(), (NotificationListener)this);
            this.getDiagramEventBroker().removeNotificationListener((EObject)((MultiplicityElement)umlElement).getLowerValue(), (NotificationListener)this);
        }
    }

    @Override
    public Collection<String> getCurrentDisplayValue() {
        if (this.getView() == null) {
            return Collections.emptySet();
        }
        return super.getCurrentDisplayValue();
    }
}

