/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.xtext.ide.server.Document;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

public interface ILanguageServerAccess {
    public <T> CompletableFuture<T> doRead(String var1, Function<Context, T> var2);

    public <T> CompletableFuture<T> doReadIndex(Function<? super IndexContext, ? extends T> var1);

    public void addBuildListener(IBuildListener var1);

    default public void removeBuildListener(IBuildListener listener) {
    }

    public LanguageClient getLanguageClient();

    public ResourceSet newLiveScopeResourceSet(URI var1);

    public InitializeParams getInitializeParams();

    public InitializeResult getInitializeResult();

    public static class Context {
        private final Resource resource;
        private final Document document;
        private final boolean isDocumentOpen;
        private final CancelIndicator cancelChecker;

        public Context(Resource resource, Document document, boolean isDocumentOpen, CancelIndicator cancelChecker) {
            this.resource = resource;
            this.document = document;
            this.isDocumentOpen = isDocumentOpen;
            this.cancelChecker = cancelChecker;
        }

        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("resource", (Object)this.resource);
            b.add("document", (Object)this.document);
            b.add("isDocumentOpen", (Object)this.isDocumentOpen);
            b.add("cancelChecker", (Object)this.cancelChecker);
            return b.toString();
        }

        public Resource getResource() {
            return this.resource;
        }

        public Document getDocument() {
            return this.document;
        }

        public boolean isDocumentOpen() {
            return this.isDocumentOpen;
        }

        public CancelIndicator getCancelChecker() {
            return this.cancelChecker;
        }
    }

    public static interface IBuildListener {
        public void afterBuild(List<IResourceDescription.Delta> var1);
    }

    public static class IndexContext {
        private final IResourceDescriptions index;
        private final CancelIndicator cancelChecker;

        public IndexContext(IResourceDescriptions index, CancelIndicator cancelChecker) {
            this.index = index;
            this.cancelChecker = cancelChecker;
        }

        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("index", (Object)this.index);
            b.add("cancelChecker", (Object)this.cancelChecker);
            return b.toString();
        }

        public IResourceDescriptions getIndex() {
            return this.index;
        }

        public CancelIndicator getCancelChecker() {
            return this.cancelChecker;
        }
    }
}

