/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.typesystem.xsd.builder;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.util.XSDConstants;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.eclipse.xsd.util.XSDSchemaLocationResolver;
import org.eclipse.xsd.util.XSDSchemaLocator;
import org.eclipse.xtend.typesystem.xsd.util.Msg;
import org.eclipse.xtend.typesystem.xsd.util.XSDLog;
import org.eclipse.xtend.typesystem.xsd.util.XSDUtil;

public class XSDResolver
extends AdapterImpl
implements XSDSchemaLocationResolver,
XSDSchemaLocator {
    protected Log log = XSDLog.getLog(((Object)((Object)this)).getClass());

    private XSDSchema findSchema(ResourceSet rs, String ns) {
        for (Resource r : rs.getResources()) {
            for (EObject o : r.getContents()) {
                if (!(o instanceof XSDSchema)) continue;
                XSDSchema s = (XSDSchema)o;
                if (ns == null && s.getTargetNamespace() == null) {
                    return s;
                }
                if (ns == null || !ns.equals(s.getTargetNamespace())) continue;
                return s;
            }
        }
        return null;
    }

    public boolean isAdapterForType(Object type) {
        return type == XSDSchemaLocationResolver.class || type == XSDSchemaLocator.class;
    }

    public XSDSchema locateSchema(XSDSchema xsdSchema, String namespaceURI, String rawSchemaLocationURI, String resolvedSchemaLocationURI) {
        boolean equalNS;
        if (xsdSchema.eResource() == null || xsdSchema.eResource().getResourceSet() == null) {
            return null;
        }
        boolean bl = equalNS = xsdSchema.getTargetNamespace() != null && xsdSchema.getTargetNamespace().equals(namespaceURI);
        if (equalNS) {
            this.log.info((Object)Msg.create("Including ").uri(rawSchemaLocationURI).txt(" from ").schema(xsdSchema));
        } else {
            this.log.info((Object)Msg.create("Importing ").uri(rawSchemaLocationURI).txt(" (").ns(namespaceURI).txt(") from ").schema(xsdSchema));
        }
        ResourceSet rs = xsdSchema.eResource().getResourceSet();
        IOException loadErr = null;
        XSDSchema schema = null;
        try {
            schema = this.tryLoadSchema(resolvedSchemaLocationURI, rs);
        }
        catch (IOException exception) {
            loadErr = exception;
        }
        if (schema == null) {
            schema = this.findSchema(rs, namespaceURI);
            Msg msg = Msg.create("Could not load ").uri(rawSchemaLocationURI).txt(".");
            Msg err = Msg.create(" Error:").err(loadErr);
            if (schema != null) {
                this.log.warn((Object)msg.txt(" Taking ").schema(schema).txt(" instead, since they have the same namespace.").txt(err));
            } else {
                this.log.error((Object)msg.txt(err));
            }
        }
        if (schema != null && (schema.getTargetNamespace() == null || schema.getTargetNamespace().equals(""))) {
            this.log.warn((Object)Msg.create("XSDSchema ").uri((EObject)schema).txt(" has no namespace. Setting it to ").ns(namespaceURI));
            schema.setTargetNamespace(namespaceURI);
        }
        return schema;
    }

    public String resolveSchemaLocation(XSDSchema xsdSchema, String namespaceURI, String schemaLocationURI) {
        if (schemaLocationURI != null && !"".equals(schemaLocationURI)) {
            URI r = XSDUtil.resolve(xsdSchema.eResource(), schemaLocationURI);
            return r.toString();
        }
        return XSDConstants.resolveSchemaLocation((String)xsdSchema.getSchemaLocation(), (String)namespaceURI, (String)schemaLocationURI);
    }

    private XSDSchema tryLoadSchema(String resolvedSchemaLocationURI, ResourceSet rs) throws IOException {
        URI uri = URI.createURI((String)(resolvedSchemaLocationURI == null ? "" : resolvedSchemaLocationURI));
        Resource resolvedResource = rs.getResource(uri, false);
        if (resolvedResource == null) {
            InputStream inputStream = rs.getURIConverter().createInputStream(uri);
            resolvedResource = rs.createResource(URI.createURI((String)"*.xsd"));
            resolvedResource.setURI(uri);
            resolvedResource.load(inputStream, rs.getLoadOptions());
        } else if (!resolvedResource.isLoaded()) {
            resolvedResource.load(rs.getLoadOptions());
        }
        if (resolvedResource instanceof XSDResourceImpl) {
            return ((XSDResourceImpl)resolvedResource).getSchema();
        }
        return null;
    }
}

