/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.tools.api.refresh;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DNodeList;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramMappingsManager;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramMappingsManagerRegistry;
import org.eclipse.sirius.diagram.business.api.query.AbstractNodeMappingQuery;
import org.eclipse.sirius.diagram.business.api.query.DiagramElementMappingQuery;
import org.eclipse.sirius.diagram.business.api.query.EObjectQuery;
import org.eclipse.sirius.diagram.business.api.query.EdgeMappingQuery;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.viewpoint.DMappingBased;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;

public class BestMappingGetter {
    private Session session;
    private IInterpreter interpreter;
    private ModelAccessor modelAccessor;
    private DSemanticDiagram parentDDiagram;
    private DSemanticDecorator containerView;
    private EdgeTarget sourceView;
    private EdgeTarget targetView;
    private EObject semanticElt;

    public BestMappingGetter(DSemanticDecorator containerView, EObject semanticElt) {
        EObjectQuery eObjectQuery = new EObjectQuery((EObject)containerView);
        this.session = eObjectQuery.getSession();
        this.containerView = containerView;
        this.semanticElt = semanticElt;
        this.parentDDiagram = (DSemanticDiagram)eObjectQuery.getParentDiagram().get();
        this.interpreter = this.session.getInterpreter();
        this.modelAccessor = this.session.getModelAccessor();
    }

    public BestMappingGetter(EdgeTarget sourceView, EdgeTarget targetView, EObject semanticElt) {
        EObjectQuery eObjectQuery = new EObjectQuery((EObject)sourceView);
        this.session = eObjectQuery.getSession();
        this.sourceView = sourceView;
        this.targetView = targetView;
        this.semanticElt = semanticElt;
        this.parentDDiagram = (DSemanticDiagram)eObjectQuery.getParentDiagram().get();
        this.containerView = this.parentDDiagram;
        this.interpreter = this.session.getInterpreter();
        this.modelAccessor = this.session.getModelAccessor();
    }

    public ContainerMapping getBestContainerMapping(Collection<ContainerMapping> proposedContainerMappings) {
        ContainerMapping bestContainerMapping = null;
        List<ContainerMapping> mappingCandidates = this.getAllContainerMappingsHierarchy(proposedContainerMappings);
        if (mappingCandidates.size() > 1) {
            AbstractNodeMapping firstValidMappingCandidate = this.getFirstValidAbstractNodeMappingCandidate(mappingCandidates);
            if (firstValidMappingCandidate instanceof ContainerMapping) {
                bestContainerMapping = (ContainerMapping)firstValidMappingCandidate;
            }
        } else if (mappingCandidates.size() == 1 && this.isSemanticCandidate(new DiagramElementMappingQuery(mappingCandidates.get(0)))) {
            bestContainerMapping = mappingCandidates.get(0);
        }
        return bestContainerMapping;
    }

    public List<ContainerMapping> getAllContainerMappingsHierarchy(Collection<ContainerMapping> proposedContainerMappings) {
        ArrayList<ContainerMapping> allContainerMappingsHierarchy = new ArrayList<ContainerMapping>();
        ArrayList<ContainerMapping> mappingCandidates = new ArrayList<ContainerMapping>();
        DiagramMappingsManager diagramMappingsManager = DiagramMappingsManagerRegistry.INSTANCE.getDiagramMappingsManager(this.session, this.parentDDiagram);
        if (this.containerView instanceof DDiagramElement) {
            DDiagramElement containerViewDDiagramElt = (DDiagramElement)this.containerView;
            if (containerViewDDiagramElt instanceof DNodeContainer) {
                DNodeContainer containerViewDNodeContainer = (DNodeContainer)containerViewDDiagramElt;
                mappingCandidates.addAll(diagramMappingsManager.getContainerMappings(containerViewDNodeContainer, true));
            }
        } else {
            mappingCandidates.addAll(diagramMappingsManager.getContainerMappings());
        }
        block0: for (ContainerMapping potentialContainerMapping : mappingCandidates) {
            DiagramElementMappingQuery diagramElementMappingQuery = new DiagramElementMappingQuery(potentialContainerMapping);
            for (ContainerMapping proposedContainerMapping : proposedContainerMappings) {
                if (!diagramElementMappingQuery.areInSameHiearchy(proposedContainerMapping)) continue;
                allContainerMappingsHierarchy.add(potentialContainerMapping);
                continue block0;
            }
        }
        return allContainerMappingsHierarchy;
    }

    public NodeMapping getBestNodeMapping(Collection<NodeMapping> proposedNodeMappings) {
        NodeMapping bestNodeMapping = null;
        List<NodeMapping> mappingCandidates = this.getAllNodeMappingsHierarchy(proposedNodeMappings);
        if (mappingCandidates.size() > 1) {
            AbstractNodeMapping firstValidMappingCandidate = this.getFirstValidAbstractNodeMappingCandidate(mappingCandidates);
            if (firstValidMappingCandidate instanceof NodeMapping) {
                bestNodeMapping = (NodeMapping)firstValidMappingCandidate;
            }
        } else if (mappingCandidates.size() == 1 && this.isSemanticCandidate(new DiagramElementMappingQuery(mappingCandidates.get(0)))) {
            bestNodeMapping = mappingCandidates.get(0);
        }
        return bestNodeMapping;
    }

    public List<NodeMapping> getAllNodeMappingsHierarchy(Collection<NodeMapping> proposedNodeMappings) {
        ArrayList<NodeMapping> allNodeMappingsHierarchy = new ArrayList<NodeMapping>();
        ArrayList<NodeMapping> mappingCandidates = new ArrayList<NodeMapping>();
        DiagramMappingsManager diagramMappingsManager = DiagramMappingsManagerRegistry.INSTANCE.getDiagramMappingsManager(this.session, this.parentDDiagram);
        if (this.containerView instanceof DDiagramElement) {
            DDiagramElement containerViewDDiagramElt = (DDiagramElement)this.containerView;
            if (containerViewDDiagramElt instanceof DNodeContainer) {
                DNodeContainer containerViewDNodeContainer = (DNodeContainer)containerViewDDiagramElt;
                mappingCandidates.addAll(diagramMappingsManager.getNodeMappings(containerViewDNodeContainer, true));
            } else if (containerViewDDiagramElt instanceof DNodeList) {
                DNodeList containerViewDNodeList = (DNodeList)containerViewDDiagramElt;
                mappingCandidates.addAll(diagramMappingsManager.getNodeMappings(containerViewDNodeList, true));
            }
            if (containerViewDDiagramElt instanceof AbstractDNode) {
                AbstractDNode containerViewAbstractDNode = (AbstractDNode)containerViewDDiagramElt;
                mappingCandidates.addAll(diagramMappingsManager.getBorderedNodeMappings(containerViewAbstractDNode, true));
            }
        } else {
            mappingCandidates.addAll(diagramMappingsManager.getNodeMappings());
        }
        block0: for (NodeMapping potentialContainerMapping : mappingCandidates) {
            DiagramElementMappingQuery diagramElementMappingQuery = new DiagramElementMappingQuery(potentialContainerMapping);
            for (NodeMapping proposedNodeMapping : proposedNodeMappings) {
                if (!diagramElementMappingQuery.areInSameHiearchy(proposedNodeMapping)) continue;
                allNodeMappingsHierarchy.add(potentialContainerMapping);
                continue block0;
            }
        }
        return allNodeMappingsHierarchy;
    }

    public EdgeMapping getBestEdgeMapping(Collection<EdgeMapping> proposedEdgeMappings) {
        EdgeMapping bestEdgeMapping = null;
        List<EdgeMapping> mappingCandidates = this.getAllEdgeMappingsHierarchy(proposedEdgeMappings);
        if (mappingCandidates.size() > 1) {
            EdgeMapping firstValidEdgeMappingCandidate = this.getFirstValidEdgeMappingCandidate(mappingCandidates);
            if (firstValidEdgeMappingCandidate != null) {
                bestEdgeMapping = firstValidEdgeMappingCandidate;
            }
        } else if (mappingCandidates.size() == 1 && this.isSemanticCandidate(mappingCandidates.get(0), new EdgeMappingQuery(mappingCandidates.get(0)))) {
            bestEdgeMapping = mappingCandidates.get(0);
        }
        return bestEdgeMapping;
    }

    public List<EdgeMapping> getAllEdgeMappingsHierarchy(Collection<EdgeMapping> proposedEdgeMappings) {
        ArrayList<EdgeMapping> allEdgeMappingsHierarchy = new ArrayList<EdgeMapping>();
        DiagramMappingsManager diagramMappingsManager = DiagramMappingsManagerRegistry.INSTANCE.getDiagramMappingsManager(this.session, this.parentDDiagram);
        block0: for (EdgeMapping potentialEdgeMapping : diagramMappingsManager.getEdgeMappings()) {
            DiagramElementMappingQuery diagramElementMappingQuery = new DiagramElementMappingQuery(potentialEdgeMapping);
            for (EdgeMapping proposedEdgeMapping : proposedEdgeMappings) {
                if (!diagramElementMappingQuery.areInSameHiearchy(proposedEdgeMapping)) continue;
                allEdgeMappingsHierarchy.add(potentialEdgeMapping);
                continue block0;
            }
        }
        return allEdgeMappingsHierarchy;
    }

    private AbstractNodeMapping getFirstValidAbstractNodeMappingCandidate(List<? extends AbstractNodeMapping> mappingCandidates) {
        AbstractNodeMapping firstValidMappingCandidate = null;
        for (AbstractNodeMapping abstractNodeMapping : mappingCandidates) {
            AbstractNodeMappingQuery abstractNodeMappingQuery = new AbstractNodeMappingQuery(abstractNodeMapping);
            if (!this.isSemanticCandidate(abstractNodeMappingQuery) || !abstractNodeMappingQuery.evaluatePrecondition(this.parentDDiagram, (DragAndDropTarget)this.containerView, this.interpreter, this.semanticElt)) continue;
            firstValidMappingCandidate = abstractNodeMapping;
            break;
        }
        return firstValidMappingCandidate;
    }

    private EdgeMapping getFirstValidEdgeMappingCandidate(List<EdgeMapping> mappingCandidates) {
        EdgeMapping firstValidMappingCandidate = null;
        for (EdgeMapping mappingCandidate : mappingCandidates) {
            EdgeMappingQuery edgeMappingQuery = new EdgeMappingQuery(mappingCandidate);
            if (!edgeMappingQuery.canCreate((DMappingBased)this.sourceView, (DMappingBased)this.targetView) || !this.isSemanticCandidate(mappingCandidate, edgeMappingQuery) || !this.evaluateEdgeMappingPrecondition(this.parentDDiagram, edgeMappingQuery)) continue;
            firstValidMappingCandidate = mappingCandidate;
            break;
        }
        return firstValidMappingCandidate;
    }

    private boolean isSemanticCandidate(EdgeMapping mappingCandidate, EdgeMappingQuery edgeMappingQuery) {
        boolean candidate;
        if (mappingCandidate.isUseDomainElement()) {
            candidate = this.isSemanticCandidate(edgeMappingQuery);
        } else {
            EObject sourceSemantic = ((DSemanticDecorator)this.sourceView).getTarget();
            ArrayList<EObject> semanticCandidates = new ArrayList<EObject>();
            semanticCandidates.add(sourceSemantic);
            if (edgeMappingQuery.hasTargetFinderExpression()) {
                semanticCandidates.addAll(edgeMappingQuery.evaluateTargetFinderExpression(this.parentDDiagram, this.interpreter, sourceSemantic));
            }
            candidate = semanticCandidates.contains(this.semanticElt);
        }
        return candidate;
    }

    private boolean isSemanticCandidate(DiagramElementMappingQuery query) {
        boolean candidate = this.modelAccessor.eInstanceOf(this.semanticElt, (String)query.getDomainClass().get());
        if (candidate && query.hasCandidatesExpression()) {
            Collection<EObject> semanticCandidates = query.evaluateCandidateExpression(this.parentDDiagram, this.interpreter, (DragAndDropTarget)this.containerView);
            candidate = semanticCandidates.contains(this.semanticElt);
        }
        return candidate;
    }

    private boolean evaluateEdgeMappingPrecondition(DSemanticDiagram dDiagram, EdgeMappingQuery edgeMappingQuery) {
        boolean edgeMappingPreconditionEvaluation = edgeMappingQuery.evaluatePrecondition(dDiagram, (DragAndDropTarget)this.containerView, this.interpreter, this.semanticElt, (DSemanticDecorator)this.sourceView, (DSemanticDecorator)this.targetView);
        return edgeMappingPreconditionEvaluation;
    }
}

