/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers;

import java.util.Iterator;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jubula.client.core.model.ICategoryPO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.NodeMaker;
import org.eclipse.jubula.client.core.persistence.PMAlreadyLockedException;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.PMSaveException;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.rcp.dialogs.InputDialog;
import org.eclipse.jubula.client.ui.rcp.handlers.AbstractNewHandler;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.jubula.tools.internal.exception.ProjectDeletedException;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.handlers.HandlerUtil;

public class NewCategoryHandler
extends AbstractNewHandler {
    public Object executeImpl(ExecutionEvent event) {
        try {
            this.createNewCategory(event);
        }
        catch (PMException e) {
            PMExceptionHandler.handlePMExceptionForMasterSession(e);
        }
        catch (ProjectDeletedException projectDeletedException) {
            PMExceptionHandler.handleProjectDeletedException();
        }
        return null;
    }

    private void createNewCategory(ExecutionEvent event) throws PMSaveException, PMAlreadyLockedException, PMException, ProjectDeletedException {
        final INodePO categoryParent = this.getParentNode(event);
        HandlerUtil.getActivePart((ExecutionEvent)event);
        InputDialog dialog = new InputDialog(this.getActiveShell(), Messages.CreateNewCategoryActionCatTitle, "New category", Messages.CreateNewCategoryActionCatMessage, Messages.CreateNewCategoryActionCatLabel, Messages.CreateNewCategoryActionCatError, Messages.CreateNewCategoryActionDoubleCatName, "newCategoryDialog.gif", Messages.CreateNewCategoryActionNewCategory, false){

            @Override
            protected boolean isInputAllowed() {
                return !NewCategoryHandler.this.existCategory(categoryParent, this.getInputFieldText());
            }
        };
        dialog.setHelpAvailable(true);
        dialog.create();
        DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
        Plugin.getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.jubula.client.ua.help.dialogNewCategoryContextId");
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            this.addCreatedNode((INodePO)NodeMaker.createCategoryPO((String)dialog.getName()), event);
        }
        dialog.close();
    }

    boolean existCategory(INodePO node, String name) {
        Iterator iter = null;
        iter = node.getNodeListIterator();
        while (iter.hasNext()) {
            INodePO iterNode = (INodePO)iter.next();
            if (!(iterNode instanceof ICategoryPO) || !iterNode.getName().equals(name)) continue;
            return true;
        }
        return false;
    }
}

