/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.packs.core.jobs;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.embedcdt.internal.packs.core.Activator;
import org.eclipse.embedcdt.packs.core.IConsoleStream;
import org.eclipse.embedcdt.packs.core.Utils;
import org.eclipse.embedcdt.packs.core.data.DataManager;
import org.eclipse.embedcdt.packs.core.data.DataUtils;
import org.eclipse.embedcdt.packs.core.data.PacksStorage;
import org.eclipse.embedcdt.packs.core.tree.Leaf;
import org.eclipse.embedcdt.packs.core.tree.Node;

public class RemoveJob
extends Job {
    private static boolean fgRunning = false;
    private IConsoleStream fOut = Activator.getInstance().getConsoleOutput();
    private List<Node> fSelection;
    private IProgressMonitor fMonitor;
    private DataManager fDataManager;

    public RemoveJob(String name, List<Node> selection) {
        super(name);
        this.fSelection = selection;
        this.fDataManager = DataManager.getInstance();
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus status;
        if (fgRunning) {
            return Status.CANCEL_STATUS;
        }
        fgRunning = true;
        this.fMonitor = monitor;
        long beginTime = System.currentTimeMillis();
        this.fOut.println();
        this.fOut.println(Utils.getCurrentDateTime());
        this.fOut.println("Removing packs...");
        LinkedList<Node> packsToRemove = new LinkedList<Node>();
        for (Node node : this.fSelection) {
            if (!(node.isType("version") & node.isBooleanProperty("installed"))) continue;
            packsToRemove.add(node);
        }
        int workUnits = packsToRemove.size();
        monitor.beginTask("Remove packs", workUnits);
        LinkedList<Leaf> removedPacksList = new LinkedList<Leaf>();
        for (Node versionNode : packsToRemove) {
            if (monitor.isCanceled()) break;
            String packFullName = versionNode.getProperty("archive.name");
            monitor.subTask(packFullName);
            this.fOut.println("Remove \"" + packFullName + "\".");
            try {
                String dest = versionNode.getProperty("dest.folder");
                IPath versionFolderPath = PacksStorage.getFolderPath().append(dest);
                this.fOut.println("Recursive erase \"" + versionFolderPath + "\".");
                DataUtils.deleteFolderRecursive(versionFolderPath.toFile());
                this.fMonitor.worked(1);
                versionNode.setBooleanProperty("installed", false);
                removedPacksList.add(versionNode);
                DataUtils.reportInfo("CMSIS Pack " + packFullName + " removed.");
            }
            catch (IOException e) {
                this.fOut.println(DataUtils.reportError(e.getMessage()));
                break;
            }
        }
        int count = removedPacksList.size();
        if (count > 0) {
            this.fDataManager.notifyUpdateView("update.versions", removedPacksList);
            this.fDataManager.notifyInstallRemove();
        }
        if (monitor.isCanceled()) {
            this.fOut.println("Job cancelled.");
            status = Status.CANCEL_STATUS;
        } else {
            long endTime = System.currentTimeMillis();
            long duration = endTime - beginTime;
            if (duration == 0L) {
                duration = 1L;
            }
            if (count == 1) {
                this.fOut.println("1 pack removed.");
            } else {
                this.fOut.println(String.valueOf(count) + " packs removed.");
            }
            this.fOut.print("Remove completed in ");
            this.fOut.println(String.valueOf(duration) + "ms.");
            status = Status.OK_STATUS;
        }
        fgRunning = false;
        return status;
    }
}

