/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtjsonrpc.client.impl.ser;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwtjsonrpc.client.impl.JsonSerializer;
import com.google.gwtjsonrpc.client.impl.ResultDeserializer;
import com.google.gwtjsonrpc.client.impl.ser.ObjectSerializer;
import java.util.ArrayList;
import java.util.List;

public class ListSerializer<T>
extends JsonSerializer<List<T>>
implements ResultDeserializer<List<T>> {
    private final JsonSerializer<T> serializer;

    public ListSerializer(JsonSerializer<T> s) {
        this.serializer = s;
    }

    @Override
    public void printJson(StringBuilder sb, List<T> o) {
        sb.append('[');
        boolean first = true;
        for (T item : o) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            if (item != null) {
                this.serializer.printJson(sb, item);
                continue;
            }
            sb.append("null");
        }
        sb.append(']');
    }

    @Override
    public List<T> fromJson(Object o) {
        if (o == null) {
            return null;
        }
        JavaScriptObject jso = (JavaScriptObject)o;
        int n = ListSerializer.size(jso);
        ArrayList<T> r = new ArrayList<T>(n);
        for (int i = 0; i < n; ++i) {
            r.add(this.serializer.fromJson(ListSerializer.get(jso, i)));
        }
        return r;
    }

    @Override
    public List<T> fromResult(JavaScriptObject response) {
        JavaScriptObject result = ObjectSerializer.objectResult(response);
        return result == null ? null : this.fromJson(result);
    }

    private static final native int size(JavaScriptObject var0);

    private static final native Object get(JavaScriptObject var0, int var1);
}

