"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ESLintConfigProvider = void 0;
const path_1 = __importDefault(require("path"));
const cascading_config_array_factory_1 = require("eslint/lib/cli-engine/cascading-config-array-factory");
const ESLINTRC_SUFFIX_LIST = [
    ".eslintrc.js",
    ".eslintrc.yaml",
    ".eslintrc.yml",
    ".eslintrc.json",
    ".eslintrc",
    "package.json",
];
class ESLintConfigProvider {
    constructor({ host, directoriesToWatch }) {
        this.host = host;
        this.factory = new cascading_config_array_factory_1.CascadingConfigArrayFactory();
        directoriesToWatch.forEach(directory => {
            ESLINTRC_SUFFIX_LIST.map(suffix => path_1.default.resolve(directory, suffix)).forEach(eslintrcFilepath => {
                this.host.watchFile(eslintrcFilepath, () => this.factory.clearCache(), 50);
            });
        });
    }
    getConfigArrayForFile(fileName) {
        return this.factory.getConfigArrayForFile(fileName);
    }
    getConfigForFile(fileName) {
        return this.factory.getConfigArrayForFile(fileName).extractConfig(fileName);
    }
}
exports.ESLintConfigProvider = ESLintConfigProvider;
//# sourceMappingURL=eslint-config-provider.js.map