/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.description.helpers;

import java.net.URL;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.wb.internal.core.model.description.helpers.ILoadingContext;
import org.eclipse.wb.internal.core.model.description.resource.IDescriptionVersionsProvider;
import org.eclipse.wb.internal.core.utils.jdt.core.ProjectUtils;
import org.eclipse.wb.internal.core.utils.state.EditorState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorStateLoadingContext
implements ILoadingContext {
    private final EditorState m_state;

    public static ILoadingContext get(EditorState state) {
        String key = ILoadingContext.class.getName();
        ILoadingContext context = (ILoadingContext)state.getEditor().getGlobalValue(key);
        if (context == null) {
            context = new EditorStateLoadingContext(state);
            state.getEditor().putGlobalValue(key, context);
        }
        return context;
    }

    private EditorStateLoadingContext(EditorState state) {
        this.m_state = state;
    }

    @Override
    public String getToolkitId() {
        return this.m_state.getToolkitId();
    }

    @Override
    public URL getResource(String name) throws Exception {
        URL resource = this.m_state.getEditorLoader().getResource(name);
        if (resource != null) {
            return resource;
        }
        resource = EditorStateLoadingContext.getResource(this.m_state.getEditor().getJavaProject(), name);
        if (resource != null) {
            return resource;
        }
        return null;
    }

    @Override
    public List<IDescriptionVersionsProvider> getDescriptionVersionsProviders() {
        return this.m_state.getDescriptionVersionsProviders();
    }

    @Override
    public Object getGlobalValue(String key) {
        return this.m_state.getEditor().getGlobalValue(key);
    }

    @Override
    public void putGlobalValue(String key, Object value) {
        this.m_state.getEditor().putGlobalValue(key, value);
    }

    private static URL getResource(IJavaProject javaProject, String name) throws Exception {
        List<IFile> files = ProjectUtils.findFiles(javaProject, "wbp-meta/" + name);
        if (!files.isEmpty()) {
            IFile file = files.get(0);
            return file.getLocation().toFile().toURL();
        }
        return null;
    }
}

