/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.model.timegraph;

import org.eclipse.tracecompass.tmf.core.model.OutputElement;
import org.eclipse.tracecompass.tmf.core.model.OutputElementStyle;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphArrow;

public class TimeGraphArrow
extends OutputElement
implements ITimeGraphArrow {
    private final long fSourceId;
    private final long fDestinationId;
    private final long fStartTime;
    private final long fDuration;
    private final int fValue;

    public TimeGraphArrow(long sourceId, long destinationId, long time, long duration, int value) {
        super(null);
        this.fSourceId = sourceId;
        this.fDestinationId = destinationId;
        this.fStartTime = time;
        this.fDuration = duration;
        this.fValue = value;
    }

    public TimeGraphArrow(long sourceId, long destinationId, long time, long duration) {
        this(sourceId, destinationId, time, duration, Integer.MIN_VALUE);
    }

    public TimeGraphArrow(long sourceId, long destinationId, long time, long duration, OutputElementStyle style) {
        super(style);
        this.fSourceId = sourceId;
        this.fDestinationId = destinationId;
        this.fStartTime = time;
        this.fDuration = duration;
        this.fValue = Integer.MIN_VALUE;
    }

    @Override
    public long getSourceId() {
        return this.fSourceId;
    }

    @Override
    public long getDestinationId() {
        return this.fDestinationId;
    }

    @Override
    public long getStartTime() {
        return this.fStartTime;
    }

    @Override
    public long getDuration() {
        return this.fDuration;
    }

    @Override
    public int getValue() {
        return this.fValue;
    }

    public String toString() {
        return String.format("Arrow: sourceId:%d, destinationId:%d, time: %d, duration: %d, value: %d, style: %s", this.fSourceId, this.fDestinationId, this.fStartTime, this.fDuration, this.fValue, this.getStyle());
    }
}

