/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.framework.ui;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.libra.framework.ui.Messages;
import org.eclipse.libra.framework.ui.Trace;
import org.eclipse.libra.framework.ui.internal.TerminationDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wst.server.core.IServer;

public class FrameworkUIPlugin
extends AbstractUIPlugin {
    protected static FrameworkUIPlugin singleton;
    protected Map imageDescriptors = new HashMap();
    private static URL ICON_BASE_URL;
    private static final String URL_OBJ = "obj16/";
    public static final String PLUGIN_ID = "org.eclipse.libra.framework.ui";
    public static final String IMG_WEB_MODULE = "webModule";
    public static final String IMG_MIME_MAPPING = "mimeMapping";
    public static final String IMG_MIME_EXTENSION = "mimeExtension";
    public static final String IMG_PORT = "port";
    public static final String IMG_PROJECT_MISSING = "projectMissing";
    public static final String PREF_JDK_INSTALL_DIR = "jdkinstall";

    public FrameworkUIPlugin() {
        singleton = this;
    }

    protected ImageRegistry createImageRegistry() {
        ImageRegistry registry = new ImageRegistry();
        this.registerImage(registry, IMG_WEB_MODULE, "obj16/web_module.gif");
        this.registerImage(registry, IMG_MIME_MAPPING, "obj16/mime_mapping.gif");
        this.registerImage(registry, IMG_MIME_EXTENSION, "obj16/mime_extension.gif");
        this.registerImage(registry, IMG_PORT, "obj16/port.gif");
        this.registerImage(registry, IMG_PROJECT_MISSING, "obj16/project_missing.gif");
        return registry;
    }

    public static Image getImage(String key) {
        return FrameworkUIPlugin.getInstance().getImageRegistry().get(key);
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        try {
            FrameworkUIPlugin.getInstance().getImageRegistry();
            return (ImageDescriptor)FrameworkUIPlugin.getInstance().imageDescriptors.get(key);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static FrameworkUIPlugin getInstance() {
        return singleton;
    }

    public static void log(IStatus status) {
        FrameworkUIPlugin.getInstance().getLog().log(status);
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static void openError(final String title, final String message, final IStatus status) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                Shell shell = FrameworkUIPlugin.getShell();
                ErrorDialog.openError((Shell)shell, (String)(title != null ? title : Messages.errorDefaultDialogTitle), (String)message, (IStatus)status);
            }
        });
    }

    public static boolean queryCleanTermination(IServer server) {
        CleanTerminationRunnable tr = new CleanTerminationRunnable(server);
        Display.getDefault().syncExec((Runnable)tr);
        return tr.shouldTerminate();
    }

    public static Shell getShell() {
        return FrameworkUIPlugin.getStandardDisplay().getActiveShell();
    }

    private void registerImage(ImageRegistry registry, String key, String partialURL) {
        if (ICON_BASE_URL == null) {
            String pathSuffix = "icons/";
            ICON_BASE_URL = singleton.getBundle().getEntry(pathSuffix);
        }
        try {
            ImageDescriptor id = ImageDescriptor.createFromURL((URL)new URL(ICON_BASE_URL, partialURL));
            registry.put(key, id);
            this.imageDescriptors.put(key, id);
        }
        catch (Exception e) {
            Trace.trace((byte)1, "Error registering image", e);
        }
    }

    public static class CleanTerminationRunnable
    implements Runnable {
        IServer server;
        boolean terminate;

        CleanTerminationRunnable(IServer server) {
            this.server = server;
        }

        public void run() {
            Shell shell = FrameworkUIPlugin.getShell();
            TerminationDialog dialog = new TerminationDialog(shell, Messages.cleanTerminateRuntimeInstanceDialogTitle, NLS.bind((String)Messages.cleanTerminateRuntimeInstanceMessage, (Object)this.server.getName()));
            dialog.open();
            if (dialog.getReturnCode() == 0) {
                this.terminate = true;
            }
        }

        boolean shouldTerminate() {
            return this.terminate;
        }
    }
}

