/**
 * Copyright (c) 2020 itemis AG and others.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Zoey Prigge (itemis AG) - initial API & implementation (bug #561084)
 */
package org.eclipse.gef.dot.internal.ui.language.wizard;

import org.eclipse.gef.dot.internal.ui.language.wizard.DirectedGraph;
import org.eclipse.gef.dot.internal.ui.language.wizard.EmptyProject;
import org.eclipse.xtext.ui.wizard.template.AbstractProjectTemplate;
import org.eclipse.xtext.ui.wizard.template.IProjectTemplateProvider;

/**
 * Create a list with all project templates to be shown in the template new project wizard.
 * 
 * Each template is able to generate one or more projects. Each project can be configured such that any number of files are included.
 */
@SuppressWarnings("all")
public class DotProjectTemplateProvider implements IProjectTemplateProvider {
  @Override
  public AbstractProjectTemplate[] getProjectTemplates() {
    EmptyProject _emptyProject = new EmptyProject();
    DirectedGraph _directedGraph = new DirectedGraph();
    return new AbstractProjectTemplate[] { _emptyProject, _directedGraph };
  }
}
