/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ide.dialogs;

import java.util.concurrent.TimeUnit;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class UI {
    private static final Point TOOLTIP_DISPLACEMENT = new Point(5, 20);
    private static final int TOOLTIP_HIDE_DELAY = (int)TimeUnit.SECONDS.toMillis(20L);

    private static boolean isAnyNull(Object ... arguments) {
        Object[] objectArray = arguments;
        int n = arguments.length;
        int n2 = 0;
        while (n2 < n) {
            Object argument = objectArray[n2];
            if (argument == null) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static GridDataFactory gd() {
        return GridDataFactory.fillDefaults();
    }

    public static void gd(Control control) {
        GridDataFactory.defaultsFor((Control)control).applyTo(control);
    }

    public static GridDataFactory gdGrabHV() {
        return GridDataFactory.fillDefaults().grab(true, true);
    }

    public static GridDataFactory gdGrabH() {
        return GridDataFactory.fillDefaults().grab(true, false);
    }

    public static GridDataFactory gdGrabV() {
        return GridDataFactory.fillDefaults().grab(false, true);
    }

    public static void gdGrabH(Control control) {
        UI.gdGrabH().applyTo(control);
    }

    public static GridLayoutFactory gl() {
        return GridLayoutFactory.fillDefaults();
    }

    public static boolean isUIThread() {
        return Display.getCurrent() != null;
    }

    public static Button createCheckButton(Composite parent, String text, String toolTip) {
        Button button = new Button(parent, 32);
        button.setText(text);
        UI.calibrateToolTip(new DefaultToolTip((Control)button), toolTip);
        return button;
    }

    public static Text createLabelWithText(Composite parent, String labelText, String textMessage, String toolTip) {
        Label label = new Label(parent, 0);
        label.setText(labelText);
        UI.calibrateToolTip(new DefaultToolTip((Control)label), toolTip);
        Text text = new Text(parent, 2048);
        text.setMessage(textMessage);
        UI.calibrateToolTip(new DefaultToolTip((Control)text), toolTip);
        UI.gdGrabH().applyTo((Control)text);
        return text;
    }

    public static void calibrateToolTip(DefaultToolTip toolTip, String toolTipText) {
        toolTip.setText(toolTipText);
        toolTip.setFont(JFaceResources.getDialogFont());
        toolTip.setShift(TOOLTIP_DISPLACEMENT);
        toolTip.setHideDelay(TOOLTIP_HIDE_DELAY);
    }
}

