/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.codegen.ecore.ui.launcher;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IProgressMonitorWithBlocking;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.codegen.ecore.Generator;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.eef.codegen.ecore.main.GenModel;
import org.eclipse.emf.eef.codegen.ecore.ui.launcher.GenerateEMFCodeAction;
import org.eclipse.emf.eef.codegen.ecore.util.EEFGeneratorAdapter;
import org.eclipse.emf.eef.codegen.flow.Step;
import org.eclipse.emf.eef.codegen.flow.Workflow;

public class GenerateEMFModelCodeAction
extends GenerateEMFCodeAction {
    protected Workflow initEMFGenFlow() {
        Workflow flow = new Workflow("Generate EMF model code ", this.shell);
        for (final org.eclipse.emf.codegen.ecore.genmodel.GenModel emfGenModel : this.emfGenModels) {
            String s2 = "Generate EMF Model code for " + emfGenModel.eResource().getURI().toString();
            flow.addStep(s2, new Step("EMF MODEL"){

                public IStatus execute(IProgressMonitor monitor) {
                    IProject modelProject = GenerateEMFModelCodeAction.this.extractProject(emfGenModel.getModelProjectDirectory());
                    if (modelProject == null) {
                        return Status.OK_STATUS;
                    }
                    UniqueEList referencedProjects = new UniqueEList();
                    if (!GenerateEMFModelCodeAction.this.workspace.getRoot().exists(modelProject.getFullPath())) {
                        modelProject = Generator.createEMFProject((IPath)new Path(emfGenModel.getModelDirectory()), (IPath)modelProject.getLocation(), (List)referencedProjects, (IProgressMonitor)new SubProgressMonitor(monitor, -1), (int)(Generator.EMF_MODEL_PROJECT_STYLE | Generator.EMF_PLUGIN_PROJECT_STYLE));
                    } else if (!modelProject.isAccessible()) {
                        try {
                            modelProject.open(monitor);
                        }
                        catch (CoreException e) {
                            return new Status(4, "org.eclipse.emf.eef.codegen.ecore", e.getMessage(), (Throwable)e);
                        }
                    }
                    ArrayList args = new ArrayList();
                    File modelDirectory = modelProject.getLocation().toFile();
                    try {
                        GenModel generator = new GenModel((EObject)emfGenModel, modelDirectory, args);
                        generator.doGenerate(BasicMonitor.toMonitor((IProgressMonitorWithBlocking)new SubProgressMonitor(monitor, -1)));
                    }
                    catch (IOException e) {
                        return new Status(4, "org.eclipse.emf.eef.codegen.ecore", e.getMessage(), (Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            });
            if (emfGenModel.isCodeFormatting()) {
                String s1b = "Refreshing workspace " + emfGenModel.eResource().getURI().toString();
                flow.addStep(s1b, new Step("REFRESH"){

                    public IStatus execute(IProgressMonitor monitor) {
                        IProject modelProject = GenerateEMFModelCodeAction.this.extractProject(emfGenModel.getModelProjectDirectory());
                        if (modelProject == null) {
                            return Status.OK_STATUS;
                        }
                        try {
                            if (!modelProject.isOpen()) {
                                modelProject.open(monitor);
                            }
                            modelProject.refreshLocal(2, monitor);
                        }
                        catch (CoreException e) {
                            return new Status(4, "org.eclipse.emf.eef.codegen.ecore", e.getMessage(), (Throwable)e);
                        }
                        return Status.OK_STATUS;
                    }
                });
                String s2prime = "Formatting generated files";
                flow.addStep(s2prime, new Step(s2prime){

                    public IStatus execute(IProgressMonitor monitor) {
                        EEFGeneratorAdapter eefGen = new EEFGeneratorAdapter();
                        eefGen.generate(emfGenModel, "org.eclipse.emf.codegen.ecore.genmodel.generator.ModelProject", BasicMonitor.toMonitor((IProgressMonitorWithBlocking)new SubProgressMonitor(monitor, -1)));
                        return Status.OK_STATUS;
                    }
                });
            }
            String s3 = "Refreshing workspace " + emfGenModel.eResource().getURI().toString();
            flow.addStep(s3, new Step("REFRESH"){

                public IStatus execute(IProgressMonitor monitor) {
                    IProject modelProject = GenerateEMFModelCodeAction.this.extractProject(emfGenModel.getModelProjectDirectory());
                    if (modelProject == null) {
                        return Status.OK_STATUS;
                    }
                    try {
                        if (!modelProject.isOpen()) {
                            modelProject.open(monitor);
                        }
                        modelProject.refreshLocal(2, monitor);
                    }
                    catch (CoreException e) {
                        return new Status(4, "org.eclipse.emf.eef.codegen.ecore", e.getMessage(), (Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            });
        }
        return flow;
    }
}

