/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.apache.ode.deploy.ui.pages;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.wsdl.Binding;
import javax.xml.namespace.QName;
import org.eclipse.bpel.apache.ode.deploy.model.dd.GenerateType;
import org.eclipse.bpel.apache.ode.deploy.model.dd.ProcessType;
import org.eclipse.bpel.apache.ode.deploy.model.dd.TInvoke;
import org.eclipse.bpel.apache.ode.deploy.model.dd.TProcessEvents;
import org.eclipse.bpel.apache.ode.deploy.model.dd.TProvide;
import org.eclipse.bpel.apache.ode.deploy.model.dd.TScopeEvents;
import org.eclipse.bpel.apache.ode.deploy.model.dd.TService;
import org.eclipse.bpel.apache.ode.deploy.model.dd.ddFactory;
import org.eclipse.bpel.apache.ode.deploy.model.dd.ddPackage;
import org.eclipse.bpel.apache.ode.deploy.ui.Activator;
import org.eclipse.bpel.apache.ode.deploy.ui.editors.ODEDeployMultiPageEditor;
import org.eclipse.bpel.apache.ode.deploy.ui.messages.ODEDeployUIMessages;
import org.eclipse.bpel.apache.ode.deploy.ui.pages.ServiceCellEditor;
import org.eclipse.bpel.apache.ode.deploy.ui.util.DeployResourceSetImpl;
import org.eclipse.bpel.apache.ode.deploy.ui.util.DeployUtils;
import org.eclipse.bpel.model.Import;
import org.eclipse.bpel.model.PartnerLink;
import org.eclipse.bpel.model.PartnerLinks;
import org.eclipse.bpel.model.Process;
import org.eclipse.bpel.model.Scope;
import org.eclipse.bpel.ui.BPELUIPlugin;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.bpel.ui.util.IModelVisitor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OwnerDrawLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.wst.wsdl.Port;
import org.eclipse.wst.wsdl.Service;

public class ProcessPage
extends FormPage
implements IResourceChangeListener {
    public static final int PARTNER_LINK_COLUMN = 0;
    public static final int PORT_COLUMN = 1;
    public static final int SERVICE_COLUMN = 2;
    public static final int BINDING_COLUMN = 3;
    public static final String INSTANCE_LIFECYCLE_NAME = "instanceLifecycle";
    public static final String ACTIVITY_LIFECYCLE_NAME = "activityLifecycle";
    public static final String DATA_HANDLING_NAME = "dataHandling";
    public static final String SCOPE_HANDLING_NAME = "scopeHandling";
    public static final String CORRELATION_NAME = "correlation";
    public static final String[] PROCESS_STATUS = new String[]{"activated", "deactivated", "retired"};
    public static final int STATUS_ACTIVATED = 0;
    public static final int STATUS_DEACTIVATED = 1;
    public static final int STATUS_RETIRED = 2;
    public static final Map<String, String> eventNameById = new HashMap<String, String>();
    protected ODEDeployMultiPageEditor editor;
    protected ProcessType processType;
    protected FormToolkit toolkit;
    private EditingDomain domain;
    private TableViewer scopeTableViewer;
    private Form mainform;
    private DeployResourceSetImpl resourceSet = null;

    static {
        eventNameById.put(INSTANCE_LIFECYCLE_NAME, "Instance life cycle");
        eventNameById.put(ACTIVITY_LIFECYCLE_NAME, "Activity life cycle");
        eventNameById.put(DATA_HANDLING_NAME, "Data handling");
        eventNameById.put(SCOPE_HANDLING_NAME, "Scope handling");
        eventNameById.put(CORRELATION_NAME, "Correlation");
    }

    public ProcessPage(FormEditor editor, ProcessType pt) {
        super(editor, "ODED" + pt.getName().toString(), pt.getName().getLocalPart());
        this.processType = pt;
        this.editor = (ODEDeployMultiPageEditor)editor;
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
        this.domain = this.editor.getEditingDomain();
        this.resourceSet = new DeployResourceSetImpl();
        Process process = this.processType.getModel();
        for (Import imp : process.getImports()) {
            try {
                URI uri = URI.createURI((String)imp.getLocation());
                if (uri.isFile()) continue;
                this.resourceSet.getResource(uri, true);
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)editor.getSite().getShell(), (String)"Load Error", (String)("Unable to load the import file:\n\n\t" + imp.getLocation() + "\n\n" + "Reason: " + e.getMessage() + "\n" + "Process definitions may not be available!"));
            }
        }
    }

    protected void createFormContent(IManagedForm managedForm) {
        this.toolkit = managedForm.getToolkit();
        ScrolledForm form = managedForm.getForm();
        form.setText(MessageFormat.format("Process {0} - {1}", this.processType.getName().getLocalPart(), this.processType.getName().getNamespaceURI()));
        this.toolkit.decorateFormHeading(form.getForm());
        this.mainform = form.getForm();
        this.mainform.addMessageHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ProcessPage.this.refreshModel();
            }
        });
        form.setImage(BPELUIPlugin.INSTANCE.getImage("obj20/bpel.png"));
        RowLayout layout = new RowLayout();
        layout.wrap = false;
        layout.pack = true;
        layout.justify = false;
        layout.fill = true;
        layout.type = 512;
        layout.marginLeft = 5;
        layout.marginTop = 5;
        layout.marginRight = 5;
        layout.marginBottom = 5;
        layout.spacing = 5;
        form.getBody().setLayout((Layout)layout);
        Dialog.applyDialogFont((Control)form.getBody());
        Composite client = this.createSection(form.getBody(), "General", null, 1);
        Composite statusArea = new Composite(client, 0);
        statusArea.setLayout((Layout)new GridLayout(2, false));
        this.toolkit.createLabel(statusArea, ODEDeployUIMessages.ProcessPage_GeneralStatus_Label);
        final Combo comboStatus = new Combo(statusArea, 8);
        this.toolkit.adapt((Composite)comboStatus);
        comboStatus.setItems(PROCESS_STATUS);
        if (this.processType.isActive()) {
            comboStatus.select(0);
        } else if (this.processType.isRetired()) {
            comboStatus.select(2);
        } else {
            comboStatus.select(1);
        }
        comboStatus.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Command setActiveCommand = SetCommand.create((EditingDomain)ProcessPage.this.domain, (Object)ProcessPage.this.processType, (Object)ddPackage.eINSTANCE.getProcessType_Active(), (Object)(comboStatus.getSelectionIndex() == 0 ? 1 : 0));
                Command setRetiredCommand = SetCommand.create((EditingDomain)ProcessPage.this.domain, (Object)ProcessPage.this.processType, (Object)ddPackage.eINSTANCE.getProcessType_Retired(), (Object)(comboStatus.getSelectionIndex() == 2 ? 1 : 0));
                CompoundCommand compoundCommand = new CompoundCommand();
                compoundCommand.append(setActiveCommand);
                compoundCommand.append(setRetiredCommand);
                ProcessPage.this.domain.getCommandStack().execute((Command)compoundCommand);
            }
        });
        final Button btnRunInMemory = this.toolkit.createButton(client, ODEDeployUIMessages.ProcessPage_GeneralMemoryButton, 32);
        btnRunInMemory.setToolTipText(ODEDeployUIMessages.ProcessPage_GeneralMemoryButton_Tooltip);
        btnRunInMemory.setSelection(this.processType.isInMemory());
        btnRunInMemory.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Command setInMemoryCommand = SetCommand.create((EditingDomain)ProcessPage.this.domain, (Object)ProcessPage.this.processType, (Object)ddPackage.eINSTANCE.getProcessType_InMemory(), (Object)btnRunInMemory.getSelection());
                ProcessPage.this.domain.getCommandStack().execute(setInMemoryCommand);
            }
        });
        this.createInterfaceWidget(form.getBody(), this.processType, managedForm, "Inbound Interfaces (Services)", ODEDeployUIMessages.ProcessPage_Service_Description, true);
        this.createInterfaceWidget(form.getBody(), this.processType, managedForm, "Outbound Interfaces (Invokes)", ODEDeployUIMessages.ProcessPage_Invoke_Description, false);
        this.createProcessMonitoringSection(form.getBody());
        this.createScopeMonitoringSection(form.getBody());
        form.reflow(true);
    }

    private void createInterfaceWidget(Composite fClient, ProcessType current, IManagedForm managedForm, String title, String description, boolean isInbound) {
        String[] columnNames = new String[]{"Partner Link", "Associated Port", "Related Service", "Binding Used"};
        Section section = this.toolkit.createSection(fClient, 450);
        section.setText(title);
        section.setDescription(description);
        section.marginHeight = 5;
        Composite client = this.toolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        client.setLayout((Layout)layout);
        Table t = this.toolkit.createTable(client, 101124);
        TableColumn tc1 = new TableColumn(t, 0x1000000);
        tc1.setText(columnNames[0]);
        TableColumn tc2 = new TableColumn(t, 0x1000000);
        tc2.setText(columnNames[1]);
        TableColumn tc3 = new TableColumn(t, 0x1000000);
        tc3.setText(columnNames[2]);
        TableColumn tc4 = new TableColumn(t, 0x1000000);
        tc4.setText(columnNames[3]);
        t.setHeaderVisible(true);
        t.setLinesVisible(true);
        GridData gd = new GridData(1808);
        t.setLayoutData((Object)gd);
        this.toolkit.paintBordersFor(client);
        section.setClient((Control)client);
        SectionPart spart = new SectionPart(section);
        managedForm.addPart((IFormPart)spart);
        URI deployDescriptorURI = current.eResource().getURI();
        IFile ddFile = DeployUtils.getIFileForURI(deployDescriptorURI);
        TableViewer viewer = new TableViewer(t);
        viewer.setUseHashlookup(true);
        viewer.setColumnProperties(columnNames);
        viewer.setContentProvider((IContentProvider)new PortTypeContentProvider(isInbound));
        viewer.setLabelProvider((IBaseLabelProvider)new PortTypeLabelProvider(ddFile.getProject(), (ResourceSetImpl)this.resourceSet));
        viewer.setInput((Object)current);
        int i = 0;
        int n = t.getColumnCount();
        while (i < n) {
            t.getColumn(i).pack();
            ++i;
        }
        CellEditor[] editors = new CellEditor[columnNames.length];
        ServiceCellEditor sCellEditor = new ServiceCellEditor(t, ddFile.getProject(), (ResourceSet)this.resourceSet);
        editors[1] = sCellEditor;
        viewer.setCellEditors(editors);
        viewer.setCellModifier((ICellModifier)new InterfaceWidgetCellModifier((Viewer)viewer, columnNames));
    }

    private Composite createSection(Composite parent, String title, String desc, int numColumns) {
        Section section = null;
        if (desc != null) {
            section = this.toolkit.createSection(parent, 450);
            section.setDescription(desc);
        } else {
            section = this.toolkit.createSection(parent, 322);
        }
        section.setText(title);
        Composite client = this.toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = numColumns;
        client.setLayout((Layout)layout);
        section.setClient((Control)client);
        return client;
    }

    private void createProcessMonitoringSection(Composite parent) {
        Composite client = this.createSection(parent, "Process-level Monitoring Events", null, 2);
        Composite group = this.toolkit.createComposite(client);
        group.setLayout((Layout)new RowLayout(512));
        GridData gd = new GridData();
        gd.verticalAlignment = 1;
        gd.horizontalIndent = 5;
        group.setLayoutData((Object)gd);
        final Button btnNone = this.toolkit.createButton(group, "None", 16);
        final Button btnAll = this.toolkit.createButton(group, "All", 16);
        Button btnSelected = this.toolkit.createButton(group, "Selected", 16);
        Composite wrapper = this.toolkit.createComposite(client);
        wrapper.setLayout((Layout)new RowLayout());
        final CheckboxTableViewer ctv = CheckboxTableViewer.newCheckList((Composite)wrapper, (int)0);
        wrapper.setLayoutData((Object)gd);
        this.toolkit.paintBordersFor(wrapper);
        ctv.setContentProvider((IContentProvider)new ArrayContentProvider());
        ctv.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return eventNameById.get(element);
            }
        });
        ctv.setInput((Object)new String[]{INSTANCE_LIFECYCLE_NAME, ACTIVITY_LIFECYCLE_NAME, DATA_HANDLING_NAME, SCOPE_HANDLING_NAME, CORRELATION_NAME});
        if (this.processType.getProcessEvents() == null) {
            TProcessEvents pe = ddFactory.eINSTANCE.createTProcessEvents();
            pe.setGenerate(GenerateType.ALL);
            this.processType.setProcessEvents(pe);
        }
        if (this.processType.getProcessEvents().isSetGenerate()) {
            switch (this.processType.getProcessEvents().getGenerate()) {
                case ALL: {
                    btnAll.setSelection(true);
                    ctv.getControl().setEnabled(false);
                    break;
                }
                case NONE: {
                    btnNone.setSelection(true);
                    ctv.getControl().setEnabled(false);
                }
            }
        } else {
            btnSelected.setSelection(true);
            ctv.getControl().setEnabled(true);
        }
        SelectionAdapter sa = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (btnAll == e.getSource()) {
                    ctv.getControl().setEnabled(false);
                    Command command = SetCommand.create((EditingDomain)ProcessPage.this.domain, (Object)ProcessPage.this.processType.getProcessEvents(), (Object)ddPackage.eINSTANCE.getTProcessEvents_Generate(), (Object)GenerateType.ALL);
                    ProcessPage.this.domain.getCommandStack().execute(command);
                } else if (btnNone == e.getSource()) {
                    ctv.getControl().setEnabled(false);
                    Command command = SetCommand.create((EditingDomain)ProcessPage.this.domain, (Object)ProcessPage.this.processType.getProcessEvents(), (Object)ddPackage.eINSTANCE.getTProcessEvents_Generate(), (Object)GenerateType.NONE);
                    ProcessPage.this.domain.getCommandStack().execute(command);
                } else {
                    ctv.getControl().setEnabled(true);
                    Command command = SetCommand.create((EditingDomain)ProcessPage.this.domain, (Object)ProcessPage.this.processType.getProcessEvents(), (Object)ddPackage.eINSTANCE.getTProcessEvents_Generate(), (Object)SetCommand.UNSET_VALUE);
                    ProcessPage.this.domain.getCommandStack().execute(command);
                }
            }
        };
        btnAll.addSelectionListener((SelectionListener)sa);
        btnNone.addSelectionListener((SelectionListener)sa);
        btnSelected.addSelectionListener((SelectionListener)sa);
        ctv.setCheckedElements(this.processType.getProcessEvents().getEnableEvent().toArray());
        ISelectionChangedListener scl = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Command command = SetCommand.create((EditingDomain)ProcessPage.this.domain, (Object)ProcessPage.this.processType.getProcessEvents(), (Object)ddPackage.eINSTANCE.getTEnableEventList_EnableEvent(), Arrays.asList(ctv.getCheckedElements()));
                ProcessPage.this.domain.getCommandStack().execute(command);
            }
        };
        ctv.addSelectionChangedListener(scl);
    }

    private void createScopeMonitoringSection(Composite parent) {
        String[] columns;
        Composite client = this.createSection(parent, "Scope-level Monitoring Events", null, 1);
        this.scopeTableViewer = new TableViewer(this.toolkit.createTable(client, 101124));
        Table table = this.scopeTableViewer.getTable();
        this.scopeTableViewer.setContentProvider((IContentProvider)new ScopeMonitoringEventContentProvider());
        this.scopeTableViewer.setUseHashlookup(true);
        TableViewerColumn column = new TableViewerColumn(this.scopeTableViewer, 0);
        column.getColumn().setText("Scope");
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((Scope)element).getName();
            }

            public Image getImage(Object element) {
                return BPELUIPlugin.INSTANCE.getImage("obj16/scope.gif");
            }
        });
        String[] stringArray = columns = new String[]{INSTANCE_LIFECYCLE_NAME, ACTIVITY_LIFECYCLE_NAME, DATA_HANDLING_NAME, SCOPE_HANDLING_NAME, CORRELATION_NAME};
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            String columnId = stringArray[n2];
            column = new TableViewerColumn(this.scopeTableViewer, 0);
            column.getColumn().setText(eventNameById.get(columnId));
            column.setLabelProvider((CellLabelProvider)new ScopeEventCheckboxColumnLabelProvider(columnId));
            column.setEditingSupport((EditingSupport)new ScopeEventEditingSupport(this.scopeTableViewer, columnId));
            ++n2;
        }
        OwnerDrawLabelProvider.setUpOwnerDraw((ColumnViewer)this.scopeTableViewer);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.scopeTableViewer.setInput((Object)this.processType);
        int i = 0;
        int n3 = table.getColumnCount();
        while (i < n3) {
            table.getColumn(i).pack();
            ++i;
        }
    }

    protected void refreshModel() {
        try {
            this.editor.populateModel();
            this.scopeTableViewer.refresh();
            this.mainform.setMessage(null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDeltaVisitor rdv = new IResourceDeltaVisitor(){

            public boolean visit(IResourceDelta delta) {
                IResource res = delta.getResource();
                if (DeployUtils.isBPELFile(res)) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            ProcessPage.this.mainform.setMessage(ODEDeployUIMessages.ProcessPage_UpdateWarning_Message, 2);
                        }
                    });
                } else {
                    IFile editorFile = ((IFileEditorInput)ProcessPage.this.getEditorInput()).getFile();
                    IResource target = delta.getResource();
                    if (delta.getKind() == 2 && target instanceof IFile && editorFile.equals((Object)target)) {
                        Display display = ProcessPage.this.getSite().getShell().getDisplay();
                        display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                ProcessPage.this.getSite().getPage().closeEditor((IEditorPart)(this).ProcessPage.this.editor, false);
                            }
                        });
                    }
                }
                return true;
            }
        };
        try {
            event.getDelta().accept(rdv);
        }
        catch (CoreException coreException) {}
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    class InterfaceWidgetCellModifier
    implements ICellModifier {
        private Viewer viewer;
        private String[] columnNames;

        public InterfaceWidgetCellModifier(Viewer viewer, String[] columnNames) {
            this.viewer = viewer;
            this.columnNames = columnNames;
        }

        public boolean canModify(Object element, String property) {
            return property.equals(this.columnNames[1]);
        }

        public Object getValue(Object element, String property) {
            if (!property.equals(this.columnNames[1])) {
                return null;
            }
            if (element instanceof TProvide) {
                TProvide provide = (TProvide)element;
                return provide.getService();
            }
            if (element instanceof TInvoke) {
                TInvoke invoke = (TInvoke)element;
                return invoke.getService();
            }
            return null;
        }

        public void modify(Object element, String property, Object value) {
            assert (element instanceof Item);
            if (!property.equals(this.columnNames[1])) {
                return;
            }
            Item item = (Item)element;
            Object o = item.getData();
            if (o instanceof TProvide) {
                TProvide provide = (TProvide)o;
                TService service = provide.getService();
                if (service == null) {
                    service = ddFactory.eINSTANCE.createTService();
                    provide.setService(service);
                }
                if (value == null) {
                    Command unsetServiceCommand = SetCommand.create((EditingDomain)ProcessPage.this.domain, (Object)service, (Object)ddPackage.eINSTANCE.getTService_Name(), (Object)SetCommand.UNSET_VALUE);
                    Command unsetPortCommand = SetCommand.create((EditingDomain)ProcessPage.this.domain, (Object)service, (Object)ddPackage.eINSTANCE.getTService_Port(), (Object)SetCommand.UNSET_VALUE);
                    CompoundCommand compoundCommand = new CompoundCommand();
                    compoundCommand.append(unsetServiceCommand);
                    compoundCommand.append(unsetPortCommand);
                    ProcessPage.this.domain.getCommandStack().execute((Command)compoundCommand);
                } else {
                    Port port = (Port)value;
                    String portName = port.getName();
                    Command setPortCommand = SetCommand.create((EditingDomain)ProcessPage.this.domain, (Object)service, (Object)ddPackage.eINSTANCE.getTService_Port(), (Object)portName);
                    Service wsdlService = (Service)port.eContainer();
                    QName qname = wsdlService.getQName();
                    Command setServiceCommand = SetCommand.create((EditingDomain)ProcessPage.this.domain, (Object)service, (Object)ddPackage.eINSTANCE.getTService_Name(), (Object)qname);
                    CompoundCommand compoundCommand = new CompoundCommand();
                    compoundCommand.append(setServiceCommand);
                    compoundCommand.append(setPortCommand);
                    ProcessPage.this.domain.getCommandStack().execute((Command)compoundCommand);
                }
            } else if (o instanceof TInvoke) {
                TInvoke invoke = (TInvoke)o;
                TService service = invoke.getService();
                if (service == null) {
                    service = ddFactory.eINSTANCE.createTService();
                    invoke.setService(service);
                }
                if (value == null) {
                    Command unsetServiceCommand = SetCommand.create((EditingDomain)ProcessPage.this.domain, (Object)service, (Object)ddPackage.eINSTANCE.getTService_Name(), (Object)SetCommand.UNSET_VALUE);
                    Command unsetPortCommand = SetCommand.create((EditingDomain)ProcessPage.this.domain, (Object)service, (Object)ddPackage.eINSTANCE.getTService_Port(), (Object)SetCommand.UNSET_VALUE);
                    CompoundCommand compoundCommand = new CompoundCommand();
                    compoundCommand.append(unsetServiceCommand);
                    compoundCommand.append(unsetPortCommand);
                    ProcessPage.this.domain.getCommandStack().execute((Command)compoundCommand);
                } else {
                    Port port = (Port)value;
                    String portName = port.getName();
                    Command setPortCommand = SetCommand.create((EditingDomain)ProcessPage.this.domain, (Object)service, (Object)ddPackage.eINSTANCE.getTService_Port(), (Object)portName);
                    Service wsdlService = (Service)port.eContainer();
                    QName qname = wsdlService.getQName();
                    Command setServiceCommand = SetCommand.create((EditingDomain)ProcessPage.this.domain, (Object)service, (Object)ddPackage.eINSTANCE.getTService_Name(), (Object)qname);
                    CompoundCommand compoundCommand = new CompoundCommand();
                    compoundCommand.append(setServiceCommand);
                    compoundCommand.append(setPortCommand);
                    ProcessPage.this.domain.getCommandStack().execute((Command)compoundCommand);
                }
            }
            this.viewer.refresh();
        }
    }

    class PortTypeContentProvider
    implements IStructuredContentProvider {
        protected boolean forInbound = false;

        public PortTypeContentProvider(boolean bForInbound) {
            this.forInbound = bForInbound;
        }

        public Object[] getElements(Object inputElement) {
            try {
                if (inputElement instanceof ProcessType) {
                    Process process;
                    PartnerLinks pls;
                    ProcessType type = (ProcessType)inputElement;
                    if (this.forInbound) {
                        EList provide = type.getProvide();
                        if (provide.isEmpty()) {
                            Process process2 = type.getModel();
                            PartnerLinks pls2 = process2.getPartnerLinks();
                            EList plList = pls2.getChildren();
                            for (PartnerLink current : plList) {
                                if (current.getMyRole() == null) continue;
                                TProvide currentProvide = ddFactory.eINSTANCE.createTProvide();
                                currentProvide.setPartnerLink(current.getName());
                                provide.add((Object)currentProvide);
                            }
                        }
                        return provide.toArray();
                    }
                    EList invoke = type.getInvoke();
                    if (invoke.isEmpty() && (pls = (process = type.getModel()).getPartnerLinks()) != null) {
                        EList plList = pls.getChildren();
                        for (PartnerLink current : plList) {
                            if (current.getPartnerRole() == null) continue;
                            TInvoke currentInvoke = ddFactory.eINSTANCE.createTInvoke();
                            currentInvoke.setPartnerLink(current.getName());
                            invoke.add((Object)currentInvoke);
                        }
                    }
                    return invoke.toArray();
                }
            }
            catch (NullPointerException nullPointerException) {}
            return new TInvoke[]{ddFactory.eINSTANCE.createTInvoke()};
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class PortTypeLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected IProject bpelProject = null;
        protected ResourceSetImpl resourceSet = null;

        public PortTypeLabelProvider(IProject bpelProject, ResourceSetImpl resourceSet) {
            this.bpelProject = bpelProject;
            this.resourceSet = resourceSet != null ? resourceSet : new ResourceSetImpl();
        }

        public String getColumnText(Object obj, int index) {
            Binding binding;
            QName bindingQName;
            Port port;
            String portName;
            QName serviceQName;
            TService service;
            TProvide current;
            if (obj instanceof TProvide && index == 0) {
                TProvide current2 = (TProvide)obj;
                return current2.getPartnerLink();
            }
            if (obj instanceof TProvide && index == 2) {
                current = (TProvide)obj;
                service = current.getService();
                if (service != null && (serviceQName = service.getName()) != null) {
                    return serviceQName.toString();
                }
            } else if (obj instanceof TProvide && index == 1) {
                current = (TProvide)obj;
                service = current.getService();
                if (service != null && (portName = service.getPort()) != null) {
                    return portName;
                }
            } else if (obj instanceof TProvide && index == 3 && (service = (current = (TProvide)obj).getService()) != null && (portName = service.getPort()) != null && (port = DeployUtils.findPortByName(portName, this.bpelProject, (ResourceSet)this.resourceSet)) != null && (bindingQName = (binding = port.getBinding()).getQName()) != null) {
                return bindingQName.getLocalPart();
            }
            if (obj instanceof TInvoke && index == 0) {
                current = (TInvoke)obj;
                return current.getPartnerLink();
            }
            if (obj instanceof TInvoke && index == 2) {
                current = (TInvoke)obj;
                service = current.getService();
                if (service != null && (serviceQName = service.getName()) != null) {
                    return serviceQName.toString();
                }
            } else if (obj instanceof TInvoke && index == 1) {
                current = (TInvoke)obj;
                service = current.getService();
                if (service != null && (portName = service.getPort()) != null) {
                    return portName;
                }
            } else if (obj instanceof TInvoke && index == 3 && (service = (current = (TInvoke)obj).getService()) != null && (portName = service.getPort()) != null && (port = DeployUtils.findPortByName(portName, this.bpelProject, (ResourceSet)this.resourceSet)) != null && (bindingQName = (binding = port.getBinding()).getQName()) != null) {
                return bindingQName.getLocalPart();
            }
            return "-- none -- ";
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }
    }

    class ScopeEventCheckboxColumnLabelProvider
    extends OwnerDrawLabelProvider {
        private String eventType;

        public ScopeEventCheckboxColumnLabelProvider(String eventType) {
            this.eventType = eventType;
        }

        protected void measure(Event event, Object element) {
            Image img = this.getImage(element);
            event.setBounds(new Rectangle(event.x, event.y, img.getBounds().width, img.getBounds().height));
        }

        protected void paint(Event event, Object element) {
            Image img = this.getImage(element);
            if (img != null) {
                Rectangle bounds = ((TableItem)event.item).getBounds(event.index);
                Rectangle imgBounds = img.getBounds();
                bounds.width /= 2;
                bounds.width -= imgBounds.width / 2;
                bounds.height /= 2;
                bounds.height -= imgBounds.height / 2;
                int x = bounds.width > 0 ? bounds.x + bounds.width : bounds.x;
                int y = bounds.height > 0 ? bounds.y + bounds.height : bounds.y;
                event.gc.drawImage(img, x, y);
            }
        }

        public Image getImage(Object element) {
            if (this.isChecked(element)) {
                return Activator.getDefault().getImageRegistry().get("checked");
            }
            return Activator.getDefault().getImageRegistry().get("unchecked");
        }

        public boolean isChecked(Object element) {
            String scName = ((Scope)element).getName();
            for (TScopeEvents se : ProcessPage.this.processType.getProcessEvents().getScopeEvents()) {
                if (!se.getName().equals(scName) || !se.getEnableEvent().contains((Object)this.eventType)) continue;
                return true;
            }
            return false;
        }
    }

    class ScopeEventEditingSupport
    extends EditingSupport {
        private String eventType;
        private CheckboxCellEditor checkboxCellEditor;

        public ScopeEventEditingSupport(TableViewer viewer, String eventType) {
            super((ColumnViewer)viewer);
            this.eventType = eventType;
            this.checkboxCellEditor = new CheckboxCellEditor((Composite)viewer.getTable());
        }

        protected boolean canEdit(Object element) {
            String scName = ((Scope)element).getName();
            return scName != null && !"".equals(scName);
        }

        protected CellEditor getCellEditor(Object element) {
            return this.checkboxCellEditor;
        }

        protected Object getValue(Object element) {
            String scName = ((Scope)element).getName();
            for (TScopeEvents se : ProcessPage.this.processType.getProcessEvents().getScopeEvents()) {
                if (!scName.equals(se.getName()) || !se.getEnableEvent().contains((Object)this.eventType)) continue;
                return true;
            }
            return false;
        }

        protected void setValue(Object element, Object value) {
            Command command;
            String scName = ((Scope)element).getName();
            TScopeEvents match = null;
            for (TScopeEvents se : ProcessPage.this.processType.getProcessEvents().getScopeEvents()) {
                if (!scName.equals(se.getName())) continue;
                match = se;
                break;
            }
            if (match == null) {
                match = ddFactory.eINSTANCE.createTScopeEvents();
                match.setName(scName);
                ProcessPage.this.processType.getProcessEvents().getScopeEvents().add((Object)match);
            }
            if (((Boolean)value).booleanValue()) {
                if (!match.getEnableEvent().contains((Object)this.eventType)) {
                    command = AddCommand.create((EditingDomain)ProcessPage.this.domain, (Object)match, (Object)ddPackage.eINSTANCE.getTEnableEventList_EnableEvent(), (Object)this.eventType);
                    ProcessPage.this.domain.getCommandStack().execute(command);
                }
            } else {
                command = RemoveCommand.create((EditingDomain)ProcessPage.this.domain, (Object)match, (Object)ddPackage.eINSTANCE.getTEnableEventList_EnableEvent(), (Object)this.eventType);
                ProcessPage.this.domain.getCommandStack().execute(command);
            }
            this.getViewer().refresh();
        }
    }

    class ScopeMonitoringEventContentProvider
    implements IStructuredContentProvider {
        ScopeMonitoringEventContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            final ArrayList scopes = new ArrayList();
            BPELUtil.visitModelDepthFirst((Object)ProcessPage.this.processType.getModel(), (IModelVisitor)new IModelVisitor(){

                public boolean visit(Object modelObject) {
                    if (modelObject instanceof Scope && ((Scope)modelObject).getName() != null) {
                        scopes.add(modelObject);
                    }
                    return true;
                }
            });
            return scopes.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

