/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.shared.ui.core.properties;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.xtend.shared.ui.Activator;
import org.eclipse.xtend.shared.ui.Messages;
import org.eclipse.xtend.shared.ui.core.IXtendXpandProject;
import org.eclipse.xtend.shared.ui.core.internal.preferences.AbstractPreferencePage;
import org.eclipse.xtend.shared.ui.core.metamodel.Contributor;
import org.eclipse.xtend.shared.ui.core.metamodel.MetamodelContributorRegistry;
import org.eclipse.xtend.shared.ui.internal.XtendLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetamodelContributorsPropertyAndPreferencePage
extends AbstractPreferencePage {
    private Button downButton;
    private Button upButton;
    private CheckboxTableViewer checkboxTableViewer;
    private IPreferenceStore prefStore;
    private List<Contributor> availableMetamodelContributors;
    private Table table;

    private List<Contributor> getMetamodelContributors(boolean includeDisabled) {
        Map<String, Contributor> availableMetamodelContributors = MetamodelContributorRegistry.getRegisteredMetamodelContributors();
        this.prefStore = this.getPreferenceStore();
        MetamodelContributorsPropertyAndPreferencePage.fixMetamodelContributorPreferences(this.prefStore);
        String rawString = this.prefStore.getString("metamodelContributor");
        ArrayList<Contributor> result = new ArrayList<Contributor>();
        if (this.isNotEmpty(rawString)) {
            String[] selected;
            String[] stringArray = selected = rawString.split(",");
            int n = selected.length;
            int n2 = 0;
            while (n2 < n) {
                String metaModelContributorClassName = stringArray[n2];
                Contributor contributor = availableMetamodelContributors.get(metaModelContributorClassName);
                if (contributor != null) {
                    result.add(contributor);
                }
                ++n2;
            }
        }
        if (includeDisabled) {
            for (Contributor contributor : availableMetamodelContributors.values()) {
                if (result.contains(contributor)) continue;
                result.add(contributor);
            }
        }
        return result;
    }

    private static void fixMetamodelContributorPreferences(IPreferenceStore prefStore) {
        String metamodelContr = prefStore.getString("metamodelContributor");
        if (metamodelContr.indexOf("openarchitecturware") > 0) {
            metamodelContr = metamodelContr.replace("openarchitecturware", "openarchitectureware");
            prefStore.setValue("metamodelContributor", metamodelContr);
        }
    }

    private boolean isNotEmpty(String rawString) {
        return rawString != null && !rawString.equals("");
    }

    private void updateButtonStates() {
        int index = this.table.getSelectionIndex();
        if (index == 0) {
            this.upButton.setEnabled(false);
        } else {
            this.upButton.setEnabled(true);
        }
        if (index >= this.checkboxTableViewer.getTable().getItemCount() - 1) {
            this.downButton.setEnabled(false);
        } else {
            this.downButton.setEnabled(true);
        }
    }

    protected Control createPreferenceContent(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginWidth = 0;
        container.setLayout((Layout)gridLayout);
        Label activatedMetamodelContributorsLabel = new Label(container, 0);
        activatedMetamodelContributorsLabel.setText(Messages.MetamodelContributorsPropertyAndPreferencePage_ContributorsLabel);
        new Label(container, 0);
        this.checkboxTableViewer = CheckboxTableViewer.newCheckList((Composite)container, (int)2048);
        this.checkboxTableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.checkboxTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.table = this.checkboxTableViewer.getTable();
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MetamodelContributorsPropertyAndPreferencePage.this.updateButtonStates();
            }
        });
        this.table.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite composite = new Composite(container, 0);
        composite.setLayoutData((Object)new GridData(0x1000000, 128, false, false));
        GridLayout gridLayout_1 = new GridLayout();
        composite.setLayout((Layout)gridLayout_1);
        this.upButton = new Button(composite, 0);
        this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection structuredSelection;
                Object firstElement;
                ISelection selection = MetamodelContributorsPropertyAndPreferencePage.this.checkboxTableViewer.getSelection();
                if (selection instanceof IStructuredSelection && (firstElement = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof Contributor) {
                    Contributor contributor = (Contributor)firstElement;
                    int index = MetamodelContributorsPropertyAndPreferencePage.this.availableMetamodelContributors.indexOf(contributor);
                    MetamodelContributorsPropertyAndPreferencePage.this.availableMetamodelContributors.remove(contributor);
                    MetamodelContributorsPropertyAndPreferencePage.this.availableMetamodelContributors.add(index - 1, contributor);
                    MetamodelContributorsPropertyAndPreferencePage.this.checkboxTableViewer.refresh();
                }
                MetamodelContributorsPropertyAndPreferencePage.this.updateButtonStates();
            }
        });
        GridData gridData_1 = new GridData(4, 0x1000000, false, false);
        gridData_1.widthHint = 75;
        this.upButton.setLayoutData((Object)gridData_1);
        this.upButton.setText(Messages.MetamodelContributorsPropertyAndPreferencePage_UpButton);
        this.downButton = new Button(composite, 0);
        this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection structuredSelection;
                Object firstElement;
                ISelection selection = MetamodelContributorsPropertyAndPreferencePage.this.checkboxTableViewer.getSelection();
                if (selection instanceof IStructuredSelection && (firstElement = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof Contributor) {
                    Contributor contributor = (Contributor)firstElement;
                    int index = MetamodelContributorsPropertyAndPreferencePage.this.availableMetamodelContributors.indexOf(contributor);
                    MetamodelContributorsPropertyAndPreferencePage.this.availableMetamodelContributors.remove(contributor);
                    MetamodelContributorsPropertyAndPreferencePage.this.availableMetamodelContributors.add(index + 1, contributor);
                    MetamodelContributorsPropertyAndPreferencePage.this.checkboxTableViewer.refresh();
                }
                MetamodelContributorsPropertyAndPreferencePage.this.updateButtonStates();
            }
        });
        GridData gridData = new GridData(4, 0x1000000, false, false);
        gridData.widthHint = 75;
        this.downButton.setLayoutData((Object)gridData);
        this.downButton.setText(Messages.MetamodelContributorsPropertyAndPreferencePage_DownButton);
        this.setupData();
        return container;
    }

    private void setupData() {
        this.availableMetamodelContributors = this.getMetamodelContributors(true);
        this.checkboxTableViewer.setInput(this.availableMetamodelContributors);
        List<Contributor> enabledMetamodelContributors = this.getMetamodelContributors(false);
        this.checkboxTableViewer.setCheckedElements(enabledMetamodelContributors.toArray());
    }

    @Override
    public boolean performOk() {
        this.prefStore.setValue("metamodelContributor", MetamodelContributorsPropertyAndPreferencePage.createStoreString(this.checkboxTableViewer.getCheckedElements()));
        if (this.isProjectPreferencePage()) {
            final IProject project = this.getProject();
            Job job = new Job(String.valueOf(Messages.MetamodelContributorsPropertyAndPreferencePage_Analyzing) + project.getName() + " ..."){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        new WorkspaceModifyOperation(){

                            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                                IXtendXpandProject p = Activator.getExtXptModelManager().findProject((IResource)project);
                                if (p != null) {
                                    monitor.beginTask("...", p.getRegisteredResources().length);
                                    p.analyze(monitor, Activator.getExecutionContext(p.getProject()));
                                    monitor.done();
                                }
                            }
                        }.run(monitor);
                    }
                    catch (InvocationTargetException e) {
                        XtendLog.logError(e);
                    }
                    catch (InterruptedException e) {
                        XtendLog.logError(e);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        } else {
            Job job = new Job(Messages.MetamodelContributorsPropertyAndPreferencePage_JobName){

                protected IStatus run(IProgressMonitor monitor) {
                    Activator.getExtXptModelManager().analyze(monitor);
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
        return super.performOk();
    }

    public static String createStoreString(Object[] checkedElements) {
        String result = "";
        int i = 0;
        while (i < checkedElements.length) {
            Object object = checkedElements[i];
            if (object instanceof Contributor) {
                Contributor contributor = (Contributor)object;
                String className = contributor.getClassName();
                result = String.valueOf(result) + className;
            }
            if (i < checkedElements.length - 1) {
                result = String.valueOf(result) + Messages.MetamodelContributorsPropertyAndPreferencePage_19;
            }
            ++i;
        }
        return result;
    }

    protected String getPreferencePageID() {
        return "org.eclipse.xtend.shared.ui.properties.MetamodelContributorsPropertyPage";
    }

    protected String getPropertyPageID() {
        return "org.eclipse.xtend.shared.ui.properties.MetamodelContributorsPropertyPage";
    }

    @Override
    protected String[] getKeys() {
        return new String[]{"metamodelContributor"};
    }

    class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TableLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof Contributor) {
                Contributor contributor = (Contributor)element;
                return contributor.getDisplayName();
            }
            return element.toString();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }
}

