/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.shared.ui.core.metamodel.jdt.oaw;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.internal.xtend.util.Cache;
import org.eclipse.internal.xtend.util.StringHelper;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.xtend.shared.ui.core.metamodel.jdt.JdtTypeStrategy;
import org.eclipse.xtend.shared.ui.internal.XtendLog;

public class JdtOawClassicTypeStrategy
implements JdtTypeStrategy {
    private final Cache<IType, ITypeHierarchy> cache = new Cache<IType, ITypeHierarchy>(){

        protected ITypeHierarchy createNew(IType type) {
            try {
                return type.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
            }
            catch (JavaModelException e) {
                XtendLog.logError(e);
                return null;
            }
        }
    };

    public IType[] getSuperTypes(IType type) throws JavaModelException {
        ITypeHierarchy hier = type.newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor());
        IType[] ifs = hier.getSuperInterfaces(type);
        IType st = hier.getSuperclass(type);
        if (st == null) {
            return ifs;
        }
        IType[] result = new IType[ifs.length + 1];
        System.arraycopy(ifs, 0, result, 0, ifs.length);
        result[ifs.length] = st;
        return result;
    }

    public boolean isAssignable(IType toAssigTo, IType assignable) {
        return ((ITypeHierarchy)this.cache.get((Object)assignable)).contains(toAssigTo);
    }

    public boolean isGetter(IMethod method) {
        int flags;
        try {
            flags = method.getFlags();
        }
        catch (JavaModelException e) {
            return false;
        }
        try {
            if (!Flags.isStatic((int)flags) && method.getParameterTypes().length == 0 && !"V".equals(method.getReturnType())) {
                return true;
            }
        }
        catch (JavaModelException e) {
            XtendLog.logError(e);
        }
        return false;
    }

    public String getterToProperty(String elementName) {
        return elementName;
    }

    public boolean isOperation(IMethod method) {
        if (!this.isGetter(method)) {
            try {
                int flags = method.getFlags();
                if (!Flags.isStatic((int)flags) && !method.getElementName().startsWith("set")) {
                    return true;
                }
            }
            catch (JavaModelException e) {
                return false;
            }
        }
        return false;
    }

    public String propertyName(IMethod method) {
        return this.getterToProperty(method.getElementName());
    }

    public String getPropertiesInnerType(IMethod method) {
        IType type = method.getDeclaringType();
        IMethod[] methods = null;
        String adderMethod = "add" + StringHelper.firstUpper((String)method.getElementName());
        try {
            methods = type.getMethods();
            int i = 0;
            while (i < methods.length) {
                IMethod m = methods[i];
                if (m.getParameterTypes().length == 1 && m.getElementName().equals(adderMethod)) {
                    return m.getParameterTypes()[0];
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            XtendLog.logError(e);
        }
        return null;
    }

    public boolean isConstant(IField field) {
        try {
            return field.isEnumConstant() || field.getDeclaringType().isInterface() || Flags.isPublic((int)field.getFlags()) && Flags.isFinal((int)field.getFlags()) && Flags.isStatic((int)field.getFlags());
        }
        catch (JavaModelException e) {
            return false;
        }
    }

    public String propertyName(IField field) {
        return field.getElementName();
    }
}

