/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.util;

import org.eclipse.wst.css.core.internal.document.CSSSelectorListImpl;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSSelector;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSSelectorItem;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSSelectorList;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSSimpleSelector;

public class SelectorValidator {
    private String fText = null;
    private ICSSSelectorList fSelectorList = null;

    public SelectorValidator(String text) {
        this.fText = text;
    }

    public boolean isClass() {
        ICSSSimpleSelector selector = this.getOnlyOneSimpleSelector();
        if (selector != null) {
            return selector.getName().length() == 0 && selector.getNumOfAttributes() == 0 && selector.getNumOfClasses() == 1 && selector.getNumOfIDs() == 0 && selector.getNumOfPseudoNames() == 0;
        }
        return false;
    }

    public boolean isID() {
        ICSSSimpleSelector selector = this.getOnlyOneSimpleSelector();
        if (selector != null) {
            return selector.getName().length() == 0 && selector.getNumOfAttributes() == 0 && selector.getNumOfClasses() == 0 && selector.getNumOfIDs() == 1 && selector.getNumOfPseudoNames() == 0;
        }
        return false;
    }

    public boolean isValid() {
        this.parse();
        return this.fSelectorList != null && this.fSelectorList.getErrorCount() == 0;
    }

    private ICSSSimpleSelector getOnlyOneSimpleSelector() {
        ICSSSelectorItem item;
        ICSSSelector selector;
        int nItem;
        this.parse();
        if (this.fSelectorList != null && this.fSelectorList.getLength() == 1 && (nItem = (selector = this.fSelectorList.getSelector(0)).getLength()) == 1 && (item = selector.getItem(0)) instanceof ICSSSimpleSelector) {
            return (ICSSSimpleSelector)item;
        }
        return null;
    }

    private void parse() {
        if (this.fSelectorList == null && this.fText != null) {
            this.fSelectorList = new CSSSelectorListImpl(this.fText);
        }
    }
}

