"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var getClasses_1 = require("./getClasses");
var createExports_1 = require("./createExports");
exports.getDtsSnapshot = function (ts, processor, fileName, scriptSnapshot, options, logger) {
    var css = scriptSnapshot.getText(0, scriptSnapshot.getLength());
    /*
     * TODO: Temporary workaround for:
     * https://github.com/mrmckeb/typescript-plugin-css-modules/issues/41
     * Needs investigation for a more elegant solution.
     */
    if (/export default classes/.test(css)) {
        return scriptSnapshot;
    }
    var classes = getClasses_1.getClasses(processor, css, fileName, options, logger);
    var dts = createExports_1.createExports(classes, options);
    return ts.ScriptSnapshot.fromString(dts);
};
