/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.FormLayout.gef.header.layout;

import java.text.MessageFormat;
import org.eclipse.wb.core.gef.command.EditCommand;
import org.eclipse.wb.core.gef.figure.TextFeedback;
import org.eclipse.wb.core.gef.header.AbstractHeaderLayoutEditPolicy;
import org.eclipse.wb.core.gef.policy.layout.grid.AbstractGridLayoutEditPolicy;
import org.eclipse.wb.core.gef.policy.layout.grid.IGridInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.FigureUtils;
import org.eclipse.wb.draw2d.Layer;
import org.eclipse.wb.draw2d.geometry.Interval;
import org.eclipse.wb.draw2d.geometry.Point;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.draw2d.geometry.Translatable;
import org.eclipse.wb.gef.core.Command;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.policies.EditPolicy;
import org.eclipse.wb.gef.core.requests.ChangeBoundsRequest;
import org.eclipse.wb.gef.core.requests.IDropRequest;
import org.eclipse.wb.gef.core.requests.Request;
import org.eclipse.wb.gef.graphical.policies.LayoutEditPolicy;
import org.eclipse.wb.internal.swing.FormLayout.gef.FormLayoutEditPolicy;
import org.eclipse.wb.internal.swing.FormLayout.gef.GefMessages;
import org.eclipse.wb.internal.swing.FormLayout.gef.header.edit.ColumnHeaderEditPart;
import org.eclipse.wb.internal.swing.FormLayout.gef.header.selection.ColumnSelectionEditPolicy;
import org.eclipse.wb.internal.swing.FormLayout.model.FormColumnInfo;
import org.eclipse.wb.internal.swing.FormLayout.model.FormLayoutInfo;

public final class ColumnsLayoutEditPolicy
extends AbstractHeaderLayoutEditPolicy {
    private final FormLayoutEditPolicy m_mainPolicy;
    private final FormLayoutInfo m_layout;
    private final Figure m_insertFeedback = AbstractGridLayoutEditPolicy.createInsertFigure();
    private TextFeedback m_feedback;
    private Command m_moveCommand;

    public ColumnsLayoutEditPolicy(FormLayoutEditPolicy mainPolicy, FormLayoutInfo layout) {
        super((LayoutEditPolicy)mainPolicy);
        this.m_mainPolicy = mainPolicy;
        this.m_layout = layout;
    }

    protected void decorateChild(EditPart child) {
        child.installEditPolicy((Object)"Selection Feedback", (EditPolicy)new ColumnSelectionEditPolicy((LayoutEditPolicy)this.m_mainPolicy));
    }

    protected Command getMoveCommand(ChangeBoundsRequest request) {
        if (!this.m_layout.canChangeDimensions()) {
            return null;
        }
        return this.m_moveCommand;
    }

    protected void showLayoutTargetFeedback(Request request) {
        FormColumnInfo column;
        int x;
        int index;
        ChangeBoundsRequest changeBoundsRequest = (ChangeBoundsRequest)request;
        ColumnHeaderEditPart headerEditPart = (ColumnHeaderEditPart)((Object)changeBoundsRequest.getEditParts().get(0));
        IDropRequest dropRequest = (IDropRequest)request;
        Point location = dropRequest.getLocation().getCopy();
        ColumnHeaderEditPart target = null;
        for (EditPart editPart : this.getHost().getChildren()) {
            ColumnHeaderEditPart columnEditPart = (ColumnHeaderEditPart)editPart;
            Rectangle bounds = columnEditPart.getFigure().getBounds();
            if (location.x >= bounds.getCenter().x) continue;
            target = columnEditPart;
            break;
        }
        IGridInfo gridInfo = this.m_layout.getGridInfo();
        Interval[] columnIntervals = gridInfo.getColumnIntervals();
        Interval[] rowIntervals = gridInfo.getRowIntervals();
        int y1 = rowIntervals[0].begin - 5;
        int y2 = rowIntervals[rowIntervals.length - 1].end() + 5;
        int size = 7;
        if (target != null) {
            FormColumnInfo prevColumn;
            index = target.getIndex();
            x = columnIntervals[index].begin - size / 2;
            column = this.m_layout.getColumns().get(index);
            if (column.isGap()) {
                x = columnIntervals[index].begin;
                size = columnIntervals[index].length + 1;
            } else if (index != 0 && (prevColumn = this.m_layout.getColumns().get(index - 1)).isGap()) {
                x = columnIntervals[index - 1].begin;
                size = columnIntervals[index - 1].length + 1;
                --index;
            }
        } else {
            index = this.m_layout.getColumns().size();
            this.m_mainPolicy.showInsertFeedbacks(null, null);
            x = columnIntervals[columnIntervals.length - 1].end() - size / 2;
        }
        this.m_mainPolicy.showInsertFeedbacks(new Rectangle(x, y1, size, y2 - y1), null);
        if (this.m_insertFeedback.getParent() == null) {
            this.addFeedback(this.m_insertFeedback);
        }
        Point offset = headerEditPart.getOffset();
        Rectangle bounds = new Rectangle(x + offset.x, 0, size, this.getHostFigure().getSize().height);
        this.m_insertFeedback.setBounds(bounds);
        Layer feedbackLayer = this.getMainLayer("Feedback Layer");
        if (this.m_feedback == null) {
            this.m_feedback = new TextFeedback(feedbackLayer);
            this.m_feedback.add();
        }
        Point feedbackLocation = new Point(location.x + 30, 10);
        FigureUtils.translateAbsoluteToFigure((Figure)feedbackLayer, (Translatable)feedbackLocation);
        this.m_feedback.setLocation(feedbackLocation);
        this.m_feedback.setText(MessageFormat.format(GefMessages.ColumnsLayoutEditPolicy_feedbackPattern, 1 + index));
        column = (FormColumnInfo)headerEditPart.getDimension();
        final int targetIndex = index;
        this.m_moveCommand = new EditCommand((ObjectInfo)this.m_layout){

            protected void executeEdit() throws Exception {
                ColumnsLayoutEditPolicy.this.m_layout.command_MOVE_COLUMN(ColumnsLayoutEditPolicy.this.m_layout.getColumns().indexOf(column), targetIndex);
            }
        };
    }

    protected void eraseLayoutTargetFeedback(Request request) {
        this.m_mainPolicy.eraseInsertFeedbacks();
        FigureUtils.removeFigure((Figure)this.m_insertFeedback);
        if (this.m_feedback != null) {
            this.m_feedback.remove();
            this.m_feedback = null;
        }
    }
}

