/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.validation.core;

import java.util.Map;
import java.util.function.Consumer;
import org.apache.log4j.Logger;
import org.eclipse.viatra.addon.validation.core.Constraint;
import org.eclipse.viatra.addon.validation.core.Violation;
import org.eclipse.viatra.addon.validation.core.violationkey.ViolationKey;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.emf.helper.ViatraQueryRuntimeHelper;

public class MatchDisappearanceJob
implements Consumer<IPatternMatch> {
    private Constraint constraint;
    private Logger logger;

    public MatchDisappearanceJob(Constraint constraint, Logger logger) {
        this.constraint = constraint;
        this.logger = logger;
    }

    @Override
    public void accept(IPatternMatch match) {
        Map<String, Object> keyObjectMap = this.constraint.getSpecification().getKeyObjects(match);
        if (!keyObjectMap.isEmpty()) {
            ViolationKey key = this.constraint.getViolationKey(match);
            Violation violation = this.constraint.getViolation(key);
            if (violation == null) {
                violation = new Violation();
                violation.setConstraint(this.constraint);
                violation.setKeyObjects(this.constraint.getSpecification().getKeyObjects(match));
                violation.setMessage(ViatraQueryRuntimeHelper.getMessage((IPatternMatch)match, (String)this.constraint.getSpecification().getMessageFormat()));
                this.constraint.addViolation(key, violation);
            }
            if (violation.removeMatch(match)) {
                violation.notifyListenersViolationEntryDisappeared(match);
            }
            if (violation.getMatches().isEmpty()) {
                this.constraint.removeViolation(key);
                this.constraint.notifyListenersViolationDisappeared(violation);
            }
        } else {
            this.logger.error((Object)"Error getting Violation key objects!");
        }
    }
}

