/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.SegmentStoreStatisticsModel;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.statistics.AbstractSegmentStatisticsAnalysis;
import org.eclipse.tracecompass.analysis.timing.core.statistics.IStatistics;
import org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore.Messages;
import org.eclipse.tracecompass.internal.tmf.core.model.AbstractTmfTraceDataProvider;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderParameterUtils;
import org.eclipse.tracecompass.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataProvider;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class SegmentStoreStatisticsDataProvider
extends AbstractTmfTraceDataProvider
implements ITmfTreeDataProvider<SegmentStoreStatisticsModel> {
    public static final String ID = "org.eclipse.tracecompass.analysis.timing.core.segmentstore.SegmentStoreStatisticsDataProvider";
    private static final String STATISTICS_SUFFIX = ".statistics";
    private static final String TOTAL_PREFIX = "Total_";
    private static final String SELECTION_PREFIX = "Selection_";
    private static final Map<AbstractSegmentStatisticsAnalysis, SegmentStoreStatisticsDataProvider> PROVIDER_MAP = new WeakHashMap<AbstractSegmentStatisticsAnalysis, SegmentStoreStatisticsDataProvider>();
    private static final AtomicLong ENTRY_ID = new AtomicLong();
    private final AbstractSegmentStatisticsAnalysis fProvider;
    private final String fId;
    private final Map<String, Long> fIdToType = new HashMap<String, Long>();
    private final long fTraceId = ENTRY_ID.getAndIncrement();

    public static synchronized @Nullable SegmentStoreStatisticsDataProvider getOrCreate(ITmfTrace trace, AbstractSegmentStatisticsAnalysis module) {
        return PROVIDER_MAP.computeIfAbsent(module, p -> new SegmentStoreStatisticsDataProvider(trace, (AbstractSegmentStatisticsAnalysis)((Object)p), String.valueOf(module.getId()) + STATISTICS_SUFFIX));
    }

    public SegmentStoreStatisticsDataProvider(ITmfTrace trace, AbstractSegmentStatisticsAnalysis provider, String id) {
        super(trace);
        this.fId = id;
        this.fProvider = provider;
    }

    public TmfModelResponse<TmfTreeModel<SegmentStoreStatisticsModel>> fetchTree(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        IStatistics<ISegment> statsTotal;
        if (monitor != null) {
            this.fProvider.waitForCompletion(monitor);
            if (monitor.isCanceled()) {
                return new TmfModelResponse(null, ITmfResponse.Status.CANCELLED, CommonStatusMessage.TASK_CANCELLED);
            }
        } else {
            this.fProvider.waitForCompletion();
        }
        if ((statsTotal = this.fProvider.getStatsTotal()) == null) {
            return new TmfModelResponse(null, ITmfResponse.Status.FAILED, CommonStatusMessage.ANALYSIS_INITIALIZATION_FAILED);
        }
        ArrayList<SegmentStoreStatisticsModel> list = new ArrayList<SegmentStoreStatisticsModel>();
        list.add(new SegmentStoreStatisticsModel(this.fTraceId, -1L, Collections.singletonList(Objects.requireNonNull(this.getTrace().getName())), statsTotal));
        long totalId = this.getUniqueId(TOTAL_PREFIX);
        list.add(new SegmentStoreStatisticsModel(totalId, this.fTraceId, Collections.singletonList(Objects.requireNonNull(Messages.SegmentStoreStatisticsDataProvider_Total)), statsTotal));
        Map<String, IStatistics<ISegment>> totalStats = this.fProvider.getStatsPerType();
        for (Map.Entry<String, IStatistics<ISegment>> entry : totalStats.entrySet()) {
            list.add(new SegmentStoreStatisticsModel(this.getUniqueId(TOTAL_PREFIX + entry.getKey()), totalId, Collections.singletonList(entry.getKey()), entry.getValue()));
        }
        TimeQueryFilter filter = FetchParametersUtils.createTimeQuery(fetchParameters);
        Boolean isFiltered = DataProviderParameterUtils.extractIsFiltered(fetchParameters);
        if (filter != null && isFiltered != null && isFiltered.booleanValue()) {
            IProgressMonitor nonNullMonitor;
            long end;
            long start = filter.getStart();
            IStatistics<ISegment> statsForRange = this.fProvider.getStatsForRange(start, end = filter.getEnd(), nonNullMonitor = monitor != null ? monitor : new NullProgressMonitor());
            if (statsForRange == null) {
                return new TmfModelResponse(null, ITmfResponse.Status.CANCELLED, CommonStatusMessage.TASK_CANCELLED);
            }
            long selectionId = this.getUniqueId(SELECTION_PREFIX);
            list.add(new SegmentStoreStatisticsModel(selectionId, this.fTraceId, Collections.singletonList(Objects.requireNonNull(Messages.SegmentStoreStatisticsDataProvider_Selection)), statsForRange));
            Map<String, IStatistics<ISegment>> selectionStats = this.fProvider.getStatsPerTypeForRange(start, end, nonNullMonitor);
            for (Map.Entry<String, IStatistics<ISegment>> entry : selectionStats.entrySet()) {
                list.add(new SegmentStoreStatisticsModel(this.getUniqueId(SELECTION_PREFIX + entry.getKey()), selectionId, Collections.singletonList(entry.getKey()), entry.getValue()));
            }
        }
        return new TmfModelResponse((Object)new TmfTreeModel(Collections.emptyList(), Collections.unmodifiableList(list)), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getUniqueId(String name) {
        Map<String, Long> map = this.fIdToType;
        synchronized (map) {
            return this.fIdToType.computeIfAbsent(name, n -> ENTRY_ID.getAndIncrement());
        }
    }

    public String getId() {
        return this.fId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Map<String, Long> map = this.fIdToType;
        synchronized (map) {
            this.fIdToType.clear();
        }
        this.fProvider.dispose();
    }
}

