/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.phpunit.ui.wizards.templates;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.php.internal.ui.preferences.includepath.IncludePathUtils;
import org.eclipse.php.phpunit.ui.wizards.templates.TestTemplate;

public abstract class TestCaseTemplate
extends TestTemplate {
    private static final String MASTER_ELEMENT_NAME = "MasterElementName";
    private static final String MASTER_ELEMENT_STATIC_METHOD = "MasterElementStaticMethod";
    private static final String MASTER_ELEMENT_DYNAMIC_METHOD = "MasterElementDynamicMethod";
    private static final String MASTER_ELEMENT_DESTRUCTOR = "MasterElementDestructor";
    private static final String MASTER_ELEMENT_CALL = "MasterElementCall";
    private static final String MASTER_ELEMENT_CONSTRUCTOR = "MasterElementConstructor";
    private static final String MASTER_ELEMENT_DEFINITION = "MasterElementDefinition";

    public void setMasterElement(IModelElement masterElement, String masterElementName, IProject project) {
        boolean empty;
        boolean bl = empty = masterElement != null;
        if (empty) {
            IScriptProject sProject = DLTKCore.create((IProject)project);
            IPath relativeLocationFromIncludePath = IncludePathUtils.getRelativeLocationFromIncludePath((IScriptProject)sProject, (IModelElement)masterElement);
            String path = null;
            if (!relativeLocationFromIncludePath.isEmpty()) {
                path = relativeLocationFromIncludePath.toOSString();
            }
            this.setMasterElementParams(masterElement.getElementName(), path);
        } else {
            this.setMasterElementParams(masterElementName, null);
        }
    }

    void setMasterElementParams(String name, String relativeLocation) {
        this.extract("input", MASTER_ELEMENT_DEFINITION, MASTER_ELEMENT_DEFINITION);
        this.extract("input", MASTER_ELEMENT_CONSTRUCTOR, MASTER_ELEMENT_CONSTRUCTOR);
        this.extract("input", MASTER_ELEMENT_CALL, MASTER_ELEMENT_CALL);
        this.extract("input", MASTER_ELEMENT_DESTRUCTOR, MASTER_ELEMENT_DESTRUCTOR);
        this.extract("input", MASTER_ELEMENT_DYNAMIC_METHOD, MASTER_ELEMENT_DYNAMIC_METHOD);
        this.extract("input", MASTER_ELEMENT_STATIC_METHOD, MASTER_ELEMENT_STATIC_METHOD);
        if ("".equals(name)) {
            this.set(MASTER_ELEMENT_DEFINITION, "");
            this.set(MASTER_ELEMENT_CONSTRUCTOR, "");
            this.set(MASTER_ELEMENT_CALL, "");
            this.set(MASTER_ELEMENT_DESTRUCTOR, "");
            this.set(MASTER_ELEMENT_DYNAMIC_METHOD, "");
            this.set(MASTER_ELEMENT_STATIC_METHOD, "");
        } else {
            this.compile(MASTER_ELEMENT_DEFINITION, MASTER_ELEMENT_DEFINITION, false);
            this.compile(MASTER_ELEMENT_CONSTRUCTOR, MASTER_ELEMENT_CONSTRUCTOR, false);
            this.compile(MASTER_ELEMENT_CALL, MASTER_ELEMENT_CALL, false);
            this.compile(MASTER_ELEMENT_DESTRUCTOR, MASTER_ELEMENT_DESTRUCTOR, false);
            this.compile(MASTER_ELEMENT_DYNAMIC_METHOD, MASTER_ELEMENT_DYNAMIC_METHOD, false);
            this.compile(MASTER_ELEMENT_STATIC_METHOD, MASTER_ELEMENT_STATIC_METHOD, false);
        }
        this.set(MASTER_ELEMENT_NAME, name);
        if (relativeLocation != null) {
            this.addRequire(relativeLocation);
        }
    }
}

