/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.debug.vm.ui.actions;

import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ocl.examples.debug.vm.core.VMLineBreakpoint;
import org.eclipse.ocl.examples.debug.vm.ui.DebugVMUIPlugin;
import org.eclipse.ocl.examples.debug.vm.ui.actions.BreakpointLocationVerifier;
import org.eclipse.ocl.examples.debug.vm.ui.messages.DebugVMUIMessages;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;

public abstract class VMToggleBreakpointAdapter
implements IToggleBreakpointsTarget {
    public void toggleLineBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        final ITextEditor oclEditor = (ITextEditor)part;
        IResource unitFile = (IResource)ClassUtil.getAdapter((IAdaptable)oclEditor.getEditorInput(), IResource.class);
        if (unitFile == null) {
            return;
        }
        ITextSelection textSelection = (ITextSelection)selection;
        int lineNumber = textSelection.getStartLine() + 1;
        List<@NonNull ILineBreakpoint> breakpoints = this.getOCLBreakpoints();
        for (ILineBreakpoint next : breakpoints) {
            if (!unitFile.equals((Object)next.getMarker().getResource()) || next.getLineNumber() != lineNumber) continue;
            try {
                DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)next, true);
            }
            catch (CoreException e) {
                DebugVMUIPlugin.log(e.getStatus());
            }
            next.delete();
            return;
        }
        @NonNull URI sourceURI = URI.createPlatformResourceURI((String)unitFile.getFullPath().toString(), (boolean)true);
        final VMLineBreakpoint lineBreakpoint = this.createLineBreakpoint(lineNumber, sourceURI);
        lineBreakpoint.register(true);
        Job job = new Job(DebugVMUIMessages.ToggleBreakpointAdapter_VerifyBreakpointJob){

            protected IStatus run(IProgressMonitor monitor) {
                return VMToggleBreakpointAdapter.this.createBreakpointLocationVerifier(oclEditor, lineBreakpoint).run();
            }

            public boolean belongsTo(Object family) {
                return VMToggleBreakpointAdapter.this.getBreakpointJobFamily() == family;
            }
        };
        job.setPriority(10);
        job.setSystem(true);
        job.schedule();
    }

    public boolean canToggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    protected abstract @NonNull BreakpointLocationVerifier createBreakpointLocationVerifier(@NonNull ITextEditor var1, @NonNull VMLineBreakpoint var2);

    protected abstract @NonNull VMLineBreakpoint createLineBreakpoint(int var1, @NonNull URI var2) throws CoreException;

    protected abstract @NonNull Object getBreakpointJobFamily();

    protected abstract @NonNull List<@NonNull ILineBreakpoint> getOCLBreakpoints();

    public void toggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public void toggleWatchpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }
}

