/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.internal.collectionextract;

import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.inspections.collectionextract.AbstractExtractedCollection;
import org.eclipse.mat.inspections.collectionextract.CollectionExtractionUtils;
import org.eclipse.mat.inspections.collectionextract.ExtractedCollection;
import org.eclipse.mat.inspections.collectionextract.ExtractedMap;
import org.eclipse.mat.inspections.collectionextract.ICollectionExtractor;
import org.eclipse.mat.inspections.collectionextract.IMapExtractor;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IObjectArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WrapperCollectionExtractor
implements ICollectionExtractor {
    private final String field;
    private final ICollectionExtractor extractor;

    public WrapperCollectionExtractor(String field) {
        this(field, null);
    }

    public WrapperCollectionExtractor(String field, ICollectionExtractor extractor) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        this.field = field;
        this.extractor = extractor;
    }

    @Override
    public boolean hasSize() {
        return true;
    }

    @Override
    public Integer getSize(IObject coll) throws SnapshotException {
        AbstractExtractedCollection<?, ?> extractCollection = this.extractCollection(coll);
        return extractCollection != null ? extractCollection.size() : null;
    }

    @Override
    public boolean hasCapacity() {
        return true;
    }

    @Override
    public Integer getCapacity(IObject coll) throws SnapshotException {
        AbstractExtractedCollection<?, ?> extractCollection = this.extractCollection(coll);
        return extractCollection != null ? this.extractCollection(coll).getCapacity() : null;
    }

    @Override
    public boolean hasFillRatio() {
        return true;
    }

    @Override
    public Double getFillRatio(IObject coll) throws SnapshotException {
        AbstractExtractedCollection<?, ?> extractCollection = this.extractCollection(coll);
        return extractCollection != null ? extractCollection.getFillRatio() : null;
    }

    @Override
    public boolean hasExtractableContents() {
        return true;
    }

    @Override
    public int[] extractEntryIds(IObject coll) throws SnapshotException {
        return this.extractCollection(coll).extractEntryIds();
    }

    @Override
    public boolean hasExtractableArray() {
        return true;
    }

    @Override
    public IObjectArray extractEntries(IObject coll) throws SnapshotException {
        return this.extractCollection(coll).extractEntries();
    }

    @Override
    public Integer getNumberOfNotNullElements(IObject coll) throws SnapshotException {
        return this.extractList(coll).getNumberOfNotNullElements();
    }

    private String desc(String msg, IObject coll, AbstractExtractedCollection<?, ?> ec) {
        if (ec != null) {
            return String.valueOf(msg) + coll.getDisplayName() + "; " + ec.getDisplayName();
        }
        try {
            Object coll2 = coll.resolveValue(this.field);
            if (coll2 instanceof IObject) {
                return String.valueOf(msg) + coll.getDisplayName() + "; " + ((IObject)coll2).getDisplayName();
            }
        }
        catch (SnapshotException snapshotException) {
            // empty catch block
        }
        return String.valueOf(msg) + coll.getDisplayName();
    }

    protected ExtractedCollection extractList(IObject coll) {
        AbstractExtractedCollection<?, ?> ec = this.extractCollection(coll);
        if (ec instanceof ExtractedCollection) {
            return (ExtractedCollection)ec;
        }
        throw new UnsupportedOperationException(this.desc("not a list-ish collection: ", coll, ec));
    }

    protected ExtractedMap extractMap(IObject coll) {
        AbstractExtractedCollection<?, ?> ec = this.extractCollection(coll);
        if (ec instanceof ExtractedMap) {
            return (ExtractedMap)ec;
        }
        throw new UnsupportedOperationException(this.desc("not a map: ", coll, ec));
    }

    protected AbstractExtractedCollection<?, ?> extractCollection(IObject coll) {
        try {
            IObject value = (IObject)coll.resolveValue(this.field);
            if (value == null) {
                return this.guessWrappedFromOutbounds(coll);
            }
            if (this.extractor == null) {
                return CollectionExtractionUtils.extractCollection(value);
            }
            if (this.extractor instanceof IMapExtractor) {
                return new ExtractedMap(value, (IMapExtractor)this.extractor);
            }
            return new ExtractedCollection(value, this.extractor);
        }
        catch (SnapshotException e) {
            throw new RuntimeException(e);
        }
    }

    private AbstractExtractedCollection<?, ?> guessWrappedFromOutbounds(IObject coll) throws SnapshotException {
        int[] outbounds;
        ISnapshot snapshot = coll.getSnapshot();
        AbstractExtractedCollection<?, ?> extracted = null;
        int[] nArray = outbounds = snapshot.getOutboundReferentIds(coll.getObjectId());
        int n = outbounds.length;
        int n2 = 0;
        while (n2 < n) {
            int outId = nArray[n2];
            AbstractExtractedCollection<?, ?> ex = CollectionExtractionUtils.extractCollection(snapshot.getObject(outId));
            if (ex != null) {
                if (extracted == null) {
                    extracted = ex;
                } else {
                    throw new IllegalArgumentException("Could not resolve field " + this.field + " of " + coll.getTechnicalName() + " (found multiple outbound references to collections)");
                }
            }
            ++n2;
        }
        if (extracted != null) {
            return extracted;
        }
        throw new IllegalArgumentException("Could not resolve field " + this.field + " of " + coll.getTechnicalName() + " (found no outbound references to collections)");
    }
}

