/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.consolelog.structures;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.linuxtools.internal.systemtap.ui.consolelog.structures.ErrorStreamDaemon;
import org.eclipse.linuxtools.systemtap.graphing.ui.widgets.ExceptionErrorDialog;
import org.eclipse.linuxtools.systemtap.structures.listeners.IGobblerListener;
import org.eclipse.linuxtools.systemtap.structures.runnable.Command;
import org.eclipse.linuxtools.systemtap.ui.consolelog.ScpExec;
import org.eclipse.linuxtools.systemtap.ui.consolelog.internal.Localization;
import org.eclipse.linuxtools.systemtap.ui.consolelog.structures.ConsoleStreamDaemon;
import org.eclipse.linuxtools.systemtap.ui.consolelog.structures.IErrorParser;
import org.eclipse.linuxtools.systemtap.ui.consolelog.structures.RemoteScriptOptions;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IOConsole;

public class ScriptConsole
extends IOConsole {
    private static final String STAP_CONSOLE_TYPE = "stap";
    private Command cmd = null;
    private final StopCommand stopCommand = new StopCommand();
    private Thread stopCommandThread;
    private Thread onCmdStopThread;
    private Thread onCmdStartThread;
    private ErrorStreamDaemon errorDaemon;
    private ConsoleStreamDaemon consoleDaemon;
    private final Set<ScriptConsoleObserver> activeConsoleObservers = new HashSet<ScriptConsoleObserver>();
    private final Set<ScriptConsoleObserver> inactiveConsoleObservers = new HashSet<ScriptConsoleObserver>();
    private final Runnable onCmdStart = new Runnable(){

        @Override
        public void run() {
            if (ScriptConsole.this.isThreadAlive(ScriptConsole.this.stopCommandThread) && ScriptConsole.this.stopCommand.stopcmd != ScriptConsole.this.cmd) {
                try {
                    ScriptConsole.this.stopCommandThread.join();
                }
                catch (InterruptedException e) {
                    return;
                }
            }
            if (ScriptConsole.this.errorDaemon != null) {
                ScriptConsole.this.cmd.addErrorStreamListener((IGobblerListener)ScriptConsole.this.errorDaemon);
            }
            ScriptConsole.this.cmd.addInputStreamListener((IGobblerListener)ScriptConsole.this.consoleDaemon);
            ScriptConsole.this.onCmdStopThread = new Thread(ScriptConsole.this.onCmdStop);
            ScriptConsole.this.onCmdStopThread.start();
            ScriptConsole.this.clearConsole();
            try {
                ScriptConsole.this.cmd.start();
            }
            catch (CoreException e) {
                ExceptionErrorDialog.openError((String)Localization.getString("ScriptConsole.ErrorRunningStapTitle"), (String)Localization.getString("ScriptConsole.ErrorRunningStapMessage"), (Exception)((Object)e));
                ScriptConsole.this.cmd.dispose();
                return;
            }
            ScriptConsole.this.notifyConsoleObservers();
        }
    };
    private final Runnable onCmdStop = () -> {
        try {
            Command command = this.cmd;
            synchronized (command) {
                while (this.cmd.isRunning()) {
                    this.cmd.wait();
                }
                this.onCmdStopActions();
            }
        }
        catch (InterruptedException e) {
            return;
        }
    };

    public static boolean instanceIsRunning(String name) {
        IConsole[] ic = ConsolePlugin.getDefault().getConsoleManager().getConsoles();
        if (ic != null) {
            IConsole[] iConsoleArray = ic;
            int n = ic.length;
            int n2 = 0;
            while (n2 < n) {
                ScriptConsole activeConsole;
                IConsole consoleIterator = iConsoleArray[n2];
                if (consoleIterator instanceof ScriptConsole && (activeConsole = (ScriptConsole)consoleIterator).getBaseName().equals(name) && activeConsole.isRunning()) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static synchronized ScriptConsole getInstance(String name) {
        IConsole[] ic = ConsolePlugin.getDefault().getConsoleManager().getConsoles();
        if (ic != null) {
            IConsole[] iConsoleArray = ic;
            int n = ic.length;
            int n2 = 0;
            while (n2 < n) {
                ScriptConsole activeConsole;
                IConsole consoleIterator = iConsoleArray[n2];
                if (consoleIterator instanceof ScriptConsole && (activeConsole = (ScriptConsole)consoleIterator).getBaseName().equals(name)) {
                    activeConsole.reset();
                    return activeConsole;
                }
                ++n2;
            }
        }
        ScriptConsole console = new ScriptConsole(name, null);
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{console});
        return console;
    }

    public static boolean anyRunning() {
        IConsole[] ic;
        IConsole[] iConsoleArray = ic = ConsolePlugin.getDefault().getConsoleManager().getConsoles();
        int n = ic.length;
        int n2 = 0;
        while (n2 < n) {
            ScriptConsole console;
            IConsole con = iConsoleArray[n2];
            if (con instanceof ScriptConsole && (console = (ScriptConsole)con).isRunning()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static void stopAll() {
        IConsole[] ic;
        IConsole[] iConsoleArray = ic = ConsolePlugin.getDefault().getConsoleManager().getConsoles();
        int n = ic.length;
        int n2 = 0;
        while (n2 < n) {
            IConsole con = iConsoleArray[n2];
            if (con instanceof ScriptConsole) {
                ScriptConsole console = (ScriptConsole)con;
                console.stop();
            }
            ++n2;
        }
    }

    ScriptConsole(String name, ImageDescriptor imageDescriptor) {
        super(name, STAP_CONSOLE_TYPE, imageDescriptor);
    }

    private void createConsoleDaemon() {
        this.consoleDaemon = new ConsoleStreamDaemon(this);
    }

    public synchronized void run(String[] command, String[] envVars, RemoteScriptOptions remoteOptions, IErrorParser errorParser) {
        if (this.waitingToStart()) {
            return;
        }
        this.cmd = new ScpExec(command, remoteOptions, envVars);
        this.internalRun(errorParser);
    }

    public synchronized void runLocally(String[] command, String[] envVars, IErrorParser errorParser, IProject project) {
        if (this.waitingToStart()) {
            return;
        }
        this.cmd = new Command(command, envVars, project);
        this.internalRun(errorParser);
    }

    private void internalRun(IErrorParser errorParser) {
        if (this.hasStarted()) {
            this.reset();
        }
        if (errorParser != null) {
            this.errorDaemon = new ErrorStreamDaemon(this);
        }
        this.createConsoleDaemon();
        this.notifyConsoleObservers();
        this.activate();
        this.onCmdStartThread = new Thread(this.onCmdStart);
        this.onCmdStartThread.start();
    }

    private void onCmdStopActions() {
        this.notifyConsoleObservers();
        String name = super.getName();
        Display.getDefault().asyncExec(() -> this.setName(String.valueOf(Localization.getString("ScriptConsole.Terminated")) + name));
    }

    public synchronized void stop() {
        this.stopCommand.start(this.cmd, this.errorDaemon, this.consoleDaemon, false);
    }

    private synchronized void stopAndDispose() {
        this.stopCommand.start(this.cmd, this.errorDaemon, this.consoleDaemon, true);
    }

    private void reset() {
        if (this.waitingToStart()) {
            try {
                this.onCmdStartThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.isThreadAlive(this.onCmdStopThread)) {
            this.onCmdStopThread.interrupt();
            try {
                this.onCmdStopThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.isThreadAlive(this.stopCommandThread)) {
            try {
                this.stopCommandThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.disposeCommand();
        } else if (this.isRunning()) {
            this.stopAndDispose();
        } else {
            this.disposeCommand();
        }
        this.clearConsole();
        this.setName(this.getBaseName());
    }

    private synchronized void notifyConsoleObservers() {
        boolean started = this.hasStarted();
        boolean running = this.isRunning();
        for (ScriptConsoleObserver observer : this.inactiveConsoleObservers) {
            this.activeConsoleObservers.remove(observer);
        }
        this.inactiveConsoleObservers.clear();
        for (ScriptConsoleObserver observer : this.activeConsoleObservers) {
            observer.runningStateChanged(started, !running);
        }
    }

    public synchronized void addScriptConsoleObserver(ScriptConsoleObserver observer) {
        this.activeConsoleObservers.add(observer);
        observer.runningStateChanged(this.hasStarted(), !this.isRunning());
    }

    public synchronized void removeScriptConsoleObserver(ScriptConsoleObserver observer) {
        this.inactiveConsoleObservers.add(observer);
    }

    public void saveStream(File file) {
        this.saveStreamAndReturnResult(file);
    }

    public boolean saveStreamAndReturnResult(File file) {
        if (!this.cmd.saveLog(file)) {
            MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Localization.getString("ScriptConsole.Problem"), (String)Localization.getString("ScriptConsole.ErrorSavingLog"));
            return false;
        }
        return true;
    }

    private boolean waitingToStart() {
        return this.isThreadAlive(this.onCmdStartThread);
    }

    public boolean isRunning() {
        return this.cmd == null ? false : this.cmd.isRunning();
    }

    private boolean hasStarted() {
        return this.cmd == null ? false : this.cmd.hasStarted();
    }

    public boolean isDisposed() {
        if (this.cmd == null) {
            return true;
        }
        return this.cmd.isDisposed();
    }

    private void disposeCommand() {
        if (!this.isDisposed()) {
            this.cmd.dispose();
        }
    }

    public Command getCommand() {
        return this.cmd;
    }

    public Process getProcess() {
        return this.cmd != null ? this.cmd.getProcess() : null;
    }

    private String getBaseName() {
        return this.getName().replace(Localization.getString("ScriptConsole.Terminated"), "");
    }

    private boolean isThreadAlive(Thread thread) {
        return thread != null && thread.isAlive();
    }

    public synchronized void dispose() {
        if (!this.isDisposed()) {
            this.onCmdStartThread = null;
            this.onCmdStopThread = null;
            this.stopCommandThread = null;
            if (this.cmd != null) {
                this.cmd.dispose();
            }
            this.cmd = null;
            if (this.errorDaemon != null) {
                this.errorDaemon.dispose();
            }
            this.errorDaemon = null;
            if (this.consoleDaemon != null) {
                this.consoleDaemon.dispose();
            }
            this.consoleDaemon = null;
            this.stopCommand.dispose();
            if (this.activeConsoleObservers != null) {
                this.activeConsoleObservers.clear();
            }
            if (this.inactiveConsoleObservers != null) {
                this.inactiveConsoleObservers.clear();
            }
        }
    }

    public static interface ScriptConsoleObserver {
        public void runningStateChanged(boolean var1, boolean var2);
    }

    private class StopCommand
    implements Runnable {
        private Command stopcmd;
        private ErrorStreamDaemon stopErrorDaemon;
        private ConsoleStreamDaemon stopConsoleDaemon;
        private boolean disposeOnStop = false;

        private StopCommand() {
        }

        void start(Command stopcmd, ErrorStreamDaemon stopErrorDaemon, ConsoleStreamDaemon stopConsoleDaemon, boolean disposeOnStop) {
            if (ScriptConsole.this.isRunning() && !ScriptConsole.this.isThreadAlive(ScriptConsole.this.stopCommandThread)) {
                this.stopcmd = stopcmd;
                this.stopErrorDaemon = stopErrorDaemon;
                this.stopConsoleDaemon = stopConsoleDaemon;
                this.disposeOnStop = disposeOnStop;
                ScriptConsole.this.stopCommandThread = new Thread(this);
                ScriptConsole.this.stopCommandThread.start();
            }
        }

        @Override
        public void run() {
            if (ScriptConsole.this.isThreadAlive(ScriptConsole.this.onCmdStartThread) && this.stopcmd == ScriptConsole.this.cmd) {
                try {
                    ScriptConsole.this.onCmdStartThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.stopConsoleDaemon != null) {
                this.stopcmd.removeInputStreamListener((IGobblerListener)this.stopConsoleDaemon);
                this.stopConsoleDaemon.dispose();
            }
            if (this.stopErrorDaemon != null) {
                this.stopcmd.removeErrorStreamListener((IGobblerListener)this.stopErrorDaemon);
                this.stopErrorDaemon.dispose();
            }
            if (!this.disposeOnStop) {
                this.stopcmd.stop();
            } else {
                this.stopcmd.dispose();
            }
        }

        void dispose() {
            if (this.stopcmd != null) {
                this.stopcmd.dispose();
                this.stopcmd = null;
            }
            if (this.stopErrorDaemon != null) {
                this.stopErrorDaemon.dispose();
                this.stopErrorDaemon = null;
            }
            if (this.stopConsoleDaemon != null) {
                this.stopConsoleDaemon.dispose();
                this.stopConsoleDaemon = null;
            }
        }
    }
}

