/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.annotations.core.initialization;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jst.ws.annotations.core.AnnotationsCore;
import org.eclipse.jst.ws.annotations.core.AnnotationsCorePlugin;
import org.eclipse.jst.ws.annotations.core.initialization.AnnotationAttributeInitializer;
import org.eclipse.jst.ws.internal.annotations.core.utils.SignatureUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultsAnnotationAttributeInitializer
extends AnnotationAttributeInitializer {
    @Override
    @Deprecated
    public List<MemberValuePair> getMemberValuePairs(IJavaElement javaElement, AST ast, Class<? extends Annotation> annotationClass) {
        return this.getMemberValuePairs(ast, annotationClass);
    }

    @Override
    public List<MemberValuePair> getMemberValuePairs(IJavaElement javaElement, AST ast, IType type) {
        return this.interalGetMemberValuePairs(javaElement, ast, type);
    }

    private List<MemberValuePair> interalGetMemberValuePairs(IJavaElement javaElement, AST ast, IType type) {
        ArrayList<MemberValuePair> memberValuePairs = new ArrayList<MemberValuePair>();
        try {
            IMethod[] methods;
            IMethod[] iMethodArray = methods = type.getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod method = iMethodArray[n2];
                String name = method.getElementName();
                String returnType = method.getReturnType();
                IMemberValuePair defaultValue = method.getDefaultValue();
                if (defaultValue != null) {
                    int signatureKind;
                    if (SignatureUtils.isString(returnType)) {
                        memberValuePairs.add(AnnotationsCore.createStringMemberValuePair(ast, name, defaultValue.getValue().toString()));
                    }
                    if (SignatureUtils.isBoolean(returnType)) {
                        memberValuePairs.add(AnnotationsCore.createBooleanMemberValuePair(ast, name, Boolean.parseBoolean(defaultValue.getValue().toString())));
                    }
                    if ((signatureKind = Signature.getTypeSignatureKind((String)returnType)) == 2 && (returnType.charAt(0) == 'B' || returnType.charAt(0) == 'S' || returnType.charAt(0) == 'I' || returnType.charAt(0) == 'J' || returnType.charAt(0) == 'F' || returnType.charAt(0) == 'D')) {
                        memberValuePairs.add(AnnotationsCore.createNumberMemberValuePair(ast, name, defaultValue.getValue().toString()));
                    }
                    if (SignatureUtils.isArray(returnType)) {
                        memberValuePairs.add(AnnotationsCore.createArrayMemberValuePair(ast, method.getElementName(), (Object[])defaultValue.getValue()));
                    }
                    if (SignatureUtils.isEnum(method) && defaultValue.getValueKind() == 12) {
                        String value = defaultValue.getValue().toString();
                        String enumName = value.substring(0, value.lastIndexOf("."));
                        String constant = value.substring(value.lastIndexOf(".") + 1, value.length());
                        IType enumType = javaElement.getJavaProject().findType(enumName);
                        if (enumType != null && enumType.isEnum()) {
                            IField[] fields;
                            IField[] iFieldArray = fields = enumType.getFields();
                            int n3 = fields.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IField field = iFieldArray[n4];
                                if (field.isEnumConstant() && field.getElementName().equals(constant)) {
                                    memberValuePairs.add(AnnotationsCore.createEnumMemberValuePair(ast, method.getDeclaringType().getFullyQualifiedName(), name, field));
                                }
                                ++n4;
                            }
                        }
                    }
                    if (SignatureUtils.isClass(returnType)) {
                        memberValuePairs.add(AnnotationsCore.createTypeMemberValuePair(ast, name, defaultValue.getValue()));
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException jme) {
            AnnotationsCorePlugin.log(jme.getStatus());
        }
        return memberValuePairs;
    }

    private List<MemberValuePair> getMemberValuePairs(AST ast, Class<? extends Annotation> annotationClass) {
        Method[] declaredMethods;
        ArrayList<MemberValuePair> memberValuePairs = new ArrayList<MemberValuePair>();
        Method[] methodArray = declaredMethods = annotationClass.getDeclaredMethods();
        int n = declaredMethods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            String name = method.getName();
            Class<?> returnType = method.getReturnType();
            Object defaultValue = method.getDefaultValue();
            if (defaultValue != null) {
                if (returnType.equals(String.class)) {
                    memberValuePairs.add(AnnotationsCore.createStringMemberValuePair(ast, name, defaultValue.toString()));
                }
                if (returnType.equals(Boolean.TYPE)) {
                    memberValuePairs.add(AnnotationsCore.createBooleanMemberValuePair(ast, name, Boolean.parseBoolean(defaultValue.toString())));
                }
                if (returnType.isPrimitive() && (returnType.equals(Byte.TYPE) || returnType.equals(Short.TYPE) || returnType.equals(Integer.TYPE) || returnType.equals(Long.TYPE) || returnType.equals(Float.TYPE) || returnType.equals(Double.TYPE))) {
                    memberValuePairs.add(AnnotationsCore.createNumberMemberValuePair(ast, name, defaultValue.toString()));
                }
                if (returnType.isArray()) {
                    memberValuePairs.add(AnnotationsCore.createArrayMemberValuePair(ast, method.getName(), (Object[])defaultValue));
                }
                if (returnType.isEnum()) {
                    memberValuePairs.add(AnnotationsCore.createEnumMemberValuePair(ast, method.getDeclaringClass().getCanonicalName(), name, defaultValue));
                }
                if (returnType.equals(Class.class)) {
                    memberValuePairs.add(AnnotationsCore.createTypeMemberValuePair(ast, name, defaultValue));
                }
            }
            ++n2;
        }
        return memberValuePairs;
    }
}

